/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.pathmatcher;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PathNormalizer {
    private static final char SEPARATOR_CHAR = '/';
    private final String basedir;
    private final String basepath;

    public PathNormalizer(Path basedir) {
        this.basepath = PathNormalizer.normalize0(basedir);
        this.basedir = String.valueOf(this.basepath) + '/';
    }

    public String getBasedir() {
        return this.basedir;
    }

    public String normalize(String file) {
        if ((file = Paths.get(file, new String[0]).normalize().toString()).startsWith(this.basedir) || this.basepath.equals(file)) {
            return file;
        }
        return PathNormalizer.normalize0(file);
    }

    public String normalize(Path file) {
        String path = file.toAbsolutePath().normalize().toString();
        if (file.toAbsolutePath().startsWith(this.basedir) || this.basepath.equals(file.toAbsolutePath().toString())) {
            return path;
        }
        return PathNormalizer.normalize0(file);
    }

    public static String normalize0(Path file) {
        String normalized;
        try {
            normalized = file.toFile().getCanonicalPath();
        }
        catch (IOException iOException) {
            normalized = file.toAbsolutePath().toString();
        }
        return normalized;
    }

    public static String normalize0(String file) {
        return PathNormalizer.normalize0(Paths.get(file, new String[0]));
    }
}

