/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.pathmatcher;

import io.takari.builder.internal.pathmatcher.Plexus_SelectorUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;

class Plexus_MatchPattern {
    private final String source;
    private final String regexPattern;
    private final String[] tokenized;
    private final char[][] tokenizedChar;

    private Plexus_MatchPattern(String source, String separator) {
        this.regexPattern = Plexus_SelectorUtils.isRegexPrefixedPattern(source) ? source.substring("%regex[".length(), source.length() - "]".length()) : null;
        this.source = Plexus_SelectorUtils.isAntPrefixedPattern(source) ? source.substring("%ant[".length(), source.length() - "]".length()) : source;
        this.tokenized = Plexus_MatchPattern.tokenizePathToString(this.source, separator);
        this.tokenizedChar = new char[this.tokenized.length][];
        int i = 0;
        while (i < this.tokenized.length) {
            this.tokenizedChar[i] = this.tokenized[i].toCharArray();
            ++i;
        }
    }

    boolean matchPath(String str, char[][] strDirs, boolean isCaseSensitive) {
        if (this.regexPattern != null) {
            return str.matches(this.regexPattern);
        }
        return Plexus_SelectorUtils.matchAntPathPattern(this.getTokenizedPathChars(), strDirs, isCaseSensitive);
    }

    public char[][] getTokenizedPathChars() {
        return this.tokenizedChar;
    }

    static String[] tokenizePathToString(String path, String separator) {
        ArrayList<String> ret = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(path, separator);
        while (st.hasMoreTokens()) {
            ret.add(st.nextToken());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static Plexus_MatchPattern fromString(String source) {
        return new Plexus_MatchPattern(source, File.separator);
    }
}

