/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.enforcer.modularity.internal;

import io.takari.builder.enforcer.ComposableSecurityManagerPolicy;
import io.takari.builder.enforcer.Policy;
import io.takari.builder.enforcer.internal.EnforcerConfig;
import io.takari.builder.enforcer.internal.EnforcerViolation;
import io.takari.builder.enforcer.internal.EnforcerViolationType;
import io.takari.builder.enforcer.modularity.ModularityEnforcementPolicy;
import io.takari.builder.enforcer.modularity.ProjectContext;
import io.takari.builder.enforcer.modularity.internal.BasedirViolationException;
import io.takari.builder.enforcer.modularity.internal.ProjectsProvider;
import io.takari.builder.enforcer.modularity.internal.SessionConfig;
import io.takari.builder.enforcer.modularity.maven.ProjectBasedirEnforcer;
import io.takari.builder.internal.pathmatcher.PathMatcher;
import io.takari.builder.internal.pathmatcher.PathNormalizer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.model.Build;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultProjectBasedirEnforcer
implements ProjectBasedirEnforcer {
    private final Logger log = LoggerFactory.getLogger((String)"SPRINKLING");
    private static final Object KEY_CONTEXT = DefaultProjectBasedirEnforcer.class;
    private PathNormalizer normalizer;
    private PathMatcher readMatcher;
    private PathMatcher writeMatcher;
    private final Collection<ProjectsProvider> projectsProviders;
    private final DefaultPlexusContainer plexus;
    private static final String START = "${";
    private static final String STOP = "}";
    private static final String UPSTREAM = "dependency.";
    private static final String PROJECT = "project.";
    private static final String ALL_UPSTREAM = "?ALL";
    private static final String ARTIFACT_ID = "artifactId";
    private static final Pattern pattern = Pattern.compile("^\\$\\{dependency\\.(\\??[a-zA-Z0-9\\-]*)\\}");

    private void registerContextPolicy(ProjectContext context) {
        ComposableSecurityManagerPolicy.registerContextPolicy((Object)KEY_CONTEXT, (Policy)new ModularityEnforcementPolicy(context, (c, v) -> this.handleViolation((ProjectContext)c, (EnforcerViolation)v)));
    }

    private ModularityEnforcementPolicy unregisterContextPolicy() {
        ModularityEnforcementPolicy policy = (ModularityEnforcementPolicy)ComposableSecurityManagerPolicy.unregisterContextPolicy((Object)KEY_CONTEXT);
        policy.close();
        return policy;
    }

    ModularityEnforcementPolicy getContextPolicy() {
        return (ModularityEnforcementPolicy)ComposableSecurityManagerPolicy.getContextPolicy((Object)KEY_CONTEXT);
    }

    @Inject
    public DefaultProjectBasedirEnforcer(Collection<ProjectsProvider> projectsProviders, DefaultPlexusContainer plexus) {
        this.projectsProviders = projectsProviders;
        this.plexus = plexus;
    }

    @Override
    public boolean isEnabledForProject(EnforcerConfig config, String artifactId) {
        return config != null && config.enforce() && !config.exclude(artifactId);
    }

    protected boolean isAncestorOf(MavenProject project, MavenProject possibleAncestor) {
        MavenProject current = project;
        while (current != null) {
            if (!possibleAncestor.equals((Object)(current = current.getParent()))) continue;
            return true;
        }
        return false;
    }

    public void setupProjectContext(MavenSession session, MavenProject project, SessionConfig sessionConfig, EnforcerConfig enforcerConfig) {
        if (!this.isEnabledForProject(enforcerConfig, project.getArtifactId())) {
            return;
        }
        boolean enforceProject = this.isModularityEnforcementEnabled(project);
        if (enforceProject) {
            PathMatcher.Builder readMatcherBuilder = PathMatcher.builder((PathNormalizer)this.normalizer).addMatcher(this.readMatcher);
            PathMatcher.Builder writeMatcherBuilder = PathMatcher.builder((PathNormalizer)this.normalizer).addMatcher(this.writeMatcher);
            readMatcherBuilder.includePrefix(project.getBasedir().getAbsolutePath());
            Set<MavenProject> upstreamProjects = this.getUpstreamProjects(session, project);
            for (MavenProject other : upstreamProjects) {
                if ("pom".equals(other.getPackaging())) {
                    readMatcherBuilder.includePath(other.getFile().getAbsolutePath());
                    continue;
                }
                Build otherBuild = other.getBuild();
                if (!this.isAncestorOf(project, other)) {
                    for (String root : other.getTestCompileSourceRoots()) {
                        readMatcherBuilder.includePrefix(root);
                    }
                    for (String root : other.getCompileSourceRoots()) {
                        readMatcherBuilder.includePrefix(root);
                    }
                    readMatcherBuilder.includePath(otherBuild.getScriptSourceDirectory());
                    for (Resource otherResource : otherBuild.getResources()) {
                        readMatcherBuilder.includePath(otherResource.getDirectory());
                    }
                    for (Resource otherResource : otherBuild.getTestResources()) {
                        readMatcherBuilder.includePath(otherResource.getDirectory());
                    }
                    readMatcherBuilder.includePath(otherBuild.getOutputDirectory());
                    readMatcherBuilder.includePath(otherBuild.getTestOutputDirectory());
                    readMatcherBuilder.includePrefix(otherBuild.getDirectory());
                    readMatcherBuilder.includePrefix(other.getBuild().getOutputDirectory());
                    readMatcherBuilder.includePrefix(other.getBuild().getTestOutputDirectory());
                }
                for (Artifact artifact : other.getAttachedArtifacts()) {
                    readMatcherBuilder.includePrefix(artifact.getFile().getAbsolutePath());
                }
            }
            for (ArtifactRepository repo : project.getRemoteArtifactRepositories()) {
                DefaultProjectBasedirEnforcer.addRepositoryBasedir(readMatcherBuilder, repo);
            }
            for (ArtifactRepository repo : project.getPluginArtifactRepositories()) {
                DefaultProjectBasedirEnforcer.addRepositoryBasedir(readMatcherBuilder, repo);
            }
            writeMatcherBuilder.includePrefix(project.getBuild().getDirectory());
            writeMatcherBuilder.includePrefix(session.getLocalRepository().getBasedir());
            if (sessionConfig.isWriteByDefault()) {
                writeMatcherBuilder.includePrefix(project.getBasedir().getAbsolutePath());
            }
            this.addExceptions(readMatcherBuilder, session, project, enforcerConfig.getReadExceptions(project.getArtifactId()), sessionConfig.isAllowBreakingRules(), upstreamProjects);
            this.addExceptions(writeMatcherBuilder, session, project, enforcerConfig.getWriteExceptions(project.getArtifactId()), sessionConfig.isAllowBreakingRules(), upstreamProjects);
            PathMatcher readMatcher = readMatcherBuilder.build();
            PathMatcher writeMatcher = writeMatcherBuilder.build();
            HashSet<String> execIncludes = new HashSet<String>();
            this.addExecExceptions(execIncludes, enforcerConfig.getExecExceptions(project.getArtifactId()));
            ProjectContext context = new ProjectContext(this.normalizer, project.getArtifactId(), readMatcher, writeMatcher, execIncludes);
            this.registerContextPolicy(context);
        }
    }

    protected Boolean isModularityEnforcementEnabled(MavenProject project) {
        ClassRealm realm = project.getClassRealm();
        if (realm == null) {
            realm = this.plexus.getContainerRealm();
        }
        try {
            Class<Policy> clazz = Policy.class;
            if (realm.loadClass(clazz.getCanonicalName()) == clazz) {
                return true;
            }
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    protected Set<MavenProject> getUpstreamProjects(MavenSession session, MavenProject project) {
        ProjectDependencyGraph graph = session.getProjectDependencyGraph();
        HashSet<MavenProject> projects = new HashSet<MavenProject>(graph.getUpstreamProjects(project, true));
        for (ProjectsProvider provider : this.projectsProviders) {
            projects.addAll(provider.getUpstreamProjects(session, project, true));
        }
        return projects;
    }

    protected Set<MavenProject> getAllProjects(MavenSession session, MavenProject project) {
        HashSet<MavenProject> projects = new HashSet<MavenProject>();
        projects.addAll(session.getAllProjects());
        for (ProjectsProvider provider : this.projectsProviders) {
            projects.addAll(provider.getAllProjects(session));
        }
        return projects;
    }

    public void finishProjectContext(String basedir, MavenProject mavenProject, SessionConfig config) {
        if (this.getContextPolicy() == null) {
            return;
        }
        ProjectContext project = this.unregisterContextPolicy().getProjectContext();
        if (project.getViolations().isEmpty()) {
            return;
        }
        HashSet<String> violatedRules = new HashSet<String>();
        for (EnforcerViolation violation : project.getViolations()) {
            String type = violation.getType();
            if (violation.getViolationType() == EnforcerViolationType.EXECUTE) {
                violatedRules.add(String.valueOf(type) + " " + violation.getFile());
                continue;
            }
            violatedRules.add(String.valueOf(type) + " " + project.matchingRule(type.charAt(0), violation.getFile()));
        }
        StringBuilder msg = new StringBuilder();
        msg.append("\nUnexpected filesystem access for project: ").append(project.getId());
        msg.append("\nViolated Rules Are:");
        for (String violation : violatedRules) {
            msg.append("\n   " + violation);
        }
        msg.append("\nFor current exceptions please see: " + basedir + "/.mvn/basedir_enforcer.config");
        msg.append("\n    Rule1: Projects in a reactor build should only read from the published resources of their dependencies.");
        msg.append("\n           Maven lifecycle may require reading a dependencies classes, rather than a jar, or sources rather than classes.");
        msg.append("\n    Rule2: Projects should only write to ./target directory");
        msg.append("\n");
        String butc_chatter = "https://gus.my.salesforce.com/_ui/core/chatter/groups/GroupProfilePage?g=0F9B000000000lg";
        msg.append(String.format("\nSee %s for more information", butc_chatter));
        if (!config.isLogOnly()) {
            throw new BasedirViolationException(msg.toString());
        }
        this.log.error(msg.toString());
    }

    private String interpolate(String input, MavenProject project, MavenProject upstream) {
        return input.replace("${dependency.artifactId}", upstream == null ? "NO_UPSTREAM" : upstream.getArtifactId()).replace("${project.artifactId}", project.getArtifactId());
    }

    private void processExceptions(String relpath, MavenProject project, Set<MavenProject> upstream, PathMatcher.Builder builder, Set<MavenProject> allProjects, File multiModuleProjectDirectory, boolean allowBreakingRules) {
        Matcher matcher = pattern.matcher(relpath);
        if (matcher.find()) {
            Set<Object> toProcess;
            String matchDependency = matcher.group(1);
            String rest = relpath.substring(matcher.end(0));
            boolean allowToIgnore = false;
            if (ALL_UPSTREAM.equals(matchDependency)) {
                toProcess = upstream;
                allowToIgnore = true;
            } else {
                toProcess = upstream.stream().filter(p -> matchDependency.equals(p.getArtifactId())).collect(Collectors.toSet());
            }
            if (toProcess.isEmpty()) {
                this.log.warn("No upstream project match " + matcher.group(0) + " for project " + project.getArtifactId());
            }
            for (MavenProject other : toProcess) {
                this.addException(builder, other.getBasedir(), this.interpolate(rest, project, other), allowBreakingRules, allowToIgnore);
            }
        } else {
            File basedir = relpath.startsWith("/") ? multiModuleProjectDirectory : project.getBasedir();
            this.addException(builder, basedir, this.interpolate(relpath, project, null), allowBreakingRules, false);
        }
    }

    protected void addExceptions(PathMatcher.Builder builder, MavenSession session, MavenProject project, Collection<String> exceptions, boolean allowBreakingRules, Set<MavenProject> upstreamProjects) {
        File multiModuleProjectDirectory = session.getRequest().getMultiModuleProjectDirectory();
        for (String relpath : exceptions) {
            this.processExceptions(relpath, project, upstreamProjects, builder, this.getAllProjects(session), multiModuleProjectDirectory, allowBreakingRules);
        }
    }

    protected void addExecExceptions(Set<String> updated, Collection<String> exceptions) {
        for (String relpath : exceptions) {
            updated.add(relpath);
        }
    }

    protected void addException(PathMatcher.Builder builder, File basedir, String relpath, boolean allowBreakingRules, boolean allowToIgnore) {
        String from;
        String base = this.normalizer.normalize(basedir.toPath());
        String path = this.normalizer.normalize(basedir.toPath().resolve(relpath.startsWith("/") ? relpath.substring(1) : relpath));
        String baseOwner = this.readMatcher.getMatchingRule(base);
        String actualOwner = this.readMatcher.getMatchingRule(path);
        boolean invalidRule = !baseOwner.equals(actualOwner);
        String string = from = baseOwner != null ? "another maven project " + actualOwner + " in subfolder " + baseOwner : "a non maven project path " + path;
        if (allowToIgnore && invalidRule) {
            if (baseOwner != null) {
                this.log.info("In ./.mvn/basedir-enforcer.txt you have a rule " + relpath + " on target project at " + basedir + " that tries to access a file from " + from + " the rule will be ignored");
            }
            return;
        }
        if (invalidRule && allowBreakingRules) {
            this.log.warn("In ./.mvn/basedir-enforcer.txt you have a rule " + relpath + " on target project at " + basedir + " that tries to access a file from " + from + " the rule will be ALLOWED, but your build is invalid... especially a partial build");
        }
        if (invalidRule && !allowBreakingRules) {
            this.log.warn("In ./.mvn/basedir-enforcer.txt you have a rule " + relpath + " on target project at " + basedir + " that tries to access a file from " + from + " the rule will be IGNORED");
        }
        if (!invalidRule || allowBreakingRules) {
            if (relpath.endsWith("/")) {
                builder.includePrefix(path);
            } else {
                builder.includePath(path);
            }
        }
    }

    public void setupMavenSession(MavenSession session, SessionConfig sessionConfig) {
        this.normalizer = PathNormalizer.createNormalizer((Path)session.getRequest().getMultiModuleProjectDirectory().toPath());
        PathMatcher.Builder readMatcherBuilder = PathMatcher.builder((PathNormalizer)this.normalizer).excludeRoot();
        PathMatcher.Builder writeMatcherBuilder = PathMatcher.builder((PathNormalizer)this.normalizer).excludeRoot();
        for (MavenProject project : this.getAllProjects(session)) {
            readMatcherBuilder.includePath(project.getFile().getAbsolutePath());
            readMatcherBuilder.excludePrefix(project.getBasedir().getAbsolutePath());
            writeMatcherBuilder.excludePrefix(project.getBasedir().getAbsolutePath());
        }
        readMatcherBuilder.includePath(session.getLocalRepository().getBasedir());
        readMatcherBuilder.includePrefix(session.getLocalRepository().getBasedir());
        if (sessionConfig.isReadByDefault()) {
            readMatcherBuilder.includeRoot();
        }
        if (sessionConfig.isWriteByDefault()) {
            writeMatcherBuilder.includeRoot();
        }
        Arrays.asList("java.endorsed.dirs", "java.ext.dirs", "java.home", "java.io.tmpdir", "java.class.path", "java.library.path", "sun.boot.library.path", "maven.home", "maven.ext.class.path").stream().map(prop -> System.getProperty(prop)).filter(propVal -> propVal != null && !"".equals(propVal)).flatMap(propVal -> Arrays.asList(propVal.split(File.pathSeparator)).stream()).filter(path -> path != null && !".".equals(path) && !"".equals(path)).map(path -> path.endsWith(String.valueOf(File.separator) + "jre") ? path.substring(0, path.length() - 3) : path).forEach(path -> {
            PathMatcher.Builder builder2 = readMatcherBuilder.includePrefix(path);
        });
        this.plexus.getClassWorld().getRealms().stream().flatMap(r -> Arrays.asList(r.getURLs()).stream()).forEach(url -> {
            try {
                DefaultProjectBasedirEnforcer.includeDirectory(readMatcherBuilder, url.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {}
        });
        readMatcherBuilder.includePath(session.getRequest().getMultiModuleProjectDirectory().getAbsolutePath());
        readMatcherBuilder.includePrefix(new File(session.getRequest().getMultiModuleProjectDirectory(), ".mvn").getAbsolutePath());
        readMatcherBuilder.includePrefix(System.getProperty("java.io.tmpdir"));
        writeMatcherBuilder.includePrefix(System.getProperty("java.io.tmpdir"));
        readMatcherBuilder.includePath("/dev/random").includePath("/dev/urandom");
        this.readMatcher = readMatcherBuilder.build();
        this.writeMatcher = writeMatcherBuilder.build();
    }

    protected Set<MavenProject> getAllProjects(MavenSession session) {
        HashSet<MavenProject> projects = new HashSet<MavenProject>(session.getAllProjects());
        for (ProjectsProvider provider : this.projectsProviders) {
            projects.addAll(provider.getAllProjects(session));
        }
        return projects;
    }

    @Override
    public void replayLog(File logfile) throws IOException {
        ModularityEnforcementPolicy policy = this.getContextPolicy();
        if (policy != null) {
            ProjectContext project = policy.getProjectContext();
            for (EnforcerViolation violation : EnforcerViolation.readFrom(logfile.toPath())) {
                this.handleViolation(project, violation);
            }
        }
    }

    protected void handleViolation(ProjectContext context, EnforcerViolation violation) {
        if (context != null && context.addViolation(violation)) {
            String type = violation.getType();
            String file = violation.getFile();
            String rule = context.matchingRule(type.charAt(0), file);
            String message = String.valueOf(type) + " " + file + " " + rule;
            StringBuilder details = new StringBuilder(message);
            violation.getStackTrace().forEach(s -> {
                StringBuilder stringBuilder2 = details.append("\n   | ").append((String)s);
            });
            this.log.error(details.toString());
        }
    }

    @Override
    public void writeConfiguration(File file) throws IOException {
        ModularityEnforcementPolicy policy = this.getContextPolicy();
        if (policy != null) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (FileOutputStream out = new FileOutputStream(file);){
                policy.getProjectContext().store(out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private static void addRepositoryBasedir(PathMatcher.Builder builder, ArtifactRepository repo) {
        try {
            DefaultProjectBasedirEnforcer.includeDirectory(builder, new URI(repo.getUrl()));
        }
        catch (URISyntaxException uRISyntaxException) {}
    }

    private static void includeDirectory(PathMatcher.Builder builder, URI url) {
        if ("ext".equals(url.getScheme()) || "file".equals(url.getScheme())) {
            builder.includePrefix(url.getPath());
        }
    }

    @Override
    public void enterExecPrivileged() {
        ModularityEnforcementPolicy policy = this.getContextPolicy();
        if (policy != null) {
            policy.enterExecPrivileged();
        }
    }

    @Override
    public void leaveExecPrivileged() {
        ModularityEnforcementPolicy policy = this.getContextPolicy();
        if (policy != null) {
            policy.leaveExecPrivileged();
        }
    }
}

