/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.enforcer.modularity.internal;

import io.takari.builder.enforcer.modularity.AlternateGraphProvider;
import io.takari.builder.enforcer.modularity.internal.ProjectsProvider;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.project.MavenProject;

@Named
public class WorkspaceProjectsProvider
implements ProjectsProvider {
    private final Optional<AlternateGraphProvider> graphFilter;

    @Inject
    WorkspaceProjectsProvider(@Nullable AlternateGraphProvider graphFilter) {
        this.graphFilter = Optional.ofNullable(graphFilter);
    }

    @Override
    public MavenProject getTopLevelProject(MavenSession session) {
        return session.getTopLevelProject();
    }

    @Override
    public Collection<MavenProject> getAllProjects(MavenSession session) {
        ProjectDependencyGraph graph = this.getGenerationsGraph(session);
        return graph.getSortedProjects();
    }

    @Override
    public Collection<MavenProject> getUpstreamProjects(MavenSession session, MavenProject project, boolean transitive) {
        ProjectDependencyGraph graph = this.getGenerationsGraph(session);
        return graph.getUpstreamProjects(project, transitive);
    }

    private ProjectDependencyGraph getGenerationsGraph(MavenSession session) {
        ProjectDependencyGraph graph = session.getProjectDependencyGraph();
        if (this.graphFilter.isPresent()) {
            return this.graphFilter.get().get(graph);
        }
        return graph;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Nullable {
    }
}

