/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.enforcer.modularity.maven.internal;

import io.takari.builder.enforcer.modularity.internal.DefaultProjectBasedirEnforcer;
import io.takari.builder.enforcer.modularity.maven.internal.ModularityEnforcerSessionState;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.SessionScoped;
import org.apache.maven.execution.MojoExecutionEvent;
import org.apache.maven.execution.MojoExecutionListener;

@Named
@SessionScoped
public class ModularityEnforcerMojoExecutionListener
implements MojoExecutionListener {
    private final DefaultProjectBasedirEnforcer enforcer;
    private final ModularityEnforcerSessionState state;

    @Inject
    public ModularityEnforcerMojoExecutionListener(DefaultProjectBasedirEnforcer enforcer, ModularityEnforcerSessionState state) {
        this.enforcer = enforcer;
        this.state = state;
    }

    public void beforeMojoExecution(MojoExecutionEvent event) {
        if (this.enforce(event)) {
            this.enforcer.setupProjectContext(event.getSession(), event.getProject(), this.state.getSessionConfig(), this.state.getEnforcerConfig());
        }
    }

    public void afterMojoExecutionSuccess(MojoExecutionEvent event) {
        if (this.enforce(event)) {
            this.enforcer.finishProjectContext(this.state.getTopleveldir(), event.getProject(), this.state.getSessionConfig());
        }
    }

    public void afterExecutionFailure(MojoExecutionEvent event) {
        if (this.enforce(event)) {
            this.enforcer.finishProjectContext(this.state.getTopleveldir(), event.getProject(), this.state.getSessionConfig());
        }
    }

    private boolean enforce(MojoExecutionEvent event) {
        return this.state.isEnforcerEnabled() && event.getExecution().getLifecyclePhase() != null && event.getSession().getRequest().getUserProperties().get("m2e.version") == null;
    }
}

