/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.enforcer;

import io.takari.builder.enforcer.CachingPolicy;
import io.takari.builder.enforcer.ComposableSecurityManagerPolicy;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.MDC;

public class PolicyContextPreserver {
    private static final List<CurrentContextAccessor> accessors = new CopyOnWriteArrayList<CurrentContextAccessor>(new CurrentContextAccessor[]{new PolicyPreserver(), new SLF4JPreserver()});
    private final IdentityHashMap<CurrentContextAccessor, Object> preservedContext = PolicyContextPreserver.preserve();

    public static void registerAccessor(CurrentContextAccessor accessor) {
        accessors.add(accessor);
    }

    private static IdentityHashMap<CurrentContextAccessor, Object> preserve() {
        IdentityHashMap<CurrentContextAccessor, Object> context = new IdentityHashMap<CurrentContextAccessor, Object>();
        accessors.forEach(d -> {
            Object object = context.put((CurrentContextAccessor)d, d.getCurrentContext());
        });
        return context;
    }

    private static void restore(IdentityHashMap<CurrentContextAccessor, Object> context) {
        context.forEach((p, v) -> p.setCurrentContext(v));
    }

    public Runnable wrap(final Runnable runnable) {
        return new Runnable(){

            @Override
            public void run() {
                IdentityHashMap threadContext = PolicyContextPreserver.preserve();
                try {
                    PolicyContextPreserver.restore(PolicyContextPreserver.this.preservedContext);
                    runnable.run();
                }
                finally {
                    PolicyContextPreserver.restore(threadContext);
                }
            }
        };
    }

    public <T> WrappedCallable<T> wrap(final Callable<T> callable) {
        return new WrappedCallable<T>(){

            @Override
            public T call() throws WrappedException {
                IdentityHashMap threadContext = PolicyContextPreserver.preserve();
                try {
                    PolicyContextPreserver.restore(PolicyContextPreserver.this.preservedContext);
                    Object v = callable.call();
                    return v;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    String message = "Callable " + callable.getClass().getName() + " failed with execption " + e.getClass().getName();
                    throw new WrappedException(message, e);
                }
                finally {
                    PolicyContextPreserver.restore(threadContext);
                }
            }
        };
    }

    public static interface CurrentContextAccessor {
        public Object getCurrentContext();

        public void setCurrentContext(Object var1);
    }

    private static class PolicyPreserver
    implements CurrentContextAccessor {
        private PolicyPreserver() {
        }

        @Override
        public Map<Object, CachingPolicy> getCurrentContext() {
            return ComposableSecurityManagerPolicy.getContextPolicies();
        }

        @Override
        public void setCurrentContext(Object value) {
            Map policies = (Map)value;
            ComposableSecurityManagerPolicy.setContextPolicies(policies);
        }
    }

    private static class SLF4JPreserver
    implements CurrentContextAccessor {
        private SLF4JPreserver() {
        }

        @Override
        public Map getCurrentContext() {
            return MDC.getCopyOfContextMap();
        }

        @Override
        public void setCurrentContext(Object value) {
            Map mdc = (Map)value;
            if (mdc != null) {
                MDC.setContextMap((Map)mdc);
            } else {
                MDC.clear();
            }
        }
    }

    public static interface WrappedCallable<T>
    extends Callable<T> {
        @Override
        public T call() throws WrappedException;
    }

    public static class WrappedException
    extends RuntimeException {
        public WrappedException(String message, Exception cause) {
            super(message, cause);
        }
    }
}

