/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.internal.BuilderInputs;
import io.takari.builder.internal.CompileSourceRoot;
import io.takari.builder.internal.IncrementalBuildException;
import io.takari.builder.internal.Message;
import io.takari.builder.internal.ResourceRoot;
import io.takari.builder.internal.digest.FileDigest;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.util.xml.CompactXMLWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

class BuilderExecutionState {
    public final BuilderInputs.Digest inputsDigest;
    public final Map<String, Object> properties;
    public final Serializable classpathDigest;
    public final Collection<String> outputPaths;
    public final Set<CompileSourceRoot> compileSourceRoots;
    public final Set<ResourceRoot> resourceRoots;
    public final List<Message> messages;
    public final Map<String, FileDigest> exceptionsDigest;
    private static final String OUTPUT_DOM_NAME = "o";
    static final InprogressStateWriter NOOP_INPROGRESSWRITER = new InprogressStateWriter(){

        @Override
        public void close() {
        }

        @Override
        public void writePath(String path) {
        }
    };

    private BuilderExecutionState(BuilderInputs.Digest inputsDigest, Map<String, Object> properties, Serializable classpathDigest, Collection<String> outputPaths, Set<CompileSourceRoot> compileSourceRoots, Set<ResourceRoot> resourceRoots, List<Message> messages, Map<String, FileDigest> exceptionsDigest) {
        this.inputsDigest = inputsDigest;
        this.properties = properties;
        this.classpathDigest = classpathDigest;
        this.outputPaths = outputPaths;
        this.compileSourceRoots = compileSourceRoots;
        this.resourceRoots = resourceRoots;
        this.messages = messages;
        this.exceptionsDigest = exceptionsDigest;
    }

    public static BuilderExecutionState load(Path file) {
        Collection<String> outputPaths = Collections.emptySet();
        if (file != null && Files.isRegularFile(file, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (ObjectInputStream is = BuilderExecutionState.newObjectInputStream(file);){
                    outputPaths = BuilderExecutionState.readOutputPaths(is);
                    BuilderInputs.Digest inputsDigest = (BuilderInputs.Digest)is.readObject();
                    Map properties = (Map)is.readObject();
                    Serializable classpathDigest = (Serializable)is.readObject();
                    Set compileSourceRoots = (Set)is.readObject();
                    Set resourceRoots = (Set)is.readObject();
                    List messages = (List)is.readObject();
                    Map exceptionsDigest = (Map)is.readObject();
                    return new BuilderExecutionState(inputsDigest, properties, classpathDigest, outputPaths, compileSourceRoots, resourceRoots, messages, exceptionsDigest);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | ClassNotFoundException exception) {}
        }
        return new BuilderExecutionState(BuilderInputs.emptyDigest(), Collections.emptyMap(), (Serializable)((Object)""), outputPaths, Collections.emptySet(), Collections.emptySet(), Collections.emptyList(), Collections.emptyMap());
    }

    private static ObjectInputStream newObjectInputStream(Path file) throws IOException {
        return new ObjectInputStream(new BufferedInputStream(Files.newInputStream(file, new OpenOption[0])));
    }

    private static ObjectOutputStream newObjectOutputStream(Path file) throws IOException {
        return new ObjectOutputStream(new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0])));
    }

    public static void store(Path file, BuilderInputs.Digest digest, Map<String, Object> properties, Serializable classpathDigest, Collection<String> outputPaths, Set<CompileSourceRoot> compileSourceRoots, Set<ResourceRoot> resourceRoots, List<Message> messages, Map<String, FileDigest> exceptionsDigest) throws IOException {
        if (file == null) {
            return;
        }
        if (!Files.isDirectory(file.getParent(), new LinkOption[0])) {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
        }
        Throwable throwable = null;
        Object var10_11 = null;
        try (ObjectOutputStream os = BuilderExecutionState.newObjectOutputStream(file);){
            BuilderExecutionState.writeOutputPaths(os, outputPaths);
            os.writeObject(digest);
            os.writeObject(properties);
            os.writeObject(classpathDigest);
            os.writeObject(compileSourceRoots);
            os.writeObject(resourceRoots);
            os.writeObject(messages);
            os.writeObject(exceptionsDigest);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static void writeOutputPaths(ObjectOutputStream os, Collection<String> outputPaths) throws IOException {
        os.writeInt(outputPaths.size());
        for (String path : outputPaths) {
            os.writeUTF(BuilderExecutionState.toPortablePath(path));
        }
    }

    private static String toPortablePath(String path) {
        StringWriter buf = new StringWriter();
        CompactXMLWriter w = new CompactXMLWriter((Writer)buf);
        w.startElement(OUTPUT_DOM_NAME);
        w.writeText(path);
        w.endElement();
        return buf.toString();
    }

    static Collection<String> readOutputPaths(ObjectInputStream is) throws IOException {
        int size = is.readInt();
        HashSet<String> outputPaths = new HashSet<String>(size);
        int i = 0;
        while (i < size) {
            try {
                outputPaths.add(BuilderExecutionState.fromPortablePath(is.readUTF()));
            }
            catch (XmlPullParserException e) {
                throw new StateFormatException(e);
            }
            ++i;
        }
        return outputPaths;
    }

    private static String fromPortablePath(String string) throws XmlPullParserException, IOException {
        Xpp3Dom dom = Xpp3DomBuilder.build((Reader)new StringReader(string));
        if (!OUTPUT_DOM_NAME.equals(dom.getName())) {
            throw new XmlPullParserException("invalid element " + dom.getName());
        }
        return dom.getValue();
    }

    static Collection<String> readInprogressOutputPaths(Path file) throws IOException {
        HashSet<String> paths = new HashSet<String>();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader reader = Files.newBufferedReader(file);){
                String str;
                while ((str = reader.readLine()) != null) {
                    paths.add(BuilderExecutionState.fromPortablePath(str));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (XmlPullParserException xmlPullParserException) {}
        return paths;
    }

    static InprogressStateWriter newInprogressWriter(Path file) throws IOException {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        final BufferedWriter writer = Files.newBufferedWriter(file, StandardOpenOption.CREATE_NEW, StandardOpenOption.SYNC);
        return new InprogressStateWriter(){

            @Override
            public void close() throws IOException {
                writer.close();
            }

            @Override
            public void writePath(String path) throws IncrementalBuildException {
                try {
                    writer.write(BuilderExecutionState.toPortablePath(path));
                    writer.newLine();
                    writer.flush();
                }
                catch (IOException e) {
                    throw new IncrementalBuildException(e);
                }
            }
        };
    }

    static interface InprogressStateWriter
    extends Closeable {
        public void writePath(String var1) throws IncrementalBuildException;
    }

    private static class StateFormatException
    extends RuntimeException {
        public StateFormatException(Throwable cause) {
            super(cause);
        }
    }
}

