/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.IArtifactMetadata;
import io.takari.builder.IDirectoryFiles;
import io.takari.builder.ResourceType;
import io.takari.builder.internal.ArtifactResourcesImpl;
import io.takari.builder.internal.CompileSourceRoot;
import io.takari.builder.internal.Reflection;
import io.takari.builder.internal.ResourceRoot;
import io.takari.builder.internal.digest.BytesHash;
import io.takari.builder.internal.digest.FileDigest;
import io.takari.builder.internal.digest.SHA1Digester;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BuilderInputs {
    final Class<?> type;
    final Map<Field, Value<?>> members;
    final Set<Path> inputFiles;
    final Set<Path> outputDirectories;
    final Set<Path> outputFiles;
    final Set<ResourceRoot> resourceRoots;
    final Set<CompileSourceRoot> compileSourceRoots;
    final boolean isNonDeterministic;
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public Set<Path> getInputFiles() {
        return this.inputFiles;
    }

    public Set<Path> getOutputDirectories() {
        return this.outputDirectories;
    }

    public Set<Path> getOutputFiles() {
        return this.outputFiles;
    }

    public Set<ResourceRoot> getResourceRoots() {
        return this.resourceRoots;
    }

    public Set<CompileSourceRoot> getCompileSourceRoots() {
        return this.compileSourceRoots;
    }

    public boolean isNonDeterministic() {
        return this.isNonDeterministic;
    }

    public Digest getDigest() {
        LinkedHashMap members = new LinkedHashMap();
        this.members.forEach((field, value) -> {
            Value value2 = members.put(field.getName(), (Value<?>)value);
        });
        return BuilderInputs.digest(members);
    }

    public static Digest emptyDigest() {
        return new Digest();
    }

    public Object newBuilder() throws ReflectiveOperationException {
        Constructor<?> constructor = this.type.getDeclaredConstructor(new Class[0]);
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        Object builder = constructor.newInstance(new Object[0]);
        for (Map.Entry<Field, Value<?>> member : this.members.entrySet()) {
            Field field = member.getKey();
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(builder, member.getValue().value());
        }
        return builder;
    }

    static Digest digest(Value<?> input) {
        return BuilderInputs.digest(Collections.singletonMap("parameter", input));
    }

    private static Digest digest(Map<String, Value<?>> members) {
        TreeMap<String, BytesHash> memberDigests = new TreeMap<String, BytesHash>();
        final TreeMap fileDigests = new TreeMap();
        for (Map.Entry<String, Value<?>> member : members.entrySet()) {
            final MessageDigest digester = SHA1Digester.newInstance();
            member.getValue().accept(new InputVisitor(){

                private void digestInput(Path value) {
                    if (Files.isRegularFile(value, new LinkOption[0])) {
                        fileDigests.put(value.toFile(), FileDigest.digest((Path)value));
                    } else if (Files.isDirectory(value, new LinkOption[0])) {
                        try {
                            Files.walk(value, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0])).forEach(f -> {
                                FileDigest fileDigest = fileDigests.put(f.toFile(), FileDigest.digest((Path)f));
                            });
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    } else {
                        this.digest(value.toString());
                    }
                }

                private void digestInput(URL url) {
                    this.digest(url.getPath());
                    try {
                        Throwable throwable = null;
                        Object var3_5 = null;
                        try (InputStream is = url.openStream();){
                            int len;
                            byte[] buf = new byte[4096];
                            while ((len = is.read(buf)) >= 0) {
                                digester.update(buf, 0, len);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }

                private void digest(Path value) {
                    digester.update(value.toString().getBytes(UTF8));
                }

                private void digest(String value) {
                    if (value != null) {
                        digester.update(value.getBytes(UTF8));
                    }
                }

                private void digest(IArtifactMetadata value) {
                    this.digest(value.getGroupId());
                    this.digest(value.getArtifactId());
                    this.digest(value.getVersion());
                    this.digest(value.getType());
                    this.digest(value.getClassifier());
                }

                private void digest(byte value) {
                    digester.update(value);
                }

                @Override
                public void visitOutputDirectory(OutputDirectoryValue outputDirectory) {
                    this.digest(outputDirectory.configuration);
                }

                @Override
                public void visitOutputFile(OutputFileValue outputFile) {
                    this.digest(outputFile.configuration);
                }

                @Override
                public void visitInputFile(InputFileValue value) {
                    this.digestInput(value.configuration);
                }

                @Override
                public void visitInputDirectory(InputDirectoryValue value) {
                    this.digest(value.location.toString());
                    if (value.includes != null) {
                        value.includes.forEach(include -> this.digest((String)include));
                    }
                    if (value.excludes != null) {
                        value.excludes.forEach(exclude -> this.digest((String)exclude));
                    }
                    value.filePaths.forEach(file -> this.digestInput((Path)file));
                }

                @Override
                public void visitResourceRoot(GeneratedResourcesDirectoryValue value) {
                    this.digest(value.configuration);
                    if (value.includes != null) {
                        value.includes.forEach(include -> this.digest((String)include));
                    }
                    if (value.excludes != null) {
                        value.excludes.forEach(exclude -> this.digest((String)exclude));
                    }
                    this.digest((byte)value.type.ordinal());
                }

                @Override
                public void visitCompileSourceRoot(GeneratedSourcesDirectoryValue value) {
                    this.digest(value.configuration);
                    this.digest((byte)value.sourceType.ordinal());
                }

                @Override
                public void visitString(StringValue simple) {
                    this.digest(simple.configuration);
                }

                @Override
                public void visitMap(MapValue value) {
                    Map<String, String> map = value.configuration;
                    if (map != null) {
                        map.entrySet().forEach(entry -> this.digest(entry.toString()));
                    }
                }

                @Override
                public void visitDependencyMap(DependencyMapValue value) {
                    Map<IArtifactMetadata, Path> map = value.elements;
                    if (map != null) {
                        map.entrySet().forEach(entry -> {
                            this.digest((IArtifactMetadata)entry.getKey());
                            this.digestInput((Path)entry.getValue());
                        });
                    }
                }

                @Override
                public void visitCollectionFileURL(InputFilesValue value) {
                    value.files.forEach(file -> this.digestInput((Path)file));
                }

                @Override
                public void visitArtifactResources(ArtifactResourcesValue value) {
                    this.digest(value.artifact);
                    value.urls.forEach(url -> this.digestInput((URL)url));
                }

                @Override
                public void visitDependency(DependencyValue value) {
                    this.digest(value.artifact);
                    if (value.isFileType()) {
                        this.digestInput(value.location);
                    }
                }
            });
            memberDigests.put(member.getKey(), new BytesHash(digester.digest()));
        }
        return new Digest(memberDigests, fileDigests);
    }

    BuilderInputs(Class<?> type, Map<Field, Value<?>> values, boolean isNonDeterministic) {
        this.type = type;
        this.members = Collections.unmodifiableMap(values);
        this.isNonDeterministic = isNonDeterministic;
        final LinkedHashSet inputFiles = new LinkedHashSet();
        final LinkedHashSet outputDirectories = new LinkedHashSet();
        final LinkedHashSet outputFiles = new LinkedHashSet();
        final LinkedHashSet resources = new LinkedHashSet();
        final LinkedHashSet compileSourceRoots = new LinkedHashSet();
        InputVisitor visitor = new InputVisitor(){

            @Override
            public void visitInputFile(InputFileValue value) {
                inputFiles.add(value.configuration);
            }

            @Override
            public void visitInputDirectory(InputDirectoryValue value) {
                inputFiles.addAll(value.filePaths);
            }

            @Override
            public void visitOutputDirectory(OutputDirectoryValue value) {
                outputDirectories.add(value.configuration);
            }

            @Override
            public void visitOutputFile(OutputFileValue value) {
                outputFiles.add(value.configuration);
            }

            @Override
            public void visitResourceRoot(GeneratedResourcesDirectoryValue value) {
                outputDirectories.add(value.configuration);
                resources.add(new ResourceRoot(value.configuration.toAbsolutePath().toString(), value.type, value.includes, value.excludes));
            }

            @Override
            public void visitCompileSourceRoot(GeneratedSourcesDirectoryValue value) {
                outputDirectories.add(value.configuration);
                compileSourceRoots.add(new CompileSourceRoot(value.configuration.toAbsolutePath().toString(), value.sourceType));
            }

            @Override
            public void visitString(StringValue value) {
            }

            @Override
            public void visitMap(MapValue value) {
            }

            @Override
            public void visitCollectionFileURL(InputFilesValue value) {
                value.files.forEach(file -> {
                    boolean bl = inputFiles.add(file);
                });
            }

            @Override
            public void visitArtifactResources(ArtifactResourcesValue value) {
                inputFiles.addAll(value.files);
            }

            @Override
            public void visitDependency(DependencyValue value) {
                if (value.isFileType()) {
                    this.addDependencyInput(inputFiles, value.location);
                }
            }

            @Override
            public void visitDependencyMap(DependencyMapValue value) {
                Map<IArtifactMetadata, Path> map = value.elements;
                if (map != null) {
                    map.entrySet().forEach(entry -> this.addDependencyInput(inputFiles, (Path)entry.getValue()));
                }
            }

            private void addDependencyInput(Set<Path> inputFiles2, Path path) {
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    inputFiles2.add(path);
                } else if (Files.isDirectory(path, new LinkOption[0])) {
                    this.addFilesFromDirectory(inputFiles2, path);
                }
            }

            private void addFilesFromDirectory(Set<Path> inputFiles2, Path path2) {
                try {
                    Files.walk(path2, new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).forEach(p -> {
                        boolean bl = inputFiles2.add((Path)p);
                    });
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
        values.values().forEach(member -> member.accept(visitor));
        this.inputFiles = Collections.unmodifiableSet(inputFiles);
        this.outputDirectories = Collections.unmodifiableSet(outputDirectories);
        this.outputFiles = Collections.unmodifiableSet(outputFiles);
        this.resourceRoots = Collections.unmodifiableSet(resources);
        this.compileSourceRoots = Collections.unmodifiableSet(compileSourceRoots);
    }

    static class ArtifactResourcesValue
    implements Value<Object> {
        public final Set<Path> files;
        public final IArtifactMetadata artifact;
        public final Set<URL> urls;

        public ArtifactResourcesValue(Set<Path> files, IArtifactMetadata artifact, Collection<URL> urls) {
            this.files = Collections.unmodifiableSet(files);
            this.artifact = artifact;
            TreeSet<URL> sorted = new TreeSet<URL>((a, b) -> a.getPath().compareTo(b.getPath()));
            sorted.addAll(urls);
            this.urls = Collections.unmodifiableSet(sorted);
        }

        @Override
        public Object value() throws ReflectiveOperationException {
            return new ArtifactResourcesImpl(this.artifact, this.urls);
        }

        @Override
        public void accept(InputVisitor visitor) {
            visitor.visitArtifactResources(this);
        }
    }

    static class CollectionValue
    implements Value<Object> {
        final Reflection.MultivalueFactory factory;
        final List<Value<?>> configuration;

        public CollectionValue(Reflection.MultivalueFactory factory, List<Value<?>> elements) {
            this.factory = factory;
            this.configuration = Collections.unmodifiableList(elements);
        }

        @Override
        public Object value() throws ReflectiveOperationException {
            ArrayList elements = new ArrayList();
            for (Value<?> element : this.configuration) {
                elements.add(element.value());
            }
            return this.factory.newInstance(elements);
        }

        @Override
        public void accept(InputVisitor visitor) {
            this.configuration.forEach(v -> v.accept(visitor));
        }
    }

    static class CompositeValue
    implements Value<Object> {
        final Class<?> type;
        final Map<Field, Value<?>> configuration;

        public CompositeValue(Class<?> type, Map<Field, Value<?>> configuration) {
            this.type = type;
            this.configuration = Collections.unmodifiableMap(configuration);
        }

        @Override
        public Object value() throws ReflectiveOperationException {
            Object value = this.type.newInstance();
            for (Map.Entry<Field, Value<?>> memberValue : this.configuration.entrySet()) {
                Field member = memberValue.getKey();
                if (!member.isAccessible()) {
                    member.setAccessible(true);
                }
                member.set(value, memberValue.getValue().value());
            }
            return value;
        }

        @Override
        public void accept(InputVisitor visitor) {
            this.configuration.values().forEach(v -> v.accept(visitor));
        }
    }

    static class DependencyMapValue
    implements Value<Map<IArtifactMetadata, Object>> {
        final Class<?> type;
        final InstanceFactory<Map<IArtifactMetadata, Object>> supplier;
        public final Map<IArtifactMetadata, Path> elements;

        public DependencyMapValue(Class<?> type, InstanceFactory<Map<IArtifactMetadata, Object>> supplier, Map<IArtifactMetadata, Path> elements) {
            this.type = type;
            this.supplier = supplier;
            this.elements = Collections.unmodifiableMap(elements);
        }

        @Override
        public Map<IArtifactMetadata, Object> value() throws ReflectiveOperationException {
            Map<IArtifactMetadata, Object> map = this.supplier.newInstance();
            for (Map.Entry<IArtifactMetadata, Path> element : this.elements.entrySet()) {
                if (this.type.isAssignableFrom(File.class)) {
                    map.put(element.getKey(), element.getValue().toFile());
                    continue;
                }
                if (!this.type.isAssignableFrom(Path.class)) continue;
                map.put(element.getKey(), element.getValue());
            }
            return map;
        }

        @Override
        public void accept(InputVisitor visitor) {
            visitor.visitDependencyMap(this);
        }
    }

    static class DependencyValue
    implements Value<Object> {
        final Class<?> type;
        final IArtifactMetadata artifact;
        final Path location;

        protected DependencyValue(Class<?> type, IArtifactMetadata artifact, Path location) {
            this.type = type;
            this.artifact = artifact;
            this.location = location;
        }

        @Override
        public final Object value() {
            if (File.class.isAssignableFrom(this.type)) {
                return this.location.toFile();
            }
            if (Path.class.isAssignableFrom(this.type)) {
                return this.location;
            }
            if (IArtifactMetadata.class.isAssignableFrom(this.type)) {
                return this.artifact;
            }
            throw new IllegalStateException();
        }

        @Override
        public void accept(InputVisitor visitor) {
            visitor.visitDependency(this);
        }

        public boolean isFileType() {
            return File.class.isAssignableFrom(this.type) || Path.class.isAssignableFrom(this.type);
        }
    }

    static class Digest
    implements Serializable {
        private final Map<String, BytesHash> inputs;
        private final Map<File, FileDigest> files;

        private Digest(Map<String, BytesHash> inputs, Map<File, FileDigest> files) {
            if (inputs == null || files == null) {
                throw new IllegalArgumentException();
            }
            this.inputs = inputs;
            this.files = files;
        }

        private Digest() {
            this.inputs = null;
            this.files = null;
        }

        public Set<Path> files() {
            return this.files == null ? Collections.emptySet() : (Set)this.files.keySet().stream().map(f -> f.toPath()).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        public boolean equals(Object obj) {
            if (this.inputs == null || this.files == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Digest)) {
                return false;
            }
            Digest other = (Digest)obj;
            return this.inputs.equals(other.inputs) && this.files.equals(other.files);
        }
    }

    static abstract class FileValue
    implements Value<Object> {
        final Class<?> parameterType;
        final Path configuration;

        protected FileValue(Class<?> parameterType, Path location) {
            this.parameterType = parameterType;
            this.configuration = location;
        }

        @Override
        public final Object value() {
            if (this.parameterType.isAssignableFrom(Path.class)) {
                return this.configuration;
            }
            return this.configuration.toFile();
        }
    }

    static class GeneratedResourcesDirectoryValue
    extends FileValue {
        final ResourceType type;
        final List<String> includes;
        final List<String> excludes;

        public GeneratedResourcesDirectoryValue(Class<?> parameterType, Path location, ResourceType type, List<String> includes, List<String> excludes) {
            super(parameterType, location);
            this.type = type;
            this.includes = includes;
            this.excludes = excludes;
        }

        @Override
        public void accept(InputVisitor visitor) {
            visitor.visitResourceRoot(this);
        }
    }

    static class GeneratedSourcesDirectoryValue
    extends FileValue {
        final ResourceType sourceType;

        public GeneratedSourcesDirectoryValue(Class<?> parameterType, Path location, ResourceType sourceType) {
            super(parameterType, location);
            this.sourceType = sourceType;
        }

        @Override
        public void accept(InputVisitor visitor) {
            visitor.visitCompileSourceRoot(this);
        }
    }

    static class InputDirectoryValue
    implements Value<Object>,
    IDirectoryFiles {
        public final Class<?> type;
        public final Path location;
        public final Set<String> includes;
        public final Set<String> excludes;
        public Set<File> files;
        public final Set<Path> filePaths;
        public final Set<String> filenames;

        public InputDirectoryValue(Class<?> type, Path location, List<String> includes, List<String> excludes, Set<Path> files, Set<String> filenames) {
            this.type = type;
            this.location = location;
            this.includes = includes != null ? Collections.unmodifiableSet(new LinkedHashSet<String>(includes)) : null;
            this.excludes = excludes != null ? Collections.unmodifiableSet(new LinkedHashSet<String>(excludes)) : null;
            this.filePaths = Collections.unmodifiableSet(new LinkedHashSet<Path>(files));
            this.filenames = Collections.unmodifiableSet(new LinkedHashSet<String>(filenames));
            this.files = null;
        }

        @Override
        public Object value() throws ReflectiveOperationException {
            if (this.type == File.class) {
                return this.location.toFile();
            }
            if (this.type == Path.class) {
                return this.location;
            }
            return this;
        }

        @Override
        public void accept(InputVisitor visitor) {
            visitor.visitInputDirectory(this);
        }

        @Override
        public File location() {
            return this.location.toFile();
        }

        @Override
        public Path locationPath() {
            return this.location;
        }

        @Override
        public Set<String> includes() {
            return this.includes;
        }

        @Override
        public Set<String> excludes() {
            return this.excludes;
        }

        @Override
        public Set<File> files() {
            if (this.files == null) {
                this.files = Collections.unmodifiableSet(this.filePaths.stream().map(f -> f.toFile()).collect(Collectors.collectingAndThen(Collectors.toSet(), LinkedHashSet::new)));
            }
            return this.files;
        }

        @Override
        public Set<Path> filePaths() {
            return this.filePaths;
        }

        @Override
        public Set<String> filenames() {
            return this.filenames;
        }
    }

    static class InputFileValue
    extends FileValue {
        public InputFileValue(Class<?> parameterType, Path location) {
            super(parameterType, location);
        }

        @Override
        public void accept(InputVisitor visitor) {
            visitor.visitInputFile(this);
        }
    }

    static class InputFilesValue
    implements Value<Object> {
        final Reflection.MultivalueFactory factory;
        final Set<Path> files;
        final Reflection.ReflectionType type;

        public InputFilesValue(Reflection.MultivalueFactory factory, Collection<Path> files, Reflection.ReflectionType type) {
            this.factory = factory;
            this.files = new LinkedHashSet<Path>(files);
            this.type = type;
        }

        @Override
        public Object value() throws ReflectiveOperationException {
            List members = this.files.stream().map(this.getMapper()).collect(Collectors.toList());
            return this.factory.newInstance(members);
        }

        private Function<Path, ?> getMapper() {
            Class<File> realType;
            Class<File> clazz = realType = this.type.isArray() ? this.type.adaptee().getComponentType() : this.type.adaptee();
            if (realType.isAssignableFrom(File.class)) {
                return Path::toFile;
            }
            return Function.identity();
        }

        @Override
        public void accept(InputVisitor visitor) {
            visitor.visitCollectionFileURL(this);
        }
    }

    static interface InputVisitor {
        public void visitInputFile(InputFileValue var1);

        public void visitInputDirectory(InputDirectoryValue var1);

        public void visitOutputDirectory(OutputDirectoryValue var1);

        public void visitOutputFile(OutputFileValue var1);

        public void visitResourceRoot(GeneratedResourcesDirectoryValue var1);

        public void visitCompileSourceRoot(GeneratedSourcesDirectoryValue var1);

        public void visitString(StringValue var1);

        public void visitMap(MapValue var1);

        public void visitCollectionFileURL(InputFilesValue var1);

        public void visitArtifactResources(ArtifactResourcesValue var1);

        public void visitDependency(DependencyValue var1);

        public void visitDependencyMap(DependencyMapValue var1);
    }

    @FunctionalInterface
    static interface InstanceFactory<T> {
        public T newInstance() throws ReflectiveOperationException;
    }

    static class ListArtifactResourcesValue
    implements Value<Object> {
        final Reflection.MultivalueFactory factory;
        final List<ArtifactResourcesValue> members;

        public ListArtifactResourcesValue(Reflection.MultivalueFactory factory, List<ArtifactResourcesValue> members) {
            this.factory = factory;
            this.members = Collections.unmodifiableList(members);
        }

        @Override
        public Object value() throws ReflectiveOperationException {
            LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
            for (ArtifactResourcesValue member : this.members) {
                urls.addAll(member.urls);
            }
            return this.factory.newInstance(urls);
        }

        @Override
        public void accept(InputVisitor visitor) {
            for (ArtifactResourcesValue member : this.members) {
                member.accept(visitor);
            }
        }
    }

    static class MapValue
    implements Value<Map<String, ?>> {
        final InstanceFactory<Map<String, Object>> supplier;
        public final Map<String, String> configuration;
        public final Function<String, ?> converter;

        public MapValue(InstanceFactory<Map<String, Object>> supplier, Map<String, String> elements, Function<String, ?> converter) {
            this.supplier = supplier;
            this.configuration = Collections.unmodifiableMap(elements);
            this.converter = converter;
        }

        @Override
        public Map<String, Object> value() throws ReflectiveOperationException {
            Map<String, Object> map = this.supplier.newInstance();
            for (Map.Entry<String, String> element : this.configuration.entrySet()) {
                map.put(element.getKey(), this.converter.apply(element.getValue()));
            }
            return map;
        }

        @Override
        public void accept(InputVisitor visitor) {
            visitor.visitMap(this);
        }
    }

    static class OutputDirectoryValue
    extends FileValue {
        public OutputDirectoryValue(Class<?> parameterType, Path location) {
            super(parameterType, location);
        }

        @Override
        public void accept(InputVisitor visitor) {
            visitor.visitOutputDirectory(this);
        }
    }

    static class OutputFileValue
    extends FileValue {
        public OutputFileValue(Class<?> parameterType, Path location) {
            super(parameterType, location);
        }

        @Override
        public void accept(InputVisitor visitor) {
            visitor.visitOutputFile(this);
        }
    }

    static class StringValue
    implements Value<Object> {
        public final String configuration;
        public final Function<String, ?> converter;

        public StringValue(String configuration, Function<String, ?> converter) {
            this.configuration = configuration;
            this.converter = converter;
        }

        @Override
        public Object value() {
            return this.converter.apply(this.configuration);
        }

        @Override
        public void accept(InputVisitor visitor) {
            visitor.visitString(this);
        }
    }

    public static interface Value<T> {
        public T value() throws ReflectiveOperationException;

        default public void accept(InputVisitor visitor) {
        }
    }
}

