/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.GeneratedSourcesDirectory;
import io.takari.builder.IArtifactMetadata;
import io.takari.builder.internal.ArtifactResourceURLStreamHandler;
import io.takari.builder.internal.BuilderInputs;
import io.takari.builder.internal.BuilderWorkspace;
import io.takari.builder.internal.DependencyResolver;
import io.takari.builder.internal.ExpressionEvaluationException;
import io.takari.builder.internal.ExpressionEvaluator;
import io.takari.builder.internal.ProjectModelProvider;
import io.takari.builder.internal.Reflection;
import io.takari.builder.internal.model.AbstractFileParameter;
import io.takari.builder.internal.model.AbstractParameter;
import io.takari.builder.internal.model.AbstractResourceSelectionParameter;
import io.takari.builder.internal.model.ArtifactResourcesParameter;
import io.takari.builder.internal.model.BuilderClass;
import io.takari.builder.internal.model.BuilderMetadataVisitor;
import io.takari.builder.internal.model.BuilderMethod;
import io.takari.builder.internal.model.BuilderValidationVisitor;
import io.takari.builder.internal.model.CompositeParameter;
import io.takari.builder.internal.model.DependenciesParameter;
import io.takari.builder.internal.model.DependencyResourcesParameter;
import io.takari.builder.internal.model.GeneratedResourcesDirectoryParameter;
import io.takari.builder.internal.model.GeneratedSourcesDirectoryParameter;
import io.takari.builder.internal.model.InputDirectoryFilesParameter;
import io.takari.builder.internal.model.InputDirectoryParameter;
import io.takari.builder.internal.model.InputFileParameter;
import io.takari.builder.internal.model.MapParameter;
import io.takari.builder.internal.model.MultivalueParameter;
import io.takari.builder.internal.model.OutputDirectoryParameter;
import io.takari.builder.internal.model.OutputFileParameter;
import io.takari.builder.internal.model.SimpleParameter;
import io.takari.builder.internal.model.TypeAdapter;
import io.takari.builder.internal.model.UnsupportedCollectionParameter;
import io.takari.builder.internal.pathmatcher.FileMatcher;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class BuilderInputsBuilder
implements BuilderMetadataVisitor {
    static final String XML_CONFIG_LOCATION = "location";
    static final String XML_CONFIG_INCLUDES = "includes";
    static final String XML_CONFIG_INCLUDE = "include";
    static final String XML_CONFIG_EXCLUDES = "excludes";
    static final String XML_CONFIG_EXCLUDE = "exclude";
    static final String SOURCE_ROOTS_EXPR = "${project.compileSourceRoots}";
    static final String TEST_SOURCE_ROOTS_EXPR = "${project.testCompileSourceRoots}";
    private final ProjectModelProvider projectModelProvider;
    private final DependencyResolver dependencyResolver;
    private final ExpressionEvaluator expressionEvaluator;
    private final Xpp3Dom builderConfiguration;
    private final Map<String, BuilderInputs.Value<?>> forcedParameters;
    private final String goal;
    private final BuilderWorkspace workspace;
    private boolean isNonDeterministic;
    Context context;
    final Map<Field, BuilderInputs.Value<?>> parameters = new LinkedHashMap();

    BuilderInputsBuilder(String goal, ProjectModelProvider projectModelProvider, DependencyResolver dependencyResolver, ExpressionEvaluator expressionEvaluator, Xpp3Dom configuration, Map<String, BuilderInputs.Value<?>> forcedParameters, BuilderWorkspace workspace) {
        this.goal = goal;
        this.projectModelProvider = projectModelProvider;
        this.dependencyResolver = dependencyResolver;
        this.expressionEvaluator = expressionEvaluator;
        this.builderConfiguration = configuration;
        this.forcedParameters = forcedParameters;
        this.workspace = workspace;
    }

    public static BuilderInputs build(String goal, ProjectModelProvider projectModelProvider, DependencyResolver dependencyResolver, ExpressionEvaluator expressionEvaluator, Class<?> clazz, Xpp3Dom configuration, Map<String, BuilderInputs.Value<?>> forcedParameters, BuilderWorkspace builderWorkspace) throws IOException {
        BuilderClass metadata = Reflection.createBuilderClass(clazz);
        return BuilderInputsBuilder.build(goal, projectModelProvider, dependencyResolver, expressionEvaluator, clazz, configuration, forcedParameters, metadata, builderWorkspace);
    }

    static BuilderInputs build(String goal, ProjectModelProvider mavenModelProvider, DependencyResolver dependencyResolver, ExpressionEvaluator expressionEvaluator, Class<?> clazz, Xpp3Dom configuration, Map<String, BuilderInputs.Value<?>> forcedParameters, BuilderClass metadata, BuilderWorkspace workspace) {
        BuilderValidationVisitor vv = new BuilderValidationVisitor(){

            @Override
            protected void error(AbstractParameter parameter, String message) {
                throw new InvalidModelException();
            }

            @Override
            protected void error(BuilderMethod builder, String message) {
                throw new InvalidModelException();
            }
        };
        metadata.accept(vv);
        BuilderInputsBuilder v = new BuilderInputsBuilder(goal, mavenModelProvider, dependencyResolver, expressionEvaluator, configuration, forcedParameters, workspace);
        metadata.accept(v);
        return new BuilderInputs(clazz, v.parameters, v.isNonDeterministic);
    }

    static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    @Override
    public boolean enterMultivalue(MultivalueParameter metadata) {
        this.context = this.context.multivalueSubcontext(metadata.elements.required());
        if (this.context.configuration == null) {
            metadata.elements.accept(this);
        } else {
            Xpp3Dom configuration = this.context.configuration;
            Xpp3Dom[] xpp3DomArray = configuration.getChildren();
            int n = xpp3DomArray.length;
            int n2 = 0;
            while (n2 < n) {
                Xpp3Dom subConfiguration = xpp3DomArray[n2];
                this.context = ((MultivalueContext)this.context).elementSubcontext(subConfiguration);
                metadata.elements.accept(this);
                BuilderInputs.Value<?> element = this.context.value();
                this.context = this.context.parent;
                if (element != null) {
                    this.context.accept(element);
                }
                ++n2;
            }
        }
        List<BuilderInputs.Value<?>> elements = this.context.values();
        this.context = this.context.parent;
        if (elements != null && !elements.isEmpty()) {
            this.context.accept(this.newCollectionValue(metadata.type(), elements));
        }
        return false;
    }

    private BuilderInputs.CollectionValue newCollectionValue(TypeAdapter type, List<BuilderInputs.Value<?>> elements) {
        return new BuilderInputs.CollectionValue(((Reflection.ReflectionType)type).multivalueFactory(), elements);
    }

    @Override
    public void visitUnsupportedCollection(UnsupportedCollectionParameter metadata) {
        throw new IllegalArgumentException();
    }

    @Override
    public void visitMap(MapParameter metadata) {
        if (this.context.configuration == null) {
            if (metadata.required()) {
                throw new InvalidConfigurationException(this.context, "configuration is required for a Map parameter");
            }
            return;
        }
        if (!BuilderInputsBuilder.isEmpty(this.context.configuration.getValue())) {
            throw new InvalidConfigurationException(this.context, "configuration value is not allowed");
        }
        if (this.context.configuration.getChildCount() < 1) {
            throw new InvalidConfigurationException(this.context, "configuration requires at least one child");
        }
        Xpp3Dom configuration = this.context.configuration;
        LinkedHashMap<String, String> elements = new LinkedHashMap<String, String>();
        Xpp3Dom[] xpp3DomArray = configuration.getChildren();
        int n = xpp3DomArray.length;
        int n2 = 0;
        while (n2 < n) {
            Xpp3Dom subConfiguration = xpp3DomArray[n2];
            elements.put(subConfiguration.getName(), subConfiguration.getValue());
            ++n2;
        }
        if (!elements.isEmpty()) {
            BuilderInputs.InstanceFactory<Map<String, Object>> supplier;
            Class<?> type = ((Reflection.ReflectionType)metadata.type()).adaptee();
            Function<String, ?> converter = SimpleParameter.getConverter(metadata.originatingElement().getParameterTypes().get(1));
            if (!type.isInterface()) {
                Constructor<Map<?, ?>> constructor = BuilderInputsBuilder.getMapConstructor(type);
                supplier = () -> (Map)constructor.newInstance(new Object[0]);
            } else {
                supplier = LinkedHashMap::new;
            }
            this.context.accept(new BuilderInputs.MapValue(supplier, elements, converter));
        }
    }

    private static Constructor<Map<?, ?>> getMapConstructor(Class<?> type) {
        try {
            return type.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean enterComposite(CompositeParameter metadata) {
        if (this.context.configuration == null) {
            return false;
        }
        if (!BuilderInputsBuilder.isEmpty(this.context.configuration.getValue())) {
            throw new InvalidConfigurationException(this.context, "configuration value is not allowed");
        }
        HashMap members = new HashMap();
        for (AbstractParameter member : metadata.members) {
            this.context = this.context.singletonSubcontext(member.name(), member.required());
            member.accept(this);
            if (this.context.value() != null) {
                Reflection.ReflectionField element = (Reflection.ReflectionField)member.originatingElement();
                members.put(element.adaptee(), this.context.value());
            }
            this.context = this.context.parent;
        }
        if (!members.isEmpty()) {
            Reflection.ReflectionType element = (Reflection.ReflectionType)metadata.type();
            Class<?> type = element.adaptee();
            this.context.accept(new BuilderInputs.CompositeValue(type, members));
        }
        return false;
    }

    private static Enum<?> enumValue(Class<?> enumType, String value) {
        return Enum.valueOf(enumType, value);
    }

    @Override
    public void visitSimple(SimpleParameter metadata) {
        Reflection.ReflectionType type = (Reflection.ReflectionType)metadata.type();
        Function<String, Object> converter = type.isEnum() ? v -> BuilderInputsBuilder.enumValue(type.adaptee(), v) : SimpleParameter.getConverter(type);
        this.context.evaluator().withValue(metadata.value()).withConfiguration(this.context.configuration).withDefaultValue(metadata.defaultValue()).asStrings().forEach(s -> this.context.accept(new BuilderInputs.StringValue((String)s, converter)));
    }

    @Override
    public boolean enterBuilderClass(BuilderClass metadata) {
        this.context = new SingletonContext(null, metadata.type().simpleName(), this.builderConfiguration, false);
        for (AbstractParameter parameter : metadata.parameters()) {
            BuilderInputs.Value<?> value = this.forcedParameters.get(parameter.name());
            if (value == null) {
                this.context = this.context.singletonSubcontext(parameter.name(), parameter.required());
                parameter.accept(this);
                value = this.context.value();
                this.context = this.context.parent;
            }
            if (value == null) continue;
            Reflection.ReflectionField element = (Reflection.ReflectionField)parameter.originatingElement();
            this.parameters.put(element.adaptee(), value);
        }
        for (String name : this.forcedParameters.keySet()) {
            if (metadata.parameters().stream().anyMatch(p -> name.equals(p.name()))) continue;
            throw new IllegalArgumentException("no such parameter: " + name);
        }
        for (BuilderMethod builder : metadata.builders()) {
            if (!builder.annotation().name().equals(this.goal) || !builder.isNonDeterministic()) continue;
            this.isNonDeterministic = true;
        }
        this.context = null;
        return false;
    }

    @Override
    public void visitBuilder(BuilderMethod metadata) {
    }

    @Override
    public void visitInputDirectory(InputDirectoryParameter metadata) {
        Class<?> type = ((Reflection.ReflectionType)metadata.type()).adaptee();
        List<String> includes = Arrays.asList(metadata.includes());
        List<String> excludes = Arrays.asList(metadata.excludes());
        if (this.context.configuration != null) {
            if (metadata.value().length > 0) {
                throw new InvalidConfigurationException(this.context, "configuration not allowed");
            }
            this.context.configuration().forEach(configuration -> {
                Path location = this.context.evaluator().withConfiguration(configuration.getChild(XML_CONFIG_LOCATION)).asPath();
                if (location == null) {
                    throw new InvalidConfigurationException(this.context, "<location> is required");
                }
                this.pushInputDirectory(type, metadata.required(), location, includes, excludes);
            });
        } else {
            this.context.evaluator().withValue(metadata.value()).withDefaultValue(metadata.defaultValue()).asPathsWithSourceRoots().forEach(f -> this.pushInputDirectory(type, metadata.required(), (Path)f, includes, excludes));
        }
    }

    @Override
    public void visitInputDirectoryFiles(InputDirectoryFilesParameter metadata) {
        new InputFileSelector(metadata).select();
    }

    private void pushInputDirectory(Class<?> type, boolean required, Path location, List<String> includes, List<String> excludes) {
        if (includes.isEmpty()) {
            includes = null;
        }
        if (excludes.isEmpty()) {
            excludes = null;
        }
        if (this.workspace.isRegularFile(location)) {
            throw new InvalidConfigurationException(this.context, location + " is a regular file");
        }
        if (!this.workspace.isDirectory(location)) {
            if (!required) {
                this.context.accept(new BuilderInputs.InputDirectoryValue(type, location, includes, excludes, Collections.emptySet(), Collections.emptySet()));
            }
            return;
        }
        TreeSet<Path> files = new TreeSet<Path>();
        TreeSet<String> filenames = new TreeSet<String>();
        FileMatcher.subdirMatchers((Path)location, includes, excludes).forEach((subdir, matcher) -> {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (Stream<Path> paths = this.workspace.walk((Path)subdir);){
                    paths.filter(path -> this.workspace.exists((Path)path)).filter(path -> matcher.matches(path)).forEach(path2 -> {
                        files.add((Path)path2);
                        filenames.add(subdir.relativize((Path)path2).toString());
                    });
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new InvalidConfigurationException(this.context, "could not list directory files", e);
            }
        });
        if (!required || !files.isEmpty()) {
            this.context.accept(new BuilderInputs.InputDirectoryValue(type, location, includes, excludes, files, filenames));
        }
    }

    @Override
    public void visitDependencies(DependenciesParameter metadata) {
        if (this.context.configuration != null) {
            throw new InvalidConfigurationException(this.context, "configuration not allowed");
        }
        Class<?> type = ((Reflection.ReflectionType)metadata.type()).adaptee();
        Map<IArtifactMetadata, Path> dependencyMap = this.dependencyResolver.getProjectDependencies(metadata.transitive());
        if (dependencyMap.isEmpty()) {
            return;
        }
        if (metadata.originatingElement().getType().isMap()) {
            BuilderInputs.InstanceFactory<Map<IArtifactMetadata, Object>> supplier;
            if (!type.isInterface()) {
                Constructor<Map<?, ?>> constructor = BuilderInputsBuilder.getMapConstructor(type);
                supplier = () -> (Map)constructor.newInstance(new Object[0]);
            } else {
                supplier = LinkedHashMap::new;
            }
            this.context.accept(new BuilderInputs.DependencyMapValue(((Reflection.ReflectionType)metadata.elementType()).adaptee(), supplier, dependencyMap));
        } else {
            List<BuilderInputs.Value<?>> values = dependencyMap.entrySet().stream().map(e -> new BuilderInputs.DependencyValue(type, (IArtifactMetadata)e.getKey(), (Path)e.getValue())).collect(Collectors.toList());
            this.context.accept(this.newCollectionValue(metadata.originatingElement().getType(), values));
        }
    }

    private void visitFileParameter(AbstractFileParameter<?> metadata, boolean checkExists, Function<Path, BuilderInputs.Value<?>> factory) {
        this.context.evaluator().withValue(metadata.value()).withConfiguration(this.context.configuration).withDefaultValue(metadata.defaultValue()).asPaths().filter(p -> !checkExists || this.workspace.exists((Path)p)).forEach(f -> this.context.accept((BuilderInputs.Value)factory.apply((Path)f)));
    }

    @Override
    public void visitOutputDirectory(OutputDirectoryParameter metadata) {
        Class<?> type = ((Reflection.ReflectionType)metadata.type()).adaptee();
        this.visitFileParameter(metadata, false, f -> new BuilderInputs.OutputDirectoryValue(type, (Path)f));
    }

    @Override
    public void visitOutputFile(OutputFileParameter metadata) {
        Class<?> type = ((Reflection.ReflectionType)metadata.type()).adaptee();
        this.visitFileParameter(metadata, false, f -> new BuilderInputs.OutputFileValue(type, (Path)f));
    }

    @Override
    public void visitGeneratedResourcesDirectory(GeneratedResourcesDirectoryParameter metadata) {
        Class<?> type = ((Reflection.ReflectionType)metadata.type()).adaptee();
        Xpp3Dom configuration = this.context.configuration;
        List<String> includes = this.context.evaluator().withValue(metadata.includes()).withConfiguration(configuration != null && configuration.getChildCount() > 0 ? configuration.getChild(XML_CONFIG_INCLUDES) : null).withDefaultValue(metadata.defaultIncludes()).asStrings().collect(Collectors.toList());
        List<String> excludes = this.context.evaluator().withValue(metadata.excludes()).withConfiguration(configuration != null && configuration.getChildCount() > 0 ? configuration.getChild(XML_CONFIG_EXCLUDES) : null).withDefaultValue(metadata.defaultExcludes()).asStrings().collect(Collectors.toList());
        Path location = this.context.evaluator().withValue(metadata.value()).withConfiguration(configuration != null && configuration.getChildCount() > 0 ? configuration.getChild(XML_CONFIG_LOCATION) : configuration).withDefaultValue(metadata.defaultValue()).asPath();
        this.context.accept(new BuilderInputs.GeneratedResourcesDirectoryValue(type, location, metadata.getResourceType(), includes, excludes));
    }

    @Override
    public void visitGeneratedSourcesDirectory(GeneratedSourcesDirectoryParameter metadata) {
        Class<?> type = ((Reflection.ReflectionType)metadata.type()).adaptee();
        GeneratedSourcesDirectory ann = (GeneratedSourcesDirectory)metadata.annotation();
        this.visitFileParameter(metadata, false, f -> new BuilderInputs.GeneratedSourcesDirectoryValue(type, (Path)f, ann.sourceType()));
    }

    @Override
    public void visitInputFile(InputFileParameter metadata) {
        Class<?> type = ((Reflection.ReflectionType)metadata.type()).adaptee();
        this.visitFileParameter(metadata, metadata.required(), f -> {
            if (this.workspace.isDirectory((Path)f)) {
                throw new InvalidConfigurationException(this.context, f + " is a directory");
            }
            return new BuilderInputs.InputFileValue(type, (Path)f);
        });
    }

    @Override
    public void visitDependencyResources(DependencyResourcesParameter metadata) {
        new DependencyResourceSelector(metadata).select();
    }

    @Override
    public void visitArtifactResources(ArtifactResourcesParameter metadata) {
        new ArtifactResourceSelector(metadata).select();
    }

    static class ArtifactLocation {
        final IArtifactMetadata metadata;
        final Path jar;

        public ArtifactLocation(IArtifactMetadata artifact, Path jar) {
            this.metadata = artifact;
            this.jar = jar;
        }
    }

    class ArtifactResourceSelector
    extends BaseArtifactResourceSelector {
        public ArtifactResourceSelector(ArtifactResourcesParameter parameter) {
            super("resources", "artifacts", "artifact", parameter);
        }
    }

    class BaseArtifactResourceSelector
    extends ResourceSelector<BuilderInputs.ArtifactResourcesValue, ArtifactLocation> {
        public BaseArtifactResourceSelector(String multivalue, String locationPlural, String locationSingular, AbstractResourceSelectionParameter parameter) {
            super(multivalue, locationPlural, locationSingular, parameter);
        }

        private String evaluate(Xpp3Dom element, String childName, boolean required) {
            Xpp3Dom child = element.getChild(childName);
            if (child == null) {
                if (required) {
                    throw new InvalidConfigurationException(BuilderInputsBuilder.this.context, "<" + childName + "> is required");
                }
                return null;
            }
            if (child.getChildCount() > 0) {
                throw new InvalidConfigurationException(BuilderInputsBuilder.this.context, "<" + childName + "> must not have child elements");
            }
            if (BuilderInputsBuilder.isEmpty(child.getValue())) {
                if (required) {
                    throw new InvalidConfigurationException(BuilderInputsBuilder.this.context, "<" + childName + "> value is required");
                }
                return null;
            }
            return BuilderInputsBuilder.this.context.evaluator().evaluate(child.getValue());
        }

        @Override
        Map.Entry<ArtifactLocation, Path> evaluateLocation(Xpp3Dom location) throws UncheckedIOException {
            if (location.getChildCount() > 0 && !BuilderInputsBuilder.isEmpty(location.getValue())) {
                throw new InvalidConfigurationException(BuilderInputsBuilder.this.context, "both elements and value are not allowed");
            }
            if (!BuilderInputsBuilder.isEmpty(location.getValue())) {
                return this.evaluateLocation(location.getValue());
            }
            String groupId = this.evaluate(location, "groupId", true);
            String artifactId = this.evaluate(location, "artifactId", true);
            String classifier = this.evaluate(location, "classifier", false);
            return this.evaluateLocation(groupId, artifactId, classifier);
        }

        private Map.Entry<ArtifactLocation, Path> evaluateLocation(String groupId, String artifactId, String classifier) {
            Map.Entry<IArtifactMetadata, Path> dependency = BuilderInputsBuilder.this.dependencyResolver.getProjectDependency(groupId, artifactId, classifier);
            if (dependency == null || dependency.getValue() == null || !BuilderInputsBuilder.this.workspace.isRegularFile(dependency.getValue()) && !BuilderInputsBuilder.this.workspace.isDirectory(dependency.getValue())) {
                String gac = String.valueOf(groupId) + ":" + artifactId;
                if (classifier != null) {
                    gac = String.valueOf(gac) + ":" + classifier;
                }
                throw new InvalidConfigurationException(BuilderInputsBuilder.this.context, "dependency " + gac + " does not exist");
            }
            return this.toArtifactLocation(dependency);
        }

        protected Map.Entry<ArtifactLocation, Path> toArtifactLocation(Map.Entry<IArtifactMetadata, Path> dependency) {
            Path location = dependency.getValue();
            IArtifactMetadata metadata = dependency.getKey();
            ArtifactLocation artifact = new ArtifactLocation(metadata, BuilderInputsBuilder.this.workspace.isRegularFile(location) ? location : null);
            return new AbstractMap.SimpleEntry<ArtifactLocation, Path>(artifact, location);
        }

        @Override
        Map.Entry<ArtifactLocation, Path> evaluateLocation(String location) throws UncheckedIOException {
            StringTokenizer st = new StringTokenizer(location, ":");
            String groupId = st.nextToken();
            String artifactId = st.nextToken();
            String classifier = st.hasMoreTokens() ? st.nextToken() : null;
            return this.evaluateLocation(groupId, artifactId, classifier);
        }

        @Override
        BuilderInputs.Value<?> newCollectionResourceValue(TypeAdapter type, Map<ResourceSelection<ArtifactLocation>, List<Path>> resources, TypeAdapter parameterType) {
            List<BuilderInputs.ArtifactResourcesValue> values = resources.entrySet().stream().map(e -> this.newBucketValue((ResourceSelection)e.getKey(), (List)e.getValue())).collect(Collectors.toList());
            return new BuilderInputs.ListArtifactResourcesValue(((Reflection.ReflectionType)type).multivalueFactory(), values);
        }

        @Override
        BuilderInputs.ArtifactResourcesValue newBucketValue(ResourceSelection<ArtifactLocation> selection, List<Path> paths) {
            try {
                ArtifactLocation artifact = (ArtifactLocation)selection.bucket;
                ArrayList<URL> urls = new ArrayList<URL>();
                for (Path resource : paths) {
                    URL url;
                    String relpath;
                    if (BuilderInputsBuilder.this.workspace.isRegularFile(selection.location)) {
                        relpath = resource.toString();
                        url = new URI("jar:" + selection.location.toUri() + "!/" + relpath).toURL();
                    } else {
                        relpath = this.relativePath(selection.location, resource);
                        url = resource.toUri().toURL();
                    }
                    urls.add(ArtifactResourceURLStreamHandler.newURL(artifact.metadata, relpath, url));
                }
                TreeSet<Path> files = new TreeSet<Path>();
                if (artifact.jar != null) {
                    files.add(artifact.jar);
                } else {
                    paths.stream().forEach(p -> {
                        boolean bl = files.add((Path)p);
                    });
                }
                return new BuilderInputs.ArtifactResourcesValue(files, artifact.metadata, urls);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    abstract class Context {
        public final Context parent;
        public final String name;
        public final Xpp3Dom configuration;

        protected Context(Context parent, String name, Xpp3Dom configuration) {
            this.parent = parent;
            this.name = name;
            this.configuration = configuration;
        }

        public abstract void accept(BuilderInputs.Value<?> var1);

        public abstract List<BuilderInputs.Value<?>> values();

        public abstract BuilderInputs.Value<?> value();

        public abstract Stream<Xpp3Dom> configuration();

        public MultivalueContext multivalueSubcontext(boolean required) {
            return new MultivalueContext(this, this.name, this.configuration, required);
        }

        public SingletonContext singletonSubcontext(String name, boolean required) {
            Xpp3Dom subConfiguration = this.configuration != null ? this.configuration.getChild(name) : null;
            return new SingletonContext(this, "." + name, subConfiguration, required);
        }

        public Evaluator evaluator() {
            return new Evaluator(this);
        }

        public String getBacktrace() {
            StringBuilder sb = new StringBuilder();
            Context ctx = this;
            while (ctx != null) {
                sb.insert(0, ctx.name);
                ctx = ctx.parent;
            }
            return sb.toString();
        }
    }

    class DependencyResourceSelector
    extends BaseArtifactResourceSelector {
        public DependencyResourceSelector(AbstractResourceSelectionParameter parameter) {
            super("resources", "dependencies", "dependency", parameter);
        }

        @Override
        List<ResourceSelection<ArtifactLocation>> evaluateConfiguration() throws UncheckedIOException {
            List<ResourceSelection<ArtifactLocation>> buckets = super.evaluateConfiguration();
            if (buckets == null) {
                List<String> includes = this.includes(BuilderInputsBuilder.this.context.configuration);
                List<String> excludes = this.excludes(BuilderInputsBuilder.this.context.configuration);
                buckets = BuilderInputsBuilder.this.dependencyResolver.getProjectDependencies(true).entrySet().stream().map(this::toArtifactLocation).map(e -> new ResourceSelection<ArtifactLocation>((ArtifactLocation)e.getKey(), (Path)e.getValue(), includes, excludes)).collect(Collectors.toList());
            }
            return buckets;
        }
    }

    class Evaluator {
        private final Context context;
        private String[] value;
        private Xpp3Dom configuration;
        private String[] defaultValue;

        public Evaluator(Context context) {
            this.context = context;
        }

        public Evaluator withValue(String[] value) {
            assert (this.value == null);
            this.value = value;
            return this;
        }

        public Evaluator withConfiguration(Xpp3Dom configuration) {
            assert (this.configuration == null);
            this.configuration = configuration;
            return this;
        }

        public Evaluator withDefaultValue(String[] defaultValue) {
            assert (this.defaultValue == null);
            this.defaultValue = defaultValue;
            return this;
        }

        private Stream<String> configuration() {
            if (this.configuration == null) {
                return Stream.empty();
            }
            Stream<Xpp3Dom> result = this.configuration.getChildCount() > 0 ? Stream.of(this.configuration.getChildren()) : Stream.of(this.configuration);
            return result.map(xml -> xml != null ? xml.getValue() : null).filter(str -> !BuilderInputsBuilder.isEmpty(str));
        }

        public Stream<String> asStrings() {
            return this.asStrings(false);
        }

        public Stream<String> asStrings(boolean allowSourceRoots) {
            if (this.value != null && this.value.length > 0) {
                if (this.configuration().count() > 0L) {
                    throw new InvalidConfigurationException(this.context, "configuration is not allowed");
                }
                String[] valueToEvaluate = this.parseSourceRoots(this.value, allowSourceRoots);
                return Stream.of(valueToEvaluate).map(s -> this.evaluate((String)s));
            }
            List configuration = this.configuration().collect(Collectors.toList());
            if (!configuration.isEmpty()) {
                return configuration.stream();
            }
            if (this.defaultValue != null && this.defaultValue.length > 0) {
                String[] valueToEvaluate = this.parseSourceRoots(this.defaultValue, allowSourceRoots);
                return Stream.of(valueToEvaluate).map(s -> {
                    try {
                        return this.evaluate((String)s);
                    }
                    catch (InvalidConfigurationException invalidConfigurationException) {
                        return null;
                    }
                }).filter(s -> s != null);
            }
            return Stream.empty();
        }

        private String[] parseSourceRoots(String[] initialValue, boolean allowSourceRoots) {
            List<String> sourceRoots;
            List<String> values = Arrays.asList(initialValue);
            String expr = null;
            Iterator<String> valIter = values.iterator();
            String prevVal = null;
            while (valIter.hasNext()) {
                String currentVal = valIter.next();
                if (expr != null) {
                    throw new InvalidConfigurationException(this.context, String.format("%s can not have other values provided along with it", expr));
                }
                if (currentVal.equals(BuilderInputsBuilder.SOURCE_ROOTS_EXPR) || currentVal.equals(BuilderInputsBuilder.TEST_SOURCE_ROOTS_EXPR)) {
                    if (prevVal != null) {
                        throw new InvalidConfigurationException(this.context, String.format("%s can not have other values provided along with it", currentVal));
                    }
                    if (!allowSourceRoots) {
                        throw new InvalidConfigurationException(this.context, String.format("%s expression is not allowed here", currentVal));
                    }
                    expr = currentVal;
                }
                prevVal = currentVal;
            }
            if (BuilderInputsBuilder.SOURCE_ROOTS_EXPR.equals(expr)) {
                return sourceRoots.toArray(new String[(sourceRoots = BuilderInputsBuilder.this.projectModelProvider.getCompileSourceRoots()) != null ? sourceRoots.size() : 0]);
            }
            if (BuilderInputsBuilder.TEST_SOURCE_ROOTS_EXPR.equals(expr)) {
                return sourceRoots.toArray(new String[(sourceRoots = BuilderInputsBuilder.this.projectModelProvider.getTestCompileSourceRoots()) != null ? sourceRoots.size() : 0]);
            }
            return initialValue;
        }

        public Stream<Path> asPaths() {
            return this.asStrings().map(s -> this.toPath((String)s));
        }

        public Stream<Path> asPathsWithSourceRoots() {
            return this.asStrings(true).map(s -> this.toPath((String)s));
        }

        public Path asPath() {
            if (this.value != null && this.value.length > 0) {
                return this.toPath(this.evaluate(this.value[0]));
            }
            if (this.configuration != null) {
                if (this.configuration.getValue().equals(BuilderInputsBuilder.SOURCE_ROOTS_EXPR) || this.configuration.getValue().equals(BuilderInputsBuilder.TEST_SOURCE_ROOTS_EXPR)) {
                    throw new InvalidConfigurationException(this.context, String.format("%s expression is not allowed in configuration", this.configuration.getValue()));
                }
                return this.toPath(this.evaluate(this.configuration.getValue()));
            }
            if (this.defaultValue != null && this.defaultValue.length > 0) {
                try {
                    return this.toPath(this.evaluate(this.defaultValue[0]));
                }
                catch (InvalidConfigurationException invalidConfigurationException) {}
            }
            return null;
        }

        private Path toPath(String path) {
            Path file = Paths.get(path, new String[0]);
            if (!file.isAbsolute()) {
                file = BuilderInputsBuilder.this.projectModelProvider.getBasedir().toAbsolutePath().resolve(path);
            }
            try {
                return file.toFile().getCanonicalFile().toPath();
            }
            catch (IOException iOException) {
                return file.normalize();
            }
        }

        private String evaluate(String str) {
            if (BuilderInputsBuilder.isEmpty(str)) {
                return null;
            }
            try {
                return BuilderInputsBuilder.this.expressionEvaluator.evaluate(str.trim());
            }
            catch (ExpressionEvaluationException e) {
                throw new InvalidConfigurationException(this.context, e.getMessage(), e);
            }
        }
    }

    class InputFileSelector
    extends ResourceSelector<BuilderInputs.InputDirectoryValue, Path> {
        public InputFileSelector(InputDirectoryFilesParameter parameter) {
            super("files", "locations", BuilderInputsBuilder.XML_CONFIG_LOCATION, parameter);
        }

        @Override
        protected boolean shouldAllowSourceRoots() {
            return true;
        }

        @Override
        AbstractMap.SimpleEntry<Path, Path> evaluateLocation(String location) throws UncheckedIOException {
            Path path = BuilderInputsBuilder.this.context.evaluator().toPath(location);
            return new AbstractMap.SimpleEntry<Path, Path>(path, path);
        }

        @Override
        AbstractMap.SimpleEntry<Path, Path> evaluateLocation(Xpp3Dom location) throws UncheckedIOException {
            if (location.getChildCount() > 0) {
                throw new InvalidConfigurationException(BuilderInputsBuilder.this.context, "only value is allowed");
            }
            String value = location.getValue();
            if (value.equals(BuilderInputsBuilder.SOURCE_ROOTS_EXPR) || value.equals(BuilderInputsBuilder.TEST_SOURCE_ROOTS_EXPR)) {
                throw new InvalidConfigurationException(BuilderInputsBuilder.this.context, String.format("%s expression is not allowed in configuration", value));
            }
            return this.evaluateLocation(location.getValue());
        }

        @Override
        BuilderInputs.InputDirectoryValue newBucketValue(ResourceSelection<Path> selection, List<Path> paths) {
            Class<?> type = ((Reflection.ReflectionType)this.parameter.type()).adaptee();
            Path basedir = (Path)selection.bucket;
            List<String> includes = selection.includes;
            List<String> excludes = selection.excludes;
            TreeSet<Path> files = new TreeSet<Path>();
            TreeSet<String> filenames = new TreeSet<String>();
            if (paths != null) {
                paths.forEach(path -> {
                    files.add((Path)path);
                    filenames.add(this.relativePath(resourceSelection.location, (Path)path));
                });
            }
            return new BuilderInputs.InputDirectoryValue(type, basedir, includes, excludes, files, filenames);
        }

        @Override
        BuilderInputs.Value<?> newCollectionResourceValue(TypeAdapter type, Map<ResourceSelection<Path>, List<Path>> resources, TypeAdapter parameterType) {
            List<Path> files = resources.values().stream().flatMap(list -> list.stream()).collect(Collectors.toList());
            return new BuilderInputs.InputFilesValue(((Reflection.ReflectionType)type).multivalueFactory(), files, (Reflection.ReflectionType)parameterType);
        }
    }

    static class InvalidConfigurationException
    extends RuntimeException {
        public final Context context;

        public InvalidConfigurationException(Context context, String message) {
            super(String.valueOf(context.getBacktrace()) + ": " + message);
            this.context = context;
        }

        public InvalidConfigurationException(Context context, String message, Throwable cause) {
            super(String.valueOf(context.getBacktrace()) + ": " + message, cause);
            this.context = context;
        }
    }

    static class InvalidModelException
    extends RuntimeException {
        InvalidModelException() {
        }
    }

    class MultivalueContext
    extends Context {
        private final List<BuilderInputs.Value<?>> values;
        private final boolean required;

        public MultivalueContext(Context parent, String name, Xpp3Dom configuration, boolean required) {
            super(parent, name, configuration);
            this.values = new ArrayList();
            this.required = required;
        }

        @Override
        public void accept(BuilderInputs.Value<?> value) {
            this.values.add(value);
        }

        @Override
        public List<BuilderInputs.Value<?>> values() {
            if (this.values.isEmpty()) {
                if (this.required) {
                    throw new InvalidConfigurationException(BuilderInputsBuilder.this.context, "is required");
                }
                return null;
            }
            return this.values;
        }

        @Override
        public BuilderInputs.Value<?> value() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Stream<Xpp3Dom> configuration() {
            return this.configuration != null ? Stream.of(this.configuration.getChildren()) : Stream.empty();
        }

        public SingletonContext elementSubcontext(Xpp3Dom configuration) {
            String name = "[" + this.values.size() + "]";
            return new SingletonContext(this, name, configuration, this.required);
        }
    }

    static class ResourceSelection<B> {
        final B bucket;
        final Path location;
        final List<String> includes;
        final List<String> excludes;

        public ResourceSelection(B bucket, Path location) {
            this(bucket, location, null, null);
        }

        public ResourceSelection(B bucket, Path location, List<String> includes, List<String> excludes) {
            this.bucket = bucket;
            this.location = location;
            this.includes = includes;
            this.excludes = excludes;
        }
    }

    abstract class ResourceSelector<V extends BuilderInputs.Value<?>, B> {
        final String xmlMultivalue;
        final String xmlLocationPlural;
        final String xmlLocationSingular;
        final AbstractResourceSelectionParameter parameter;

        protected ResourceSelector(String multivalue, String locationPlural, String locationSingular, AbstractResourceSelectionParameter parameter) {
            this.xmlMultivalue = multivalue;
            this.xmlLocationPlural = locationPlural;
            this.xmlLocationSingular = locationSingular;
            this.parameter = parameter;
        }

        abstract Map.Entry<B, Path> evaluateLocation(Xpp3Dom var1) throws UncheckedIOException;

        abstract Map.Entry<B, Path> evaluateLocation(String var1) throws UncheckedIOException;

        abstract V newBucketValue(ResourceSelection<B> var1, List<Path> var2);

        abstract BuilderInputs.Value<?> newCollectionResourceValue(TypeAdapter var1, Map<ResourceSelection<B>, List<Path>> var2, TypeAdapter var3);

        protected boolean shouldAllowSourceRoots() {
            return false;
        }

        final void select() {
            List<ResourceSelection<B>> selections = null;
            if (this.parameter.value().length > 0) {
                selections = this.parseLocations(this.parameter.value());
            }
            if (selections == null) {
                selections = this.evaluateConfiguration();
            }
            if (selections == null && this.parameter.defaultValue().length > 0) {
                selections = this.parseLocations(this.parameter.defaultValue());
            }
            if (selections == null || selections.isEmpty()) {
                return;
            }
            LinkedHashMap<ResourceSelection<B>, List<Path>> resources = new LinkedHashMap<ResourceSelection<B>, List<Path>>();
            for (ResourceSelection<B> selection : selections) {
                List<Path> paths = this.select(selection.location, selection.includes, selection.excludes);
                if (this.parameter.required() && paths.isEmpty()) continue;
                resources.put(selection, paths);
            }
            if (resources.isEmpty()) {
                return;
            }
            TypeAdapter type = this.parameter.originatingElement().getType();
            if (type.isArray() || type.isIterable()) {
                TypeAdapter parameterType = this.parameter.type();
                if (parameterType.isSameType(URL.class) || parameterType.isSameType(File.class) || parameterType.isSameType(Path.class)) {
                    BuilderInputsBuilder.this.context.accept(this.newCollectionResourceValue(type, resources, parameterType));
                } else {
                    BuilderInputsBuilder.this.context.accept(BuilderInputsBuilder.this.newCollectionValue(type, this.toListBucketValue(resources)));
                }
            } else if (resources.size() == 1) {
                Map.Entry entry = resources.entrySet().iterator().next();
                BuilderInputsBuilder.this.context.accept((BuilderInputs.Value<?>)this.newBucketValue((ResourceSelection)entry.getKey(), (List)entry.getValue()));
            } else {
                throw new InvalidConfigurationException(BuilderInputsBuilder.this.context, "too many values");
            }
        }

        private List<BuilderInputs.Value<?>> toListBucketValue(Map<ResourceSelection<B>, List<Path>> resources) {
            return resources.entrySet().stream().map(e -> this.newBucketValue((ResourceSelection)e.getKey(), (List)e.getValue())).collect(Collectors.toList());
        }

        final String relativePath(Path basedir, Path path) {
            return basedir.relativize(path).toString();
        }

        private List<Path> select(Path basedir, List<String> includes, List<String> excludes) {
            if (includes != null && includes.isEmpty()) {
                includes = null;
            }
            if (excludes != null && excludes.isEmpty()) {
                excludes = null;
            }
            if (BuilderInputsBuilder.this.workspace.isRegularFile(basedir)) {
                if (this instanceof InputFileSelector) {
                    throw new InvalidConfigurationException(BuilderInputsBuilder.this.context, basedir + " is a regular file");
                }
                FileMatcher matcher = FileMatcher.absoluteMatcher((Path)Paths.get("/", new String[0]), includes, excludes);
                return this.selectFromJar(basedir, matcher);
            }
            if (BuilderInputsBuilder.this.workspace.isDirectory(basedir)) {
                return this.selectFromDirectory(FileMatcher.subdirMatchers((Path)basedir, includes, excludes));
            }
            return Collections.emptyList();
        }

        private List<Path> selectFromJar(Path basedir, FileMatcher matcher) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (JarFile jarFile = new JarFile(basedir.toFile());){
                    Enumeration<JarEntry> entries = jarFile.entries();
                    ArrayList<Path> matchedPaths = new ArrayList<Path>();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (entry.isDirectory() || !matcher.matches("/" + entry.getName())) continue;
                        matchedPaths.add(Paths.get(entry.getName(), new String[0]));
                    }
                    return matchedPaths;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new InvalidConfigurationException(BuilderInputsBuilder.this.context, "could not list jar entries", e);
            }
        }

        private List<Path> selectFromDirectory(Map<Path, FileMatcher> matchers) {
            ArrayList<Path> resources = new ArrayList<Path>();
            matchers.forEach((subdir, matcher) -> {
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (Stream<Path> paths = BuilderInputsBuilder.this.workspace.walk((Path)subdir);){
                        paths.filter(path -> matcher.matches(path)).forEach(resources::add);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new InvalidConfigurationException(BuilderInputsBuilder.this.context, "could not list directory files", e);
                }
            });
            return resources;
        }

        List<ResourceSelection<B>> evaluateConfiguration() throws UncheckedIOException {
            Xpp3Dom configuration = BuilderInputsBuilder.this.context.configuration;
            if (configuration == null) {
                return null;
            }
            Xpp3Dom[] multivalue = configuration.getChildren(this.xmlMultivalue);
            if (multivalue.length > 0) {
                ArrayList<ResourceSelection<B>> buckets = new ArrayList<ResourceSelection<B>>();
                Xpp3Dom[] xpp3DomArray = multivalue;
                int n = multivalue.length;
                int n2 = 0;
                while (n2 < n) {
                    Xpp3Dom files = xpp3DomArray[n2];
                    buckets.addAll(this.evaluateConfiguration(files, true));
                    ++n2;
                }
                return buckets;
            }
            return this.evaluateConfiguration(configuration, false);
        }

        final List<ResourceSelection<B>> evaluateConfiguration(Xpp3Dom configuration, boolean required) {
            List<String> includes = this.includes(configuration);
            List<String> excludes = this.excludes(configuration);
            if (configuration.getChildCount() == 0 && !BuilderInputsBuilder.isEmpty(configuration.getValue())) {
                Map.Entry<B, Path> e = this.evaluateLocation(configuration.getValue());
                return Collections.singletonList(new ResourceSelection<B>(e.getKey(), e.getValue(), includes, excludes));
            }
            Xpp3Dom[] locations = this.getXmlList(configuration, this.xmlLocationPlural, this.xmlLocationSingular);
            if (locations != null && locations.length > 0) {
                return Stream.of(locations).map(this::evaluateLocation).map(p -> new ResourceSelection(p.getKey(), (Path)p.getValue(), includes, excludes)).collect(Collectors.toList());
            }
            if (required) {
                throw new InvalidConfigurationException(BuilderInputsBuilder.this.context, "<" + this.xmlLocationSingular + "> element is required");
            }
            return null;
        }

        final List<ResourceSelection<B>> parseLocations(String[] locations) {
            List<String> includes = this.includes(BuilderInputsBuilder.this.context.configuration);
            List<String> excludes = this.excludes(BuilderInputsBuilder.this.context.configuration);
            return BuilderInputsBuilder.this.context.evaluator().withValue(locations).asStrings(this.shouldAllowSourceRoots()).map(this::evaluateLocation).map(f -> new ResourceSelection(f.getKey(), (Path)f.getValue(), includes, excludes)).collect(Collectors.toList());
        }

        private List<String> evaluate(String[] strings) {
            return BuilderInputsBuilder.this.context.evaluator().withValue(strings).asStrings().collect(Collectors.toList());
        }

        final Xpp3Dom[] getXmlList(Xpp3Dom element, String plural, String single) {
            if (element == null) {
                return null;
            }
            Xpp3Dom[] list = element.getChildren(plural);
            if (list.length > 1) {
                throw new InvalidConfigurationException(BuilderInputsBuilder.this.context, "only one <" + plural + "> is allowed");
            }
            Xpp3Dom[] flatlist = element.getChildren(single);
            if (flatlist.length > 0 && list.length > 0) {
                throw new InvalidConfigurationException(BuilderInputsBuilder.this.context, "Use <" + plural + "> or <" + single + ">");
            }
            if (list.length > 0) {
                flatlist = list[0].getChildren(single);
            }
            return flatlist;
        }

        final List<String> mergeStringList(String[] hardcoded, String[] defaults, Xpp3Dom xml, String xmlPlural, String xmlSingle) {
            if (hardcoded.length > 0) {
                return this.evaluate(hardcoded);
            }
            Xpp3Dom[] flatlist = this.getXmlList(xml, xmlPlural, xmlSingle);
            if (flatlist != null && flatlist.length > 0) {
                return Stream.of(flatlist).map(x -> BuilderInputsBuilder.this.context.evaluator().evaluate(x.getValue())).collect(Collectors.toList());
            }
            if (defaults.length > 0) {
                return this.evaluate(defaults);
            }
            return null;
        }

        final List<String> includes(Xpp3Dom configuration) {
            List<String> includes = this.mergeStringList(this.parameter.includes(), this.parameter.defaultIncludes(), configuration, BuilderInputsBuilder.XML_CONFIG_INCLUDES, BuilderInputsBuilder.XML_CONFIG_INCLUDE);
            if (includes == null || includes.isEmpty()) {
                throw new InvalidConfigurationException(BuilderInputsBuilder.this.context, "<includes> is required");
            }
            return includes;
        }

        final List<String> excludes(Xpp3Dom configuration) {
            return this.mergeStringList(this.parameter.excludes(), this.parameter.defaultExcludes(), configuration, BuilderInputsBuilder.XML_CONFIG_EXCLUDES, BuilderInputsBuilder.XML_CONFIG_EXCLUDE);
        }

        final boolean containsOnly(Xpp3Dom element, String ... children) {
            boolean contains = false;
            LinkedHashSet<String> invalid = new LinkedHashSet<String>();
            Xpp3Dom[] xpp3DomArray = element.getChildren();
            int n2 = xpp3DomArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Xpp3Dom child = xpp3DomArray[n3];
                if (Stream.of(children).anyMatch(n -> n.equals(child.getName()))) {
                    contains = true;
                } else {
                    invalid.add(child.getName());
                }
                ++n3;
            }
            if (contains && !invalid.isEmpty()) {
                throw new InvalidConfigurationException(BuilderInputsBuilder.this.context, "invalid configuration elements: " + invalid);
            }
            return contains;
        }
    }

    class SingletonContext
    extends Context {
        private final boolean required;
        private BuilderInputs.Value<?> value;

        public SingletonContext(Context parent, String name, Xpp3Dom configuration, boolean required) {
            super(parent, name, configuration);
            this.required = required;
        }

        @Override
        public void accept(BuilderInputs.Value<?> value) {
            assert (this.value == null);
            this.value = value;
        }

        @Override
        public List<BuilderInputs.Value<?>> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BuilderInputs.Value<?> value() {
            if (this.required && this.value == null) {
                throw new InvalidConfigurationException(BuilderInputsBuilder.this.context, "is required");
            }
            return this.value;
        }

        @Override
        public Stream<Xpp3Dom> configuration() {
            return this.configuration != null ? Stream.of(this.configuration) : Stream.empty();
        }
    }
}

