/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.internal.pathmatcher.PathMatcher;
import io.takari.builder.internal.pathmatcher.PathNormalizer;
import io.takari.incrementalbuild.classpath.ClasspathEntriesSupplier;
import java.nio.file.Paths;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class ClasspathMatcher {
    private final List<ClasspathEntriesSupplier> suppliers;
    private PathMatcher matcher;

    @Inject
    public ClasspathMatcher(List<ClasspathEntriesSupplier> suppliers) {
        this.suppliers = suppliers;
    }

    public synchronized PathMatcher getMatcher() {
        if (this.matcher == null) {
            this.matcher = this.createMatcher();
        }
        return this.matcher;
    }

    private PathMatcher createMatcher() {
        PathMatcher.Builder builder = PathMatcher.builder((PathNormalizer)new PathNormalizer(Paths.get("/", new String[0])));
        this.suppliers.stream().map(s -> s.entries()).flatMap(entries -> entries.stream()).forEach(entry -> {
            PathMatcher.Builder builder2 = builder.includePrefix(PathNormalizer.normalize0((String)entry));
        });
        return builder.build();
    }
}

