/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.internal.model.BuilderClass;
import io.takari.builder.internal.model.MemberAdapter;
import io.takari.builder.internal.model.MethodAdapter;
import io.takari.builder.internal.model.TypeAdapter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Reflection {
    public static Collection<Field> getAllFields(Class<?> clazz) {
        return Reflection.addFields(clazz, new ArrayList<Field>());
    }

    private static List<Field> addFields(Class<?> clazz, List<Field> fields) {
        if (clazz.getSuperclass() != null) {
            Reflection.addFields(clazz.getSuperclass(), fields);
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean funny;
            Field field = fieldArray[n2];
            boolean bl = funny = field.isSynthetic() || Modifier.isStatic(field.getModifiers());
            if (!funny) {
                fields.add(field);
            }
            ++n2;
        }
        return fields;
    }

    public static boolean isIterableType(Class<?> fieldType) {
        return Iterable.class.isAssignableFrom(fieldType);
    }

    public static boolean isMapType(Class<?> fieldType) {
        return Map.class.isAssignableFrom(fieldType);
    }

    public static List<Class<?>> getParameterTypes(Field field) {
        ArrayList types = new ArrayList();
        Class<?> fieldType = field.getType();
        if (fieldType.isArray()) {
            types.add(fieldType.getComponentType());
        } else if ((Reflection.isIterableType(fieldType) || Reflection.isMapType(fieldType)) && field.getGenericType() instanceof ParameterizedType) {
            Type[] typeArguments;
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            Type[] typeArray = typeArguments = parameterizedType.getActualTypeArguments();
            int n = typeArguments.length;
            int n2 = 0;
            while (n2 < n) {
                Type typeArgument = typeArray[n2];
                if (typeArgument instanceof Class) {
                    types.add((Class)typeArgument);
                }
                if (typeArgument instanceof ParameterizedType) {
                    types.add((Class)((ParameterizedType)typeArguments[0]).getRawType());
                }
                ++n2;
            }
        }
        return types;
    }

    private static <T> Constructor<T> getConstructor(Class<?> type) {
        try {
            return type.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException();
        }
    }

    public static BuilderClass createBuilderClass(Class<?> clazz) {
        return BuilderClass.create(new ReflectionType(clazz));
    }

    static interface MultivalueFactory {
        public Object newInstance(Collection<?> var1) throws ReflectiveOperationException;
    }

    public static class ReflectionField
    implements MemberAdapter {
        private final Field adaptee;

        public ReflectionField(Field adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            return this.adaptee.isAnnotationPresent(annotationClass);
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return this.adaptee.getAnnotation(annotationClass);
        }

        public Field adaptee() {
            return this.adaptee;
        }

        @Override
        public String getName() {
            return this.adaptee.getName();
        }

        @Override
        public ReflectionType getDeclaringType() {
            return new ReflectionType(this.adaptee.getDeclaringClass());
        }

        @Override
        public List<TypeAdapter> getParameterTypes() {
            return Reflection.getParameterTypes(this.adaptee).stream().map(type -> new ReflectionType((Class<?>)type)).collect(Collectors.toList());
        }

        @Override
        public ReflectionType getType() {
            return new ReflectionType(this.adaptee.getType());
        }

        public String toString() {
            return this.adaptee.toString();
        }
    }

    public static class ReflectionMethod
    implements MethodAdapter {
        private final Method adaptee;

        public ReflectionMethod(Method adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return this.adaptee.getAnnotation(annotationClass);
        }

        @Override
        public int getParameterCount() {
            return this.adaptee.getParameterCount();
        }

        public Method adaptee() {
            return this.adaptee;
        }
    }

    public static class ReflectionType
    implements TypeAdapter {
        private final Class<?> adaptee;

        public ReflectionType(Class<?> adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public String simpleName() {
            return this.adaptee.getSimpleName();
        }

        @Override
        public String qualifiedName() {
            return this.adaptee.getCanonicalName();
        }

        public Class<?> adaptee() {
            return this.adaptee;
        }

        @Override
        public boolean isPrimitive() {
            return this.adaptee.isPrimitive();
        }

        @Override
        public boolean isIterable() {
            return Reflection.isIterableType(this.adaptee);
        }

        @Override
        public boolean isMap() {
            return Reflection.isMapType(this.adaptee);
        }

        @Override
        public boolean isEnum() {
            return this.adaptee.isEnum();
        }

        @Override
        public List<MemberAdapter> getAllMembers() {
            ArrayList<MemberAdapter> members = new ArrayList<MemberAdapter>();
            for (Field field : Reflection.getAllFields(this.adaptee)) {
                members.add(new ReflectionField(field));
            }
            return members;
        }

        @Override
        public List<MethodAdapter> getMethods() {
            ArrayList<MethodAdapter> methods = new ArrayList<MethodAdapter>();
            Method[] methodArray = this.adaptee.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                methods.add(new ReflectionMethod(method));
                ++n2;
            }
            return methods;
        }

        @Override
        public boolean isSameType(Class<?> type) {
            return this.adaptee == type;
        }

        public String toString() {
            return this.adaptee.toString();
        }

        @Override
        public boolean isInterface() {
            return this.adaptee.isInterface();
        }

        @Override
        public boolean isLocalClass() {
            return this.adaptee.isLocalClass();
        }

        @Override
        public boolean isAnonymousClass() {
            return this.adaptee.isAnonymousClass();
        }

        @Override
        public boolean isInnerClass() {
            return this.adaptee.getEnclosingClass() != null && !Modifier.isStatic(this.adaptee.getModifiers());
        }

        @Override
        public boolean isAbstract() {
            return Modifier.isAbstract(this.adaptee.getModifiers());
        }

        @Override
        public boolean isArray() {
            return this.adaptee.isArray();
        }

        @Override
        public boolean isAssignableFrom(Class<?> type) {
            return this.adaptee.isAssignableFrom(type);
        }

        @Override
        public boolean hasNoargConstructor() {
            try {
                return this.adaptee.getConstructor(new Class[0]) != null;
            }
            catch (NoSuchMethodException | SecurityException exception) {
                return false;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public MultivalueFactory multivalueFactory() {
            if (this.isIterable()) {
                if (!this.adaptee.isInterface()) {
                    Constructor constructor = Reflection.getConstructor(this.adaptee);
                    return elements -> {
                        Collection collection = (Collection)constructor.newInstance(new Object[0]);
                        collection.addAll(elements);
                        return collection;
                    };
                }
                if (List.class.isAssignableFrom(this.adaptee)) {
                    return elements -> Collections.unmodifiableList(new ArrayList(elements));
                }
                if (Set.class.isAssignableFrom(this.adaptee)) {
                    return elements -> Collections.unmodifiableSet(new LinkedHashSet(elements));
                }
                if (!Collection.class.isAssignableFrom(this.adaptee)) throw new IllegalArgumentException();
                return elements -> Collections.unmodifiableList(new ArrayList(elements));
            }
            if (!this.isArray()) throw new UnsupportedOperationException("not a multi-value type:" + this.adaptee);
            return elements -> {
                Object array = Array.newInstance(this.adaptee.getComponentType(), elements.size());
                Iterator iter = elements.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    Array.set(array, i, iter.next());
                    ++i;
                }
                return array;
            };
        }
    }
}

