/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.maven;

import io.takari.builder.IArtifactMetadata;
import io.takari.builder.internal.Dependency;
import io.takari.builder.internal.DependencyResolver;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

public class MavenProjectDependencyResolver
implements DependencyResolver {
    final MavenProject project;

    public MavenProjectDependencyResolver(MavenProject project) {
        this.project = project;
    }

    @Override
    public Map<IArtifactMetadata, Path> getProjectDependencies(boolean transitive) {
        Set artifacts = transitive ? this.project.getArtifacts() : this.project.getDependencyArtifacts();
        LinkedHashMap<IArtifactMetadata, Path> result = new LinkedHashMap<IArtifactMetadata, Path>();
        artifacts.forEach(a -> result.put(new ArtifactMetadataImpl((Artifact)a), a.getFile().toPath()));
        return result;
    }

    private boolean matchesArtifact(Dependency dependency, Artifact a) {
        return dependency.matchesArtifact(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getClassifier());
    }

    public AbstractMap.SimpleEntry<IArtifactMetadata, Path> getProjectDependency(String groupId, String artifactId, String classifier) {
        Dependency dependency = new Dependency(groupId, artifactId, classifier);
        Artifact artifact = this.project.getArtifacts().stream().filter(a -> this.matchesArtifact(dependency, (Artifact)a)).findFirst().get();
        return new AbstractMap.SimpleEntry<IArtifactMetadata, Path>(new ArtifactMetadataImpl(artifact), artifact.getFile().toPath());
    }

    private static class ArtifactMetadataImpl
    implements IArtifactMetadata {
        private final Artifact artifact;

        ArtifactMetadataImpl(Artifact artifact) {
            this.artifact = artifact;
        }

        @Override
        public String getGroupId() {
            return this.artifact.getGroupId();
        }

        @Override
        public String getArtifactId() {
            return this.artifact.getArtifactId();
        }

        @Override
        public String getVersion() {
            return this.artifact.getVersion();
        }

        @Override
        public String getType() {
            return this.artifact.getType();
        }

        @Override
        public String getClassifier() {
            return this.artifact.getClassifier();
        }
    }
}

