/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.model;

import io.takari.builder.IArtifactMetadata;
import io.takari.builder.IArtifactResources;
import io.takari.builder.IDirectoryFiles;
import io.takari.builder.Parameter;
import io.takari.builder.ResolutionScope;
import io.takari.builder.internal.model.AbstractParameter;
import io.takari.builder.internal.model.AbstractResourceSelectionParameter;
import io.takari.builder.internal.model.ArtifactResourcesParameter;
import io.takari.builder.internal.model.BuilderClass;
import io.takari.builder.internal.model.BuilderMetadataVisitor;
import io.takari.builder.internal.model.BuilderMethod;
import io.takari.builder.internal.model.CompositeParameter;
import io.takari.builder.internal.model.DependenciesParameter;
import io.takari.builder.internal.model.DependencyResourcesParameter;
import io.takari.builder.internal.model.GeneratedResourcesDirectoryParameter;
import io.takari.builder.internal.model.GeneratedSourcesDirectoryParameter;
import io.takari.builder.internal.model.InputDirectoryFilesParameter;
import io.takari.builder.internal.model.InputDirectoryParameter;
import io.takari.builder.internal.model.InputFileParameter;
import io.takari.builder.internal.model.MapParameter;
import io.takari.builder.internal.model.MemberAdapter;
import io.takari.builder.internal.model.MultivalueParameter;
import io.takari.builder.internal.model.OutputDirectoryParameter;
import io.takari.builder.internal.model.OutputFileParameter;
import io.takari.builder.internal.model.SimpleParameter;
import io.takari.builder.internal.model.TypeAdapter;
import io.takari.builder.internal.model.UnsupportedCollectionParameter;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public abstract class BuilderValidationVisitor
implements BuilderMetadataVisitor {
    private ResolutionScope resolutionScope;

    static boolean isEmpty(String[] value) {
        return value == null || value.length == 0;
    }

    protected abstract void error(BuilderMethod var1, String var2);

    protected abstract void error(AbstractParameter var1, String var2);

    private void error(AbstractParameter parameter, String message, Object ... values) {
        this.error(parameter, String.format(message, values));
    }

    private void validateParameterAnnotation(AbstractParameter parameter) {
        Class<? extends Annotation> annotationClass;
        MemberAdapter element = parameter.originatingElement();
        Annotation annotation = parameter.annotation();
        Class<? extends Annotation> clazz = annotationClass = annotation != null ? annotation.annotationType() : null;
        assert (annotationClass == null || element.isAnnotationPresent(annotationClass));
        TreeSet presentAnnotations = BuilderClass.parameterAnnotations().stream().filter(a -> element.isAnnotationPresent((Class<? extends Annotation>)a)).map(a -> a.getSimpleName()).collect(Collectors.toCollection(TreeSet::new));
        if (presentAnnotations.size() > 1) {
            this.error(parameter, "ambigous parameter annotation present: %s", presentAnnotations);
        }
    }

    @Override
    public boolean enterBuilderClass(BuilderClass metadata) {
        HashMap<String, AbstractParameter> parameters = new HashMap<String, AbstractParameter>();
        for (AbstractParameter parameter : metadata.parameters()) {
            if (parameters.containsKey(parameter.name())) {
                AbstractParameter origin = (AbstractParameter)parameters.get(parameter.name());
                this.error(parameter, "Builder parameter '%s' duplicates parameter defined in %s", parameter.name(), origin.originatingElement().getDeclaringType().qualifiedName());
            }
            parameters.put(parameter.name(), parameter);
        }
        return true;
    }

    @Override
    public void visitBuilder(BuilderMethod metadata) {
        TypeAdapter type;
        String name = metadata.annotation().name();
        if (!name.matches("[\\p{Alnum}-]+")) {
            this.error(metadata, "invalid goal name");
        }
        if ((type = metadata.declaringType()).isInterface() || type.isLocalClass() || type.isAnonymousClass() || type.isInnerClass() || type.isAbstract()) {
            this.error(metadata, "Only concrete classes are allowed to contain Builder methods");
        }
        if (metadata.originatingElement().getParameterCount() > 0) {
            this.error(metadata, "Buidler method must not take parameters");
        }
    }

    @Override
    public boolean enterMultivalue(MultivalueParameter metadata) {
        TypeAdapter type = metadata.type();
        if (!type.isArray()) {
            if (!type.isInterface() && !type.hasNoargConstructor()) {
                this.error(metadata, "multivalue prarmeter type %s must have no-arg constructor", type.qualifiedName());
            }
            if (type.isInterface() && !type.isAssignableFrom(List.class) && !type.isAssignableFrom(Set.class) && !type.isAssignableFrom(Collection.class)) {
                this.error(metadata, "multivalue prarmeter type must be concrete type or one of Collection, List and Set");
            }
        }
        return true;
    }

    @Override
    public void visitUnsupportedCollection(UnsupportedCollectionParameter metadata) {
        List<TypeAdapter> elementTypes = metadata.elementTypes;
        if (elementTypes.isEmpty()) {
            this.error(metadata, "Raw Collection or wildcard Collection element type");
        } else {
            this.error(metadata, "Unsupported Collection element type %s", elementTypes.get(0).simpleName());
        }
    }

    @Override
    public void visitMap(MapParameter metadata) {
        TypeAdapter type = metadata.type();
        if (!type.isMap()) {
            throw new IllegalArgumentException();
        }
        List<TypeAdapter> types = metadata.element.getParameterTypes();
        if (types.size() != 2) {
            this.error(metadata, "Raw Map or wildcard Map key and/or value types");
            return;
        }
        if (!types.get(0).isSameType(String.class)) {
            this.error(metadata, "Key for map parameter must be assignable from String");
        }
        if (!SimpleParameter.isSimpleType(types.get(1))) {
            this.error(metadata, "Only simple parameters are allowed as values for map parameters");
        }
    }

    @Override
    public boolean enterComposite(CompositeParameter metadata) {
        Parameter ann = metadata.annotation();
        if (ann != null && (ann.value().length > 0 || ann.defaultValue().length > 0)) {
            this.error(metadata, "@Parameter target type %s does not support value/defaultValue", metadata.type().qualifiedName());
        }
        return true;
    }

    @Override
    public void visitSimple(SimpleParameter metadata) {
        this.validateParameterAnnotation(metadata);
        if (!BuilderValidationVisitor.isEmpty(metadata.value()) && !BuilderValidationVisitor.isEmpty(metadata.defaultValue())) {
            this.error(metadata, "@Parameter 'value' and 'defaultValue' attributes cannot be both specified");
        }
        if (metadata.type().isPrimitive() && metadata.annotation() != null && !metadata.required()) {
            this.error(metadata, "Parameter '%s' of primitive type '%s' must be required", metadata.name(), metadata.type().qualifiedName());
        }
    }

    @Override
    public void visitInputDirectory(InputDirectoryParameter metadata) {
        this.validateParameterAnnotation(metadata);
        TypeAdapter type = metadata.type();
        if (!type.isSameType(File.class) && !type.isSameType(Path.class)) {
            this.error(metadata, "@InputDirectory paramerer must be of type File or Path");
        }
        if (!BuilderValidationVisitor.isEmpty(metadata.value()) && !BuilderValidationVisitor.isEmpty(metadata.defaultValue())) {
            this.error(metadata, "@InputDirectory 'value' and 'defaultValue' attributes cannot be both specified");
        }
    }

    @Override
    public void visitInputDirectoryFiles(InputDirectoryFilesParameter metadata) {
        this.validateParameterAnnotation(metadata);
        TypeAdapter type = metadata.type();
        if (type.isArray() || type.isIterable()) {
            type = metadata.originatingElement().getParameterTypes().get(0);
        }
        if (!(type.isSameType(IDirectoryFiles.class) || type.isSameType(File.class) || type.isSameType(Path.class))) {
            this.error(metadata, "@InputDirectoryFiles paramerer must be of type DirectoryFiles, File, or Path");
        }
        if (!BuilderValidationVisitor.isEmpty(metadata.value()) && !BuilderValidationVisitor.isEmpty(metadata.defaultValue())) {
            this.error(metadata, "@InputDirectoryFiles 'value' and 'defaultValue' attributes cannot be both specified");
        }
    }

    @Override
    public void visitDependencies(DependenciesParameter metadata) {
        TypeAdapter type = metadata.type();
        if (type.isMap()) {
            List<TypeAdapter> types = metadata.element.getParameterTypes();
            if (types.size() != 2) {
                this.error(metadata, "Raw Map or wildcard Map key and/or value types");
                return;
            }
            if (!types.get(0).isSameType(IArtifactMetadata.class)) {
                this.error(metadata, "Key for @Dependency map parameter must be of type IArtifactMetadata");
            }
            if (!types.get(1).isSameType(File.class) && !types.get(1).isSameType(Path.class)) {
                this.error(metadata, "Only Files or Paths are allowed as values for @Dependency map parameters");
            }
        } else if (!(metadata.type().isSameType(File.class) || metadata.type().isSameType(IArtifactMetadata.class) || metadata.type().isSameType(Path.class))) {
            this.error(metadata, "@Dependencies must be of type %s, %s or %s", File.class, Path.class, IArtifactMetadata.class);
        }
        this.validateResolutionScope(metadata.annotation().scope(), metadata);
    }

    private void validateResolutionScope(ResolutionScope scope, AbstractParameter metadata) {
        if (this.resolutionScope != null && !this.resolutionScope.equals((Object)scope)) {
            this.error(metadata, "ambiguous resolution scope configuration");
        } else {
            this.resolutionScope = scope;
        }
    }

    private void validateArtifactResources(AbstractResourceSelectionParameter metadata, ResolutionScope scope, String parameterName) {
        this.validateParameterAnnotation(metadata);
        this.validateResolutionScope(scope, metadata);
        TypeAdapter type = metadata.type();
        if (type.isArray() || type.isIterable()) {
            type = metadata.originatingElement().getParameterTypes().get(0);
        }
        if (!type.isSameType(URL.class) && !type.isSameType(IArtifactResources.class)) {
            this.error(metadata, String.valueOf(parameterName) + " parameter must be of type URL or IArtifactResources");
        }
    }

    @Override
    public void visitOutputDirectory(OutputDirectoryParameter metadata) {
        this.validateParameterAnnotation(metadata);
    }

    @Override
    public void visitOutputFile(OutputFileParameter metadata) {
        this.validateParameterAnnotation(metadata);
    }

    @Override
    public void visitGeneratedResourcesDirectory(GeneratedResourcesDirectoryParameter metadata) {
        this.validateParameterAnnotation(metadata);
    }

    @Override
    public void visitGeneratedSourcesDirectory(GeneratedSourcesDirectoryParameter metadata) {
        this.validateParameterAnnotation(metadata);
    }

    @Override
    public void visitInputFile(InputFileParameter metadata) {
        this.validateParameterAnnotation(metadata);
    }

    @Override
    public void visitDependencyResources(DependencyResourcesParameter metadata) {
        this.validateArtifactResources(metadata, metadata.annotation().scope(), "@DependencyResources");
    }

    @Override
    public void visitArtifactResources(ArtifactResourcesParameter metadata) {
        this.validateArtifactResources(metadata, metadata.annotation().scope(), "@ArtifactResources");
    }
}

