/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.model;

import io.takari.builder.Parameter;
import io.takari.builder.internal.model.AbstractParameter;
import io.takari.builder.internal.model.BuilderMetadataVisitor;
import io.takari.builder.internal.model.MemberAdapter;
import io.takari.builder.internal.model.TypeAdapter;
import java.util.Collections;
import java.util.List;

public class CompositeParameter
extends AbstractParameter {
    private final Parameter annotation;
    public final List<AbstractParameter> members;

    CompositeParameter(MemberAdapter element, TypeAdapter type, List<AbstractParameter> members) {
        super(element, type);
        this.annotation = element.getAnnotation(Parameter.class);
        this.members = Collections.unmodifiableList(members);
    }

    @Override
    public void accept(BuilderMetadataVisitor visitor) {
        if (visitor.enterComposite(this)) {
            this.members.forEach(v -> v.accept(visitor));
            visitor.leaveComposite(this);
        }
    }

    @Override
    public Parameter annotation() {
        return this.annotation;
    }

    @Override
    public boolean required() {
        return this.annotation != null && this.annotation.required();
    }
}

