/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.incrementalbuild.classpath.ClasspathEntriesSupplier;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class JvmClasspathEntriesSupplier
implements ClasspathEntriesSupplier {
    private final Collection<String> classpath = new LinkedHashSet<String>();

    public JvmClasspathEntriesSupplier() {
        String javaHome = System.getProperty("java.home");
        if (javaHome != null) {
            if (javaHome.endsWith(String.valueOf(File.separator) + "jre")) {
                javaHome = javaHome.substring(0, javaHome.length() - 3);
            }
            this.classpath.add(javaHome);
        }
        this.addPathProperty("java.endorsed.dirs");
        this.addPathProperty("java.ext.dirs");
        this.addPathProperty("java.class.path");
        this.addPathProperty("java.library.path");
        this.addPathProperty("sun.boot.library.path");
        String mavenHome = System.getProperty("maven.home");
        if (mavenHome != null) {
            this.classpath.add(mavenHome);
        }
        this.addPathProperty("maven.ext.class.path");
        this.addPathProperty("mavendev.testclasspath");
    }

    private void addPathProperty(String name) {
        String value = System.getProperty(name);
        if (value != null && !value.isEmpty()) {
            Stream.of(value.split(File.pathSeparator)).filter(path -> path != null && !".".equals(path) && !"".equals(path)).forEach(path -> this.classpath.add((String)path));
        }
    }

    public Collection<String> entries() {
        return this.classpath;
    }
}

