/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.cache;

import io.takari.builder.internal.pathmatcher.JarEntries;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;

public class JarEntriesCache {
    private static final JarEntriesCache INSTANCE = new JarEntriesCache();
    private final Map<Key, JarEntries> cache = new ConcurrentHashMap<Key, JarEntries>();

    private JarEntriesCache() {
    }

    public static JarEntriesCache get() {
        return INSTANCE;
    }

    public JarEntries get(Path path) {
        Key key = new Key(path, path.toFile().length(), path.toFile().lastModified());
        return this.cache.computeIfAbsent(key, k -> {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (JarFile jarFile = new JarFile(((Key)k).path.toFile());){
                    return new JarEntries(jarFile.entries());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to list Jar Entries", e);
            }
        });
    }

    private static class Key {
        private final Path path;
        private final long length;
        private final long lastModified;

        public Key(Path path, long length, long lastModified) {
            this.path = path;
            this.length = length;
            this.lastModified = lastModified;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (int)(this.lastModified ^ this.lastModified >>> 32);
            result = 31 * result + (int)(this.length ^ this.length >>> 32);
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.lastModified != other.lastModified) {
                return false;
            }
            if (this.length != other.length) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }
    }
}

