/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.maven;

import io.takari.builder.internal.maven.AbstractIncrementalMojo;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.SessionScoped;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.MojoExecutionEvent;
import org.apache.maven.execution.MojoExecutionListener;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;

@Named
@SessionScoped
public class LegacyMojoWhitelist
implements MojoExecutionListener {
    static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final String FILE_WHITELIST = ".mvn/mojo-whitelist.config";
    final Path configFile;
    final Map<String, Set<String>> whitelist;

    @Inject
    public LegacyMojoWhitelist(MavenSession session) throws IOException, MojoExecutionException {
        this(session.getRequest().getMultiModuleProjectDirectory() != null ? Paths.get(session.getRequest().getMultiModuleProjectDirectory().getCanonicalPath(), FILE_WHITELIST) : null);
    }

    LegacyMojoWhitelist(Path configFile) throws IOException, MojoExecutionException {
        this.configFile = configFile;
        if (configFile == null) {
            this.whitelist = null;
            return;
        }
        LinkedHashMap executionWhitelist = null;
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedReader r = Files.newBufferedReader(configFile);){
                String str;
                executionWhitelist = new LinkedHashMap();
                int lineno = 0;
                while ((str = r.readLine()) != null) {
                    if (str.startsWith("#") || (str = str.trim()).isEmpty()) continue;
                    StringTokenizer st = new StringTokenizer(str, ":");
                    try {
                        String groupId = st.nextToken();
                        String artifactId = st.nextToken();
                        String goal = st.nextToken();
                        String key = this.key(groupId, artifactId, goal);
                        if (!executionWhitelist.containsKey(key)) {
                            executionWhitelist.put(key, new LinkedHashSet());
                        }
                        if (!st.hasMoreTokens()) continue;
                        String executionId = st.nextToken();
                        String projectGroupId = st.nextToken();
                        String projectArtifactId = st.nextToken();
                        ((Set)executionWhitelist.get(key)).add(this.executionKey(executionId, projectGroupId, projectArtifactId));
                        if (!st.hasMoreElements()) continue;
                        throw this.newMojoExecutionException(lineno, str);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw this.newMojoExecutionException(lineno, str);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {}
        this.whitelist = executionWhitelist != null ? Collections.unmodifiableMap(executionWhitelist) : null;
    }

    private MojoExecutionException newMojoExecutionException(int lineno, String line) {
        String msg = String.format("Invalid %s:%d configuration, expected <groupId>:<artifactId>:<goal> or <groupId>:<artifactId>:<goal>:<executionId>:<projectGroupId>:<projectArtifactId>, found %s", FILE_WHITELIST, lineno, line);
        return new MojoExecutionException(msg);
    }

    private String key(String groupId, String artifactId, String goal) {
        return String.valueOf(groupId) + ":" + artifactId + ":" + goal;
    }

    private String executionKey(String executionId, String projectGroupId, String projectArtifactId) {
        return String.valueOf(executionId) + ":" + projectGroupId + ":" + projectArtifactId;
    }

    public void beforeMojoExecution(MojoExecutionEvent event) throws MojoExecutionException {
        if (this.whitelist == null) {
            return;
        }
        MojoExecution execution = event.getExecution();
        if (execution.getLifecyclePhase() == null) {
            return;
        }
        String key = this.key(execution.getGroupId(), execution.getArtifactId(), execution.getGoal());
        boolean legacy = !AbstractIncrementalMojo.class.isInstance(event.getMojo());
        boolean executionWhitelisted = this.isExecutionWhitelisted(key, execution.getExecutionId(), event.getProject().getGroupId(), event.getProject().getArtifactId());
        if (legacy && !executionWhitelisted) {
            String msg = String.format("Unsupported legacy mojo %s @ %s. Whitelist file location %s", execution, event.getProject().getArtifactId(), this.configFile);
            throw new MojoExecutionException(msg);
        }
        if (!legacy && executionWhitelisted) {
            String msg = String.format("Redundant whitelist entry for builder %s @ %s. Whitelist file location %s", execution, event.getProject().getArtifactId(), this.configFile);
            throw new MojoExecutionException(msg);
        }
    }

    boolean isExecutionWhitelisted(String key, String executionId, String projectGroupId, String projectArtifactId) {
        if (!this.whitelist.containsKey(key)) {
            return false;
        }
        Set<String> executions = this.whitelist.get(key);
        if (executions.isEmpty()) {
            return true;
        }
        return executions.contains(this.executionKey(executionId, projectGroupId, projectArtifactId)) || executions.contains(this.executionKey(executionId, "*", "*"));
    }

    public void afterMojoExecutionSuccess(MojoExecutionEvent event) throws MojoExecutionException {
    }

    public void afterExecutionFailure(MojoExecutionEvent event) {
    }
}

