/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.maven;

import io.takari.builder.internal.cache.ScopedProjectDependencyCache;
import io.takari.builder.internal.maven.MavenDependencyResolver;
import io.takari.builder.internal.resolver.ArtifactResolverProvider;
import io.takari.builder.internal.resolver.DependencyResolver;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.SessionScoped;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;

@Named(value="maven")
@SessionScoped
public class MavenArtifactResolverProvider
implements ArtifactResolverProvider<MavenProject> {
    public static final String MAVEN = "maven";
    private final MavenSession session;
    private final RepositorySystem repositorySystem;
    private final ScopedProjectDependencyCache dependencyCache;

    @Inject
    public MavenArtifactResolverProvider(MavenSession session, RepositorySystem repositorySystem, ScopedProjectDependencyCache dependencyCache) {
        this.session = session;
        this.repositorySystem = repositorySystem;
        this.dependencyCache = dependencyCache;
    }

    @Override
    public DependencyResolver getResolver(MavenProject project) {
        return new MavenDependencyResolver(project, this.session.getRepositorySession(), this.repositorySystem, this.dependencyCache);
    }
}

