/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.testing;

import io.takari.builder.internal.BuilderContext;
import io.takari.builder.internal.ResourceRoot;
import io.takari.builder.internal.pathmatcher.PathNormalizer;
import io.takari.builder.testing.BuilderExecution;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;

public class BuilderExecutionResult {
    private final BuilderExecution execution;
    private final BuilderContext context;

    BuilderExecutionResult(BuilderExecution execution, BuilderContext context) {
        this.execution = execution;
        this.context = context;
    }

    public BuilderExecutionResult assertNoErrors() {
        return this;
    }

    public BuilderExecutionResult assertOutputFiles(File basedir, String ... paths) {
        TreeSet actual = this.context != null ? this.context.getWrittenFiles().stream().map(s -> PathNormalizer.normalize0((String)s)).filter(s -> new File((String)s).isFile()).collect(Collectors.toCollection(TreeSet::new)) : new TreeSet();
        TreeSet expected = Stream.of(paths).map(s -> PathNormalizer.normalize0((Path)new File(basedir, (String)s).toPath())).collect(Collectors.toCollection(TreeSet::new));
        Assert.assertEquals((String)"(re)created outputs", (Object)BuilderExecutionResult.toString(expected), (Object)BuilderExecutionResult.toString(actual));
        return this;
    }

    private static String toString(Collection<?> objects) {
        StringBuilder sb = new StringBuilder();
        objects.forEach(o -> {
            StringBuilder stringBuilder2 = sb.append(o.toString()).append('\n');
        });
        return sb.toString();
    }

    public BuilderExecutionResult assertProjectResources(ResourceRoot ... resourceRoots) {
        TreeSet actual = this.execution.projectResources.stream().map(r -> String.valueOf(PathNormalizer.normalize0((String)r.getLocation())) + r.getIncludes() + r.getExcludes()).collect(Collectors.toCollection(TreeSet::new));
        TreeSet expected = Stream.of(resourceRoots).map(r -> String.valueOf(PathNormalizer.normalize0((String)r.getLocation())) + r.getIncludes() + r.getExcludes()).collect(Collectors.toCollection(TreeSet::new));
        Assert.assertEquals((String)"generated project resources", (Object)BuilderExecutionResult.toString(expected), (Object)BuilderExecutionResult.toString(actual));
        return this;
    }

    public BuilderExecutionResult assertCompileSourceRoots(File ... roots) {
        this.assertSourceRoots("compile source roots", this.execution.compileSourceRoots, roots);
        return this;
    }

    public BuilderExecutionResult assertTestCompileSourceRoots(File ... roots) {
        this.assertSourceRoots("test compile source roots", this.execution.testCompileSourceRoots, roots);
        return this;
    }

    private void assertSourceRoots(String message, Collection<String> _actual, File ... _expected) {
        TreeSet actual = _actual.stream().map(s -> PathNormalizer.normalize0((String)s)).collect(Collectors.toCollection(TreeSet::new));
        TreeSet expected = Stream.of(_expected).map(s -> PathNormalizer.normalize0((String)s.getAbsolutePath())).collect(Collectors.toCollection(TreeSet::new));
        Assert.assertEquals((String)message, (Object)BuilderExecutionResult.toString(expected), (Object)BuilderExecutionResult.toString(actual));
    }
}

