/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.internal.BuilderInputs;
import io.takari.builder.internal.CompileSourceRoot;
import io.takari.builder.internal.IncrementalBuildException;
import io.takari.builder.internal.Message;
import io.takari.builder.internal.ResourceRoot;
import io.takari.builder.internal.digest.FileDigest;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.util.xml.CompactXMLWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

class BuilderExecutionState {
    public final BuilderInputs.Digest inputsDigest;
    public final Map<String, Object> properties;
    public final Serializable classpathDigest;
    public final Collection<String> outputPaths;
    public final Set<CompileSourceRoot> compileSourceRoots;
    public final Set<ResourceRoot> resourceRoots;
    public final List<Message> messages;
    public final Map<String, FileDigest> exceptionsDigest;
    private static final String OUTPUT_DOM_NAME = "o";
    static final InprogressStateWriter NOOP_INPROGRESSWRITER = new InprogressStateWriter(){

        @Override
        public void close() {
        }

        @Override
        public void writePath(String path) {
        }
    };

    private BuilderExecutionState(BuilderInputs.Digest inputsDigest, Map<String, Object> properties, Serializable classpathDigest, Collection<String> outputPaths, Set<CompileSourceRoot> compileSourceRoots, Set<ResourceRoot> resourceRoots, List<Message> messages, Map<String, FileDigest> exceptionsDigest) {
        this.inputsDigest = inputsDigest;
        this.properties = properties;
        this.classpathDigest = classpathDigest;
        this.outputPaths = outputPaths;
        this.compileSourceRoots = compileSourceRoots;
        this.resourceRoots = resourceRoots;
        this.messages = messages;
        this.exceptionsDigest = exceptionsDigest;
    }

    public boolean isEscalated() {
        return false;
    }

    /*
     * Loose catch block
     */
    public static BuilderExecutionState load(Path file) {
        Collection<String> outputPaths = Collections.emptySet();
        if (file != null && Files.isRegularFile(file, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                    BuilderExecutionState builderExecutionState;
                    ObjectInputStream ois;
                    Throwable throwable2;
                    block22: {
                        throwable2 = null;
                        Object var6_9 = null;
                        ois = new ObjectInputStream(new BufferedInputStream(is));
                        outputPaths = BuilderExecutionState.readOutputPaths(ois);
                        BuilderInputs.Digest inputsDigest = (BuilderInputs.Digest)ois.readObject();
                        Map properties = (Map)ois.readObject();
                        Serializable classpathDigest = (Serializable)ois.readObject();
                        Set compileSourceRoots = (Set)ois.readObject();
                        Set resourceRoots = (Set)ois.readObject();
                        List messages = (List)ois.readObject();
                        Map exceptionsDigest = (Map)ois.readObject();
                        builderExecutionState = new BuilderExecutionState(inputsDigest, properties, classpathDigest, outputPaths, compileSourceRoots, resourceRoots, messages, exceptionsDigest);
                        if (ois == null) break block22;
                        ois.close();
                    }
                    return builderExecutionState;
                    {
                        catch (Throwable throwable3) {
                            try {
                                if (ois != null) {
                                    ois.close();
                                }
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (throwable2 == null) {
                                    throwable2 = throwable4;
                                } else if (throwable2 != throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                throw throwable2;
                            }
                        }
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
            catch (IOException | ClassNotFoundException exception) {}
        }
        return new EscalatedExecutionState(outputPaths);
    }

    public static void store(Path file, BuilderInputs.Digest digest, Map<String, Object> properties, Serializable classpathDigest, Collection<String> outputPaths, Set<CompileSourceRoot> compileSourceRoots, Set<ResourceRoot> resourceRoots, List<Message> messages, Map<String, FileDigest> exceptionsDigest) throws IOException {
        if (file == null) {
            return;
        }
        if (!Files.isDirectory(file.getParent(), new LinkOption[0])) {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
        }
        Throwable throwable = null;
        Object var10_11 = null;
        try (OutputStream os = Files.newOutputStream(file, new OpenOption[0]);){
            Throwable throwable2 = null;
            Object var13_16 = null;
            try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(os));){
                BuilderExecutionState.writeOutputPaths(oos, outputPaths);
                oos.writeObject(digest);
                oos.writeObject(properties);
                oos.writeObject(classpathDigest);
                oos.writeObject(compileSourceRoots);
                oos.writeObject(resourceRoots);
                oos.writeObject(messages);
                oos.writeObject(exceptionsDigest);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    static void writeOutputPaths(ObjectOutputStream os, Collection<String> outputPaths) throws IOException {
        os.writeInt(outputPaths.size());
        for (String path : outputPaths) {
            os.writeUTF(BuilderExecutionState.toPortablePath(path));
        }
    }

    private static String toPortablePath(String path) {
        StringWriter buf = new StringWriter();
        CompactXMLWriter w = new CompactXMLWriter((Writer)buf);
        w.startElement(OUTPUT_DOM_NAME);
        w.writeText(path);
        w.endElement();
        return buf.toString();
    }

    static Collection<String> readOutputPaths(ObjectInputStream is) throws IOException {
        int size = is.readInt();
        HashSet<String> outputPaths = new HashSet<String>(size);
        int i = 0;
        while (i < size) {
            try {
                outputPaths.add(BuilderExecutionState.fromPortablePath(is.readUTF()));
            }
            catch (XmlPullParserException e) {
                throw new StateFormatException(e);
            }
            ++i;
        }
        return outputPaths;
    }

    private static String fromPortablePath(String string) throws XmlPullParserException, IOException {
        Xpp3Dom dom = Xpp3DomBuilder.build((Reader)new StringReader(string));
        if (!OUTPUT_DOM_NAME.equals(dom.getName())) {
            throw new XmlPullParserException("invalid element " + dom.getName());
        }
        return dom.getValue();
    }

    static Collection<String> readInprogressOutputPaths(Path file) throws IOException {
        HashSet<String> paths = new HashSet<String>();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader reader = Files.newBufferedReader(file);){
                String str;
                while ((str = reader.readLine()) != null) {
                    paths.add(BuilderExecutionState.fromPortablePath(str));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (XmlPullParserException xmlPullParserException) {}
        return paths;
    }

    static InprogressStateWriter newInprogressWriter(Path file) throws IOException {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        final BufferedWriter writer = Files.newBufferedWriter(file, StandardOpenOption.CREATE_NEW, StandardOpenOption.SYNC);
        return new InprogressStateWriter(){

            @Override
            public void close() throws IOException {
                writer.close();
            }

            @Override
            public void writePath(String path) throws IncrementalBuildException {
                try {
                    writer.write(BuilderExecutionState.toPortablePath(path));
                    writer.newLine();
                    writer.flush();
                }
                catch (IOException e) {
                    throw new IncrementalBuildException(e);
                }
            }
        };
    }

    /* synthetic */ BuilderExecutionState(BuilderInputs.Digest digest, Map map, Serializable serializable, Collection collection, Set set, Set set2, List list, Map map2, BuilderExecutionState builderExecutionState) {
        this(digest, map, serializable, collection, set, set2, list, map2);
    }

    private static class EscalatedExecutionState
    extends BuilderExecutionState {
        EscalatedExecutionState(Collection<String> outputPaths) {
            super(BuilderInputs.emptyDigest(), Collections.emptyMap(), (Serializable)((Object)""), outputPaths, Collections.emptySet(), Collections.emptySet(), Collections.emptyList(), Collections.emptyMap(), null);
        }

        @Override
        public boolean isEscalated() {
            return true;
        }
    }

    static interface InprogressStateWriter
    extends Closeable {
        public void writePath(String var1) throws IncrementalBuildException;
    }

    private static class StateFormatException
    extends RuntimeException {
        public StateFormatException(Throwable cause) {
            super(cause);
        }
    }
}

