/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.Builder;
import io.takari.builder.ResourceType;
import io.takari.builder.enforcer.internal.EnforcerConfig;
import io.takari.builder.enforcer.internal.EnforcerViolation;
import io.takari.builder.internal.BuilderContext;
import io.takari.builder.internal.BuilderExecutionState;
import io.takari.builder.internal.BuilderInputs;
import io.takari.builder.internal.BuilderInputsBuilder;
import io.takari.builder.internal.BuilderWorkspace;
import io.takari.builder.internal.CompileSourceRoot;
import io.takari.builder.internal.ExpressionEvaluationException;
import io.takari.builder.internal.ExpressionEvaluator;
import io.takari.builder.internal.IncrementalBuildException;
import io.takari.builder.internal.Message;
import io.takari.builder.internal.MessageCollector;
import io.takari.builder.internal.ProjectModelProvider;
import io.takari.builder.internal.ResourceRoot;
import io.takari.builder.internal.digest.BytesHash;
import io.takari.builder.internal.digest.ClasspathDigester;
import io.takari.builder.internal.digest.FileDigest;
import io.takari.builder.internal.digest.SHA1Digester;
import io.takari.builder.internal.pathmatcher.PathMatcher;
import io.takari.builder.internal.pathmatcher.PathNormalizer;
import io.takari.builder.internal.resolver.DependencyResolver;
import io.takari.incrementalbuild.workspace.MessageSink;
import io.takari.incrementalbuild.workspace.Workspace;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;

public class BuilderRunner {
    private final Logger log;
    private final Class<?> builderType;
    private final String goal;
    private Path sessionBasedir;
    private Path projectBasedir;
    private Path stateFile;
    private List<Path> classpath = Collections.emptyList();
    private ClasspathDigester classpathDigester;
    private PathMatcher sessionClasspathMatcher;
    private DependencyResolver dependencyResolver;
    private Xpp3Dom configuration;
    private Map<String, String> properties = new HashMap<String, String>();
    private Function<String, String> propertyResolver;
    private Consumer<ResourceRoot> resourceConsumer;
    private List<String> compileSourceRoots;
    private List<String> testCompileSourceRoots;
    private EnforcerConfig enforcerConfig;
    private String builderId;
    private Workspace workspace;
    private MessageSink messageSink;
    private Path defaultFile;
    private int defaultLine;
    private int defaultColumn;
    private Map<String, BuilderInputs.Value<?>> forcedParameters = Collections.emptyMap();
    private final ProjectModelProvider projectModelProvider = new ProjectModelProvider(){

        @Override
        public List<String> getTestCompileSourceRoots() {
            return BuilderRunner.this.testCompileSourceRoots;
        }

        @Override
        public List<String> getCompileSourceRoots() {
            return BuilderRunner.this.compileSourceRoots;
        }

        @Override
        public Path getBasedir() {
            return BuilderRunner.this.projectBasedir;
        }
    };

    private BuilderRunner(Logger log, Class<?> builderType, String goal) {
        this.log = log;
        this.builderType = builderType;
        this.goal = goal;
    }

    public static BuilderRunner create(Logger log, Class<?> builderType, String goal) {
        return new BuilderRunner(log, builderType, goal);
    }

    public BuilderRunner setSessionBasedir(Path basedir) {
        this.sessionBasedir = basedir;
        return this;
    }

    public BuilderRunner setProjectBasedir(Path basedir) {
        this.projectBasedir = basedir;
        return this;
    }

    public BuilderRunner setStateFile(Path stateFile) {
        this.stateFile = stateFile;
        return this;
    }

    public BuilderRunner setSessionClasspathMatcher(PathMatcher matcher) {
        this.sessionClasspathMatcher = matcher;
        return this;
    }

    public BuilderRunner setClasspath(Collection<Path> classpath, ClasspathDigester digester) {
        this.classpath = new ArrayList<Path>(classpath);
        this.classpathDigester = digester;
        return this;
    }

    public BuilderRunner setDependencyResolver(DependencyResolver dependencyResolver) {
        this.dependencyResolver = dependencyResolver;
        return this;
    }

    public BuilderRunner setConfiguration(Xpp3Dom configuration) {
        this.configuration = configuration;
        return this;
    }

    public BuilderRunner setDefaultMessageLocation(Path file, int line, int column) {
        this.defaultFile = file;
        this.defaultLine = line;
        this.defaultColumn = column;
        return this;
    }

    public BuilderRunner setProjectProperties(Function<String, String> resolver) {
        this.propertyResolver = resolver;
        return this;
    }

    public BuilderRunner setProjectResourcesConsumer(Consumer<ResourceRoot> resourceConsumer) {
        this.resourceConsumer = resourceConsumer;
        return this;
    }

    public BuilderRunner setProjectCompileSourceRoots(List<String> compileSourceRoots) {
        this.compileSourceRoots = compileSourceRoots;
        return this;
    }

    public BuilderRunner setProjectTestCompileSourceRoots(List<String> testCompileSourceRoots) {
        this.testCompileSourceRoots = testCompileSourceRoots;
        return this;
    }

    public BuilderRunner setSessionProperties(Properties system, Properties user) {
        BiConsumer<Object, Object> action = (key, value) -> {
            if (key instanceof String && value instanceof String) {
                this.properties.put((String)key, (String)value);
            }
        };
        system.forEach((BiConsumer<? super Object, ? super Object>)action);
        user.forEach((BiConsumer<? super Object, ? super Object>)action);
        return this;
    }

    public BuilderRunner setForcedParameters(Map<String, BuilderInputs.Value<?>> forcedParameters) {
        this.forcedParameters = forcedParameters;
        return this;
    }

    public BuilderRunner setBuilderEnforcerConfig(EnforcerConfig enforcerConfig) {
        this.enforcerConfig = enforcerConfig;
        return this;
    }

    public BuilderRunner setBuilderId(String builderId) {
        this.builderId = builderId;
        return this;
    }

    public BuilderRunner setWorkspace(Workspace workspace) {
        this.workspace = workspace;
        return this;
    }

    public BuilderRunner setMessageSink(MessageSink messageSink) {
        this.messageSink = messageSink;
        return this;
    }

    public <E extends Exception> BuilderContext execute(ExceptionFactory<E> efactory) throws E {
        Collection<String> readAndTrackExceptions;
        Serializable classpathDigest;
        BuilderInputs inputs;
        Path inprogressFile;
        ExpressionEvaluator evaluator = new ExpressionEvaluator(Arrays.asList(s -> this.properties.get(s), this.propertyResolver));
        Path path = inprogressFile = this.stateFile != null ? this.stateFile.getParent().resolve(this.stateFile.getFileName() + "-undo") : null;
        if (inprogressFile != null && Files.exists(inprogressFile, new LinkOption[0])) {
            try {
                this.deleteOutputs(BuilderExecutionState.readInprogressOutputPaths(inprogressFile), efactory);
                Files.deleteIfExists(this.stateFile);
                Files.delete(inprogressFile);
            }
            catch (IOException e) {
                throw efactory.exception("Unrecoverable incremental build error while attempting to recover from prior builder execution failure", e);
            }
        }
        BuilderExecutionState oldExecutionState = BuilderExecutionState.load(this.stateFile);
        BuilderWorkspace builderWorkspace = new BuilderWorkspace(this.workspace, this.projectModelProvider.getBasedir(), oldExecutionState);
        MessageCollector messages = new MessageCollector(this.log);
        try {
            inputs = BuilderInputsBuilder.build(this.goal, this.projectModelProvider, this.dependencyResolver, evaluator, this.builderType, this.configuration, this.forcedParameters, builderWorkspace);
        }
        catch (IOException e) {
            throw efactory.exception("Could not compute builder inputs", e);
        }
        if (this.workspace.getMode().equals((Object)Workspace.Mode.SUPPRESSED)) {
            return this.skippedBuilderExecution(efactory, oldExecutionState, inputs, messages);
        }
        try {
            classpathDigest = this.classpathDigester.digest(this.classpath);
        }
        catch (IOException e) {
            throw efactory.exception("Could not compute classpath digest", e);
        }
        try {
            readAndTrackExceptions = this.getReadAndTrackExceptions();
        }
        catch (ExpressionEvaluationException e) {
            throw efactory.exception("Unable to evaluate Read and Track exceptions", e);
        }
        BuilderInputs.Digest inputsDigest = inputs.getDigest();
        if (!this.workspace.getMode().equals((Object)Workspace.Mode.ESCALATED) && inputsDigest.equals(oldExecutionState.inputsDigest) && this.getExceptionsDigest(readAndTrackExceptions).equals(oldExecutionState.exceptionsDigest) && this.propertiesDigest(oldExecutionState.properties.keySet()).equals(oldExecutionState.properties) && classpathDigest.equals(oldExecutionState.classpathDigest)) {
            return this.skippedBuilderExecution(efactory, oldExecutionState, null, messages);
        }
        this.deleteOutputs(oldExecutionState.outputPaths, efactory);
        inputs.getResourceRoots().forEach(this.resourceConsumer);
        inputs.getCompileSourceRoots().forEach(this::addCompileSourceRootToProject);
        try {
            for (Path file : inputs.getOutputDirectories()) {
                Files.createDirectories(file, new FileAttribute[0]);
                this.workspace.processOutput(file.toFile());
            }
            for (Path file : inputs.getOutputFiles()) {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                this.workspace.processOutput(file.getParent().toFile());
            }
        }
        catch (IOException e) {
            throw efactory.exception("Unable to create Output Directories", e);
        }
        BuilderContext.Builder contextBuilder = BuilderContext.builder(this.log, this.goal, this.sessionBasedir(), messages, builderWorkspace);
        if (this.sessionClasspathMatcher != null) {
            contextBuilder.addInputMatcher(this.sessionClasspathMatcher);
        }
        this.classpath.forEach(f -> {
            if (Files.isDirectory(f, new LinkOption[0])) {
                contextBuilder.addInputDirectory((Path)f);
            } else {
                contextBuilder.addInputFile((Path)f);
            }
        });
        if (inputs.isNonDeterministic()) {
            contextBuilder.addReadExceptions(this.enforcerConfig.getReadExceptions(this.builderId));
            contextBuilder.addReadAndTrackExceptions(readAndTrackExceptions);
            contextBuilder.addWriteExceptions(this.enforcerConfig.getWriteExceptions(this.builderId));
            contextBuilder.addExecExceptions(this.enforcerConfig.getExecExceptions(this.builderId));
            contextBuilder.setNetworkAccessAllowed(this.enforcerConfig.allowNetworkAccess(this.builderId));
        } else {
            if (this.enforcerConfig.hasEntriesFor(this.builderId)) {
                throw efactory.exception(String.format("Found whitelist entries in.mvn/builder-whitelist.config for builder not annotated with @NonDeterministic: %s", this.builderId), null);
            }
            if (this.enforcerConfig.hasWildcardEntries()) {
                contextBuilder.addReadExceptions(this.enforcerConfig.getReadExceptions("*"));
                contextBuilder.addWriteExceptions(this.enforcerConfig.getWriteExceptions("*"));
                contextBuilder.addExecExceptions(this.enforcerConfig.getExecExceptions("*"));
            }
        }
        contextBuilder.addInputFiles(inputs.getInputFiles());
        inputs.getOutputDirectories().forEach(d -> {
            BuilderContext.Builder builder2 = contextBuilder.addOutputDirectory((Path)d);
        });
        inputs.getOutputFiles().forEach(f -> {
            BuilderContext.Builder builder2 = contextBuilder.addOutputFile((Path)f);
        });
        String tempDir = System.getProperty("java.io.tmpdir");
        if (tempDir != null && !tempDir.isEmpty()) {
            contextBuilder.addTemporaryDirectory(Paths.get(tempDir, new String[0]));
            try {
                contextBuilder.addTemporaryDirectory(Paths.get(tempDir, new String[0]).toRealPath(new LinkOption[0]));
            }
            catch (IOException iOException) {}
        }
        BuilderExecutionState.InprogressStateWriter inprogressWriter = BuilderExecutionState.NOOP_INPROGRESSWRITER;
        if (inprogressFile != null) {
            try {
                inprogressWriter = BuilderExecutionState.newInprogressWriter(inprogressFile);
            }
            catch (IOException e) {
                throw efactory.exception("Could not persist incremental build state", e);
            }
        }
        contextBuilder.setInprogressWriter(inprogressWriter);
        BuilderContext builderContext = contextBuilder.build();
        try {
            builderContext.enter();
            try {
                Object builderInstance = inputs.newBuilder();
                Method builderMethod = BuilderRunner.getBuilderMethodForGoal(this.builderType, this.goal, efactory);
                builderMethod.invoke(builderInstance, new Object[0]);
                for (String file : builderContext.getTemporaryFiles()) {
                    Path filePath = PathNormalizer.toPath((String)file);
                    if (Files.isDirectory(filePath, new LinkOption[0])) {
                        FileUtils.deleteDirectory((String)file);
                        continue;
                    }
                    Files.deleteIfExists(filePath);
                }
            }
            catch (IOException | IllegalArgumentException | ReflectiveOperationException e) {
                if (e.getCause() instanceof IncrementalBuildException) {
                    throw efactory.exception("Could not persist incremental build state", e.getCause().getCause());
                }
                Throwable executionFailure = BuilderRunner.getRootCause(e);
                if (executionFailure instanceof Error) {
                    throw (Error)executionFailure;
                }
                messages.error(this.defaultFile, this.defaultLine, this.defaultColumn, executionFailure.getMessage(), executionFailure);
            }
        }
        finally {
            builderContext.leave();
            try {
                inprogressWriter.close();
            }
            catch (IOException e) {
                throw efactory.exception("Could not persist incremental build state", e);
            }
        }
        Set<EnforcerViolation> violations = builderContext.getViolations();
        if (!violations.isEmpty()) {
            throw new SecurityException(BuilderRunner.getFormattedViolationsMessage(violations, builderContext));
        }
        List<Message> collectedMessages = messages.getCollectedMessages();
        if (this.stateFile != null) {
            try {
                BuilderExecutionState.store(this.stateFile, inputsDigest, this.propertiesDigest(builderContext.getReadProperties()), classpathDigest, this.getWrittenFilesForDeletion(builderContext), inputs.getCompileSourceRoots(), inputs.getResourceRoots(), collectedMessages, this.getExceptionsDigest(readAndTrackExceptions));
                Files.delete(inprogressFile);
            }
            catch (IOException e) {
                throw efactory.exception("Could not persist incremental build state", e);
            }
        }
        if (this.messageSink != null) {
            this.clearStaleMessages(oldExecutionState);
            collectedMessages.forEach(m -> this.messageSink.message((Object)new File(m.file), m.line, m.column, m.message, BuilderRunner.toMessageSinkSeverity(m.severity), m.cause));
        } else {
            messages.throwExceptionIfThereWereErrorMessages(efactory);
        }
        return builderContext;
    }

    private <E extends Exception> BuilderContext skippedBuilderExecution(ExceptionFactory<E> efactory, BuilderExecutionState oldExecutionState, BuilderInputs inputs, MessageCollector messages) throws E {
        if (inputs != null) {
            inputs.resourceRoots.forEach(this.resourceConsumer);
            inputs.compileSourceRoots.forEach(this::addCompileSourceRootToProject);
        } else {
            oldExecutionState.resourceRoots.forEach(this.resourceConsumer);
            oldExecutionState.compileSourceRoots.forEach(this::addCompileSourceRootToProject);
        }
        messages.replayMessages(efactory, oldExecutionState.messages);
        return null;
    }

    private void clearStaleMessages(BuilderExecutionState oldExecutionState) {
        BuilderInputs.Digest oldDigest = oldExecutionState.inputsDigest;
        Collection<String> oldOutputs = oldExecutionState.outputPaths;
        if (oldDigest != null) {
            oldDigest.files().forEach(f -> this.messageSink.clearMessages((Object)f.toFile()));
        }
        if (oldOutputs != null) {
            oldOutputs.forEach(o -> this.messageSink.clearMessages((Object)new File((String)o)));
        }
        this.messageSink.clearMessages((Object)new File(this.projectBasedir.toFile(), "pom.xml"));
    }

    private static MessageSink.Severity toMessageSinkSeverity(Message.MessageSeverity severity) {
        switch (severity) {
            case ERROR: {
                return MessageSink.Severity.ERROR;
            }
            case WARNING: {
                return MessageSink.Severity.WARNING;
            }
        }
        return MessageSink.Severity.INFO;
    }

    private <E extends Exception> void deleteOutputs(Collection<String> outputPaths, ExceptionFactory<E> efactory) throws E {
        ArrayList<Path> directories = new ArrayList<Path>();
        for (String oldOutput : outputPaths) {
            try {
                Path oldOutputPath = PathNormalizer.toPath((String)oldOutput);
                if (!Files.isDirectory(oldOutputPath, new LinkOption[0])) {
                    this.workspace.deleteFile(new File(oldOutput));
                    continue;
                }
                directories.add(oldOutputPath);
            }
            catch (IOException e) {
                throw efactory.exception("Could not delete builder output", e);
            }
        }
        directories.sort((s1, s2) -> {
            if (s1.getNameCount() != s2.getNameCount()) {
                return s2.getNameCount() - s1.getNameCount();
            }
            return s2.compareTo((Path)s1);
        });
        for (Path oldDirectory : directories) {
            try {
                if (!BuilderRunner.isEmpty(oldDirectory)) continue;
                this.workspace.deleteFile(oldDirectory.toFile());
            }
            catch (IOException e) {
                throw efactory.exception("Could not delete builder output", e);
            }
        }
    }

    private static boolean isEmpty(Path dir) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(dir);){
            boolean bl = !ds.iterator().hasNext();
            return bl;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Collection<String> getWrittenFilesForDeletion(BuilderContext builderContext) {
        Collection<String> writtenFiles = builderContext.getWrittenFiles();
        return writtenFiles.stream().filter(f -> !builderContext.wasWhitelistedException((String)f)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Collection<String> getReadAndTrackExceptions() throws ExpressionEvaluationException {
        ExpressionEvaluator evaluator = new ExpressionEvaluator(Arrays.asList(this.propertyResolver));
        Collection exceptions = this.enforcerConfig.getReadAndTrackExceptions(this.builderId);
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        String basedir = this.projectBasedir.normalize().toString();
        for (String exception : exceptions) {
            String evaluated = evaluator.evaluate(exception);
            if (!evaluated.startsWith("/")) {
                evaluated = String.valueOf(basedir) + "/" + evaluated;
            }
            results.add(PathNormalizer.normalize0((String)evaluated));
        }
        return results;
    }

    private Path sessionBasedir() {
        return this.sessionBasedir == null ? this.projectBasedir : this.sessionBasedir;
    }

    private Map<String, FileDigest> getExceptionsDigest(Collection<String> paths) {
        LinkedHashMap<String, FileDigest> fileDigests = new LinkedHashMap<String, FileDigest>();
        if (paths.isEmpty()) {
            return fileDigests;
        }
        paths.forEach(path -> {
            FileDigest fileDigest = fileDigests.put(path.toString(), FileDigest.digest((Path)PathNormalizer.toPath((String)path)));
        });
        return fileDigests;
    }

    private void addCompileSourceRootToProject(CompileSourceRoot csr) {
        ResourceType type = csr.getType();
        if (type.equals((Object)ResourceType.MAIN) && this.compileSourceRoots != null && !this.compileSourceRoots.contains(csr.getPath())) {
            this.compileSourceRoots.add(csr.getPath());
        } else if (type.equals((Object)ResourceType.TEST) && this.testCompileSourceRoots != null && !this.testCompileSourceRoots.contains(csr.getPath())) {
            this.testCompileSourceRoots.add(csr.getPath());
        }
    }

    private Map<String, Object> propertiesDigest(Collection<String> names) {
        TreeMap<String, Object> digest = new TreeMap<String, Object>();
        names.forEach(name -> {
            BytesHash bytesHash = digest.put((String)name, SHA1Digester.digest((String)System.getProperty(name)));
        });
        return digest;
    }

    static Throwable getRootCause(Throwable throwable) {
        Throwable cause;
        while ((cause = throwable.getCause()) != null) {
            throwable = cause;
        }
        return throwable;
    }

    static <E extends Exception> Method getBuilderMethodForGoal(Class<?> type, String goal, ExceptionFactory<E> efactory) throws E {
        try {
            Method method = BuilderRunner.streamMethods(type).filter(m -> BuilderRunner.isbuilderAnnotationPresentWithGoal(m, goal)).findFirst().get();
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method;
        }
        catch (NoSuchElementException e) {
            throw efactory.exception(String.format("Could not find method with @Builder(name=%s) annotation", goal), e);
        }
    }

    static Stream<Method> streamMethods(Class<?> klass) {
        return klass == Object.class ? Stream.of(new Method[0]) : Stream.concat(Arrays.asList(klass.getDeclaredMethods()).stream(), BuilderRunner.streamMethods(klass.getSuperclass()));
    }

    static boolean isbuilderAnnotationPresentWithGoal(Method m, String goal) {
        return m.isAnnotationPresent(Builder.class) && m.getAnnotation(Builder.class).name().equals(goal);
    }

    private static String getFormattedViolationsMessage(Set<EnforcerViolation> violations, BuilderContext context) {
        StringBuilder msg = new StringBuilder();
        msg.append(String.format("Access to an undeclared resource detected in builder: %s", context.toString()));
        msg.append("\nViolated Rules Are:");
        for (EnforcerViolation violation : violations) {
            msg.append("\n   " + violation.getFormattedViolation());
        }
        msg.append("\n");
        String butc_chatter = "https://gus.my.salesforce.com/_ui/core/chatter/groups/GroupProfilePage?g=0F9B000000000lg";
        msg.append(String.format("\nSee %s for more information", butc_chatter));
        return msg.toString();
    }

    @FunctionalInterface
    public static interface ExceptionFactory<E extends Exception> {
        public E exception(String var1, Throwable var2);
    }
}

