/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.internal.BuilderExecutionState;
import io.takari.builder.internal.workspace.FilesystemWorkspace;
import io.takari.incrementalbuild.workspace.Workspace;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BuilderWorkspace {
    private final Workspace workspace;
    private final FilesystemWorkspace filesystem = new FilesystemWorkspace();
    private final Path projectBasedir;
    private final BuilderExecutionState oldExecutionState;

    public BuilderWorkspace(Workspace workspace, Path basedir, BuilderExecutionState oldExecutionState) {
        this.projectBasedir = basedir.normalize();
        this.oldExecutionState = oldExecutionState;
        this.workspace = workspace.getMode() == Workspace.Mode.DELTA && oldExecutionState.isEscalated() ? workspace.escalate() : workspace;
    }

    public Stream<Path> walk(Path basedir) throws IOException {
        switch (this.getMode(basedir)) {
            case DELTA: 
            case SUPPRESSED: {
                Set<Path> changed = this.doWorkspaceWalk(basedir);
                Set<Path> unchanged = this.getUnchanged(basedir, changed);
                changed.addAll(unchanged);
                return changed.stream();
            }
            case NORMAL: 
            case ESCALATED: {
                return this.doWorkspaceWalk(basedir).stream();
            }
        }
        return Stream.of(new Path[0]);
    }

    public Workspace.Mode getMode(Path basedir) {
        return this.getWorkspace(basedir).getMode();
    }

    public boolean isRegularFile(Path path) {
        return this.getWorkspace(path).isRegularFile(path.toFile());
    }

    public boolean exists(Path path) {
        return this.getWorkspace(path).isRegularFile(path.toFile()) || this.getWorkspace(path).isDirectory(path.toFile());
    }

    public boolean isDirectory(Path path) {
        return this.getWorkspace(path).isDirectory(path.toFile());
    }

    public void processOutput(Path path) {
        this.getWorkspace(path).processOutput(path.toFile());
    }

    private Workspace getWorkspace(Path path) {
        if (path.normalize().startsWith(this.projectBasedir)) {
            return this.workspace;
        }
        return this.filesystem;
    }

    private Set<Path> doWorkspaceWalk(final Path basedir) throws IOException {
        final LinkedHashSet<Path> files = new LinkedHashSet<Path>();
        this.getWorkspace(basedir).walk(basedir.toFile(), new Workspace.FileVisitor(){

            public void visit(File file, long lastModified, long length, Workspace.ResourceStatus status) {
                if (!BuilderWorkspace.this.getWorkspace(basedir).getResourceStatus(file, lastModified, length).equals((Object)Workspace.ResourceStatus.REMOVED)) {
                    files.add(file.toPath());
                }
            }
        });
        return files;
    }

    private Set<Path> getUnchanged(Path basedir, Set<Path> changed) {
        if (this.oldExecutionState == null) {
            return Collections.emptySet();
        }
        return this.oldExecutionState.inputsDigest.files().stream().filter(p -> changed == null || !changed.contains(p)).filter(p -> this.getWorkspace((Path)p).isRegularFile(p.toFile()) || this.getWorkspace((Path)p).isDirectory(p.toFile())).filter(p -> p.startsWith(basedir)).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

