/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.cache;

import io.takari.builder.IArtifactMetadata;
import io.takari.builder.ResolutionScope;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class ScopedProjectDependencyCache {
    private final Map<Key, Map<IArtifactMetadata, Path>> cache = new ConcurrentHashMap<Key, Map<IArtifactMetadata, Path>>();

    public static Key key(String groupId, String artifactId, String version, ResolutionScope scope, boolean transitive) {
        return new Key(groupId, artifactId, version, scope, transitive);
    }

    public Map<IArtifactMetadata, Path> getDependencies(Key key, Supplier<Map<IArtifactMetadata, Path>> supplier) {
        Map<IArtifactMetadata, Path> dependencies = this.cache.get(key);
        if (dependencies == null) {
            dependencies = Collections.unmodifiableMap(new LinkedHashMap<IArtifactMetadata, Path>(supplier.get()));
            if (dependencies == null) {
                dependencies = Collections.emptyMap();
            }
            this.cache.put(key, dependencies);
        }
        return dependencies;
    }

    public static class Key {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final ResolutionScope scope;
        private final boolean transitive;

        public Key(String groupId, String artifactId, String version, ResolutionScope scope, boolean transitive) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.scope = scope;
            this.transitive = transitive;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
            result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
            result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
            result = 31 * result + (this.transitive ? 1231 : 1237);
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
                return false;
            }
            if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
                return false;
            }
            if (this.scope != other.scope) {
                return false;
            }
            if (this.transitive != other.transitive) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }
    }
}

