/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.maven;

import io.takari.builder.ResourceType;
import io.takari.builder.enforcer.internal.EnforcerConfig;
import io.takari.builder.enforcer.modularity.internal.WorkspaceProjectsProvider;
import io.takari.builder.internal.BuilderRunner;
import io.takari.builder.internal.ClasspathMatcher;
import io.takari.builder.internal.ResourceRoot;
import io.takari.builder.internal.maven.MavenClasspathDigester;
import io.takari.builder.internal.maven.MavenProjectPropertyResolver;
import io.takari.builder.internal.maven.Takari_MavenIncrementalConventions;
import io.takari.builder.internal.resolver.ArtifactResolverProvider;
import io.takari.incrementalbuild.workspace.MessageSink;
import io.takari.incrementalbuild.workspace.Workspace;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIncrementalMojo
extends AbstractMojo {
    private static final String BUILDER_ARTIFACTID = "takari-builder";
    private static final String BUILDER_GROUPID = "io.takari.builder";
    private static final String ENFORCER_CONFIG_FILE_LOCATION = ".mvn/builder-enforcer.config";
    protected final Class<?> builderType;
    protected final Logger log;
    @Inject
    private ClasspathMatcher classpathMatcher;
    @Inject
    private Workspace workspace;
    @Inject
    @WorkspaceProjectsProvider.Nullable
    private MessageSink messageSink;
    @Inject
    @Named(value="maven")
    private ArtifactResolverProvider<MavenProject> resolverProvider;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject __internal_project;
    @Parameter(defaultValue="${mojo}", readonly=true)
    private MojoExecution __internal_execution;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession __internal_session;

    protected AbstractIncrementalMojo(Class<?> builderType) {
        this.builderType = builderType;
        this.log = LoggerFactory.getLogger(builderType);
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        List classpath = this.__internal_execution.getMojoDescriptor().getPluginDescriptor().getArtifacts();
        this.assertBuildExtensionRealm(classpath);
        Consumer<ResourceRoot> resourceConsumer = resourceRoot -> {
            Resource resource = new Resource();
            resource.setDirectory(resourceRoot.getLocation());
            resource.setIncludes(resourceRoot.getIncludes());
            resource.setExcludes(resourceRoot.getExcludes());
            ResourceType type = resourceRoot.getResourceType();
            if (type.equals((Object)ResourceType.MAIN)) {
                this.__internal_project.getResources().add(resource);
            } else if (type.equals((Object)ResourceType.TEST)) {
                this.__internal_project.getTestResources().add(resource);
            }
        };
        EnforcerConfig enforcerConfig = this.getEnforcerConfig();
        MavenClasspathDigester classpathDigester = new MavenClasspathDigester(this.__internal_session);
        BuilderRunner.create(this.log, this.builderType, this.__internal_execution.getGoal()).setBuilderId(this.getBuilderId()).setSessionBasedir(this.getSessionBasedir()).setProjectBasedir(this.__internal_project.getBasedir().toPath()).setProjectProperties(new MavenProjectPropertyResolver(this.__internal_project)).setSessionProperties(this.__internal_session.getSystemProperties(), this.__internal_session.getUserProperties()).setSessionClasspathMatcher(this.classpathMatcher.getMatcher()).setStateFile(Takari_MavenIncrementalConventions.getExecutionStateLocation(this.__internal_project, this.__internal_execution)).setClasspath(classpath.stream().map(a -> a.getFile().toPath()).collect(Collectors.toList()), classpathDigester).setDependencyResolver(this.resolverProvider.getResolver(this.__internal_project)).setProjectResourcesConsumer(resourceConsumer).setProjectCompileSourceRoots(this.__internal_project.getCompileSourceRoots()).setProjectTestCompileSourceRoots(this.__internal_project.getTestCompileSourceRoots()).setConfiguration(this.__internal_execution.getConfiguration()).setDefaultMessageLocation(this.__internal_project.getFile().toPath(), -1, -1).setBuilderEnforcerConfig(enforcerConfig).setWorkspace(this.workspace).setMessageSink(this.messageSink).execute((m, c) -> c != null ? new MojoExecutionException(m, c) : new MojoExecutionException(m));
    }

    private Path getSessionBasedir() {
        if (this.__internal_session.getRequest().getMultiModuleProjectDirectory() == null) {
            return null;
        }
        return this.__internal_session.getRequest().getMultiModuleProjectDirectory().toPath();
    }

    private EnforcerConfig getEnforcerConfig() {
        return EnforcerConfig.fromFile(this.getSessionBasedir() == null ? null : this.getSessionBasedir().resolve(ENFORCER_CONFIG_FILE_LOCATION));
    }

    private String getBuilderId() {
        PluginDescriptor descriptor = this.__internal_execution.getMojoDescriptor().getPluginDescriptor();
        return String.format("%s:%s:%s", descriptor.getGroupId(), descriptor.getArtifactId(), this.__internal_execution.getGoal());
    }

    private void assertBuildExtensionRealm(List<Artifact> classpath) throws MojoExecutionException {
        boolean present = classpath.stream().anyMatch(a -> BUILDER_GROUPID.equals(a.getGroupId()) && BUILDER_ARTIFACTID.equals(a.getArtifactId()));
        if (present) {
            String msg = String.format("%s:%s must be configured as a build extension", BUILDER_GROUPID, BUILDER_ARTIFACTID);
            throw new MojoExecutionException(msg);
        }
    }
}

