/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.model;

import io.takari.builder.Builder;
import io.takari.builder.NonDeterministic;
import io.takari.builder.internal.model.BuilderMetadataVisitor;
import io.takari.builder.internal.model.MethodAdapter;
import io.takari.builder.internal.model.TypeAdapter;

public class BuilderMethod {
    private final MethodAdapter element;
    private final Builder annotation;
    private final TypeAdapter declaringType;
    private final boolean nonDeterministic;

    public BuilderMethod(MethodAdapter element, TypeAdapter declaringType) {
        this.element = element;
        this.annotation = element != null ? element.getAnnotation(Builder.class) : null;
        this.nonDeterministic = element != null && element.getAnnotation(NonDeterministic.class) != null;
        this.declaringType = declaringType;
    }

    public MethodAdapter originatingElement() {
        return this.element;
    }

    public Builder annotation() {
        return this.annotation;
    }

    public boolean isNonDeterministic() {
        return this.nonDeterministic;
    }

    public TypeAdapter declaringType() {
        return this.declaringType;
    }

    public void accept(BuilderMetadataVisitor visitor) {
        visitor.visitBuilder(this);
    }
}

