/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.testing;

import io.takari.builder.enforcer.ComposableSecurityManagerPolicy;
import io.takari.builder.enforcer.Policy;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class BuilderRuntime
implements TestRule {
    private static final ThreadLocal<Boolean> privileged = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static final Policy POLICY = new Policy(){

        public void checkWrite(String file) {
            this.checkSecuredTestExecutionContext();
        }

        public void checkSocketPermission() {
            this.checkSecuredTestExecutionContext();
        }

        public void checkRead(String file) {
            this.checkSecuredTestExecutionContext();
        }

        public void checkPropertyPermission(String action, String name) {
            this.checkSecuredTestExecutionContext();
        }

        public void checkExec(String cmd) {
            this.checkSecuredTestExecutionContext();
        }

        private void checkSecuredTestExecutionContext() {
            if (privileged.get() == Boolean.FALSE) {
                throw new SecurityException("Cannot access system resources without builder context at this thread.");
            }
        }
    };

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                BuilderRuntime.enterTestScope();
                try {
                    base.evaluate();
                }
                finally {
                    BuilderRuntime.leaveTestScope();
                }
            }
        };
    }

    public static void enterTestScope() {
        privileged.set(Boolean.TRUE);
        ComposableSecurityManagerPolicy.setSystemSecurityManager();
        ComposableSecurityManagerPolicy.setDefaultPolicy((Policy)POLICY);
    }

    public static void leaveTestScope() {
        privileged.set(Boolean.FALSE);
        ComposableSecurityManagerPolicy.setDefaultPolicy(null);
        ComposableSecurityManagerPolicy.removeSystemSecurityManager();
    }
}

