/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import org.apache.commons.compress.archivers.zip.PKWareExtraHeader;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.apache.commons.compress.archivers.zip.ZipUtil;

public class X0017_StrongEncryptionHeader
extends PKWareExtraHeader
implements ZipExtraField {
    private static final ZipShort HEADER_ID = new ZipShort(23);
    private static final long serialVersionUID = 1L;
    private byte[] localData;
    private int format;
    private PKWareExtraHeader.EncryptionAlgorithm algId;
    private int bitlen;
    private int flags;
    private long rcount;
    private PKWareExtraHeader.HashAlgorithm hashAlg;
    private int hashSize;
    private byte[] ivData;
    private byte[] erdData;
    private byte[] recipientKeyHash;
    private byte[] keyBlob;
    private byte[] vData;
    private byte[] vCRC32;
    private byte[] centralData;

    @Override
    public ZipShort getHeaderId() {
        return HEADER_ID;
    }

    public long getRecordCount() {
        return this.rcount;
    }

    public PKWareExtraHeader.HashAlgorithm getHashAlgorithm() {
        return this.hashAlg;
    }

    public PKWareExtraHeader.EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.algId;
    }

    public void setLocalFileDataData(byte[] data) {
        this.localData = ZipUtil.copy(data);
    }

    @Override
    public ZipShort getLocalFileDataLength() {
        return new ZipShort(this.localData != null ? this.localData.length : 0);
    }

    @Override
    public byte[] getLocalFileDataData() {
        return ZipUtil.copy(this.localData);
    }

    public void setCentralDirectoryData(byte[] data) {
        this.centralData = ZipUtil.copy(data);
    }

    @Override
    public ZipShort getCentralDirectoryLength() {
        if (this.centralData != null) {
            return new ZipShort(this.centralData.length);
        }
        return this.getLocalFileDataLength();
    }

    @Override
    public byte[] getCentralDirectoryData() {
        if (this.centralData != null) {
            return ZipUtil.copy(this.centralData);
        }
        return this.getLocalFileDataData();
    }

    public void parseCentralDirectoryFormat(byte[] data, int offset, int length) {
        this.format = ZipShort.getValue(data, offset);
        this.algId = PKWareExtraHeader.EncryptionAlgorithm.getAlgorithmByCode(ZipShort.getValue(data, offset + 2));
        this.bitlen = ZipShort.getValue(data, offset + 4);
        this.flags = ZipShort.getValue(data, offset + 6);
        this.rcount = ZipLong.getValue(data, offset + 8);
        if (this.rcount > 0L) {
            this.hashAlg = PKWareExtraHeader.HashAlgorithm.getAlgorithmByCode(ZipShort.getValue(data, offset + 12));
            this.hashSize = ZipShort.getValue(data, offset + 14);
            int i = 0;
            while ((long)i < this.rcount) {
                for (int j = 0; j < this.hashSize; ++j) {
                }
                ++i;
            }
        }
    }

    public void parseFileFormat(byte[] data, int offset, int length) {
        int ivSize = ZipShort.getValue(data, offset);
        this.ivData = new byte[ivSize];
        System.arraycopy(data, offset + 4, this.ivData, 0, ivSize);
        long size = ZipLong.getValue(data, offset + ivSize + 2);
        this.format = ZipShort.getValue(data, offset + ivSize + 6);
        this.algId = PKWareExtraHeader.EncryptionAlgorithm.getAlgorithmByCode(ZipShort.getValue(data, offset + ivSize + 8));
        this.bitlen = ZipShort.getValue(data, offset + ivSize + 10);
        this.flags = ZipShort.getValue(data, offset + ivSize + 12);
        int erdSize = ZipShort.getValue(data, offset + ivSize + 14);
        this.erdData = new byte[erdSize];
        System.arraycopy(data, offset + ivSize + 16, this.erdData, 0, erdSize);
        this.rcount = ZipLong.getValue(data, offset + ivSize + 16 + erdSize);
        System.out.println("rcount: " + this.rcount);
        if (this.rcount == 0L) {
            int vSize = ZipShort.getValue(data, offset + ivSize + 20 + erdSize);
            this.vData = new byte[vSize - 4];
            this.vCRC32 = new byte[4];
            System.arraycopy(data, offset + ivSize + 22 + erdSize, this.vData, 0, vSize - 4);
            System.arraycopy(data, offset + ivSize + 22 + erdSize + vSize - 4, this.vCRC32, 0, 4);
        } else {
            this.hashAlg = PKWareExtraHeader.HashAlgorithm.getAlgorithmByCode(ZipShort.getValue(data, offset + ivSize + 20 + erdSize));
            this.hashSize = ZipShort.getValue(data, offset + ivSize + 22 + erdSize);
            int resize = ZipShort.getValue(data, offset + ivSize + 24 + erdSize);
            this.recipientKeyHash = new byte[this.hashSize];
            this.keyBlob = new byte[resize - this.hashSize];
            System.arraycopy(data, offset + ivSize + 24 + erdSize, this.recipientKeyHash, 0, this.hashSize);
            System.arraycopy(data, offset + ivSize + 24 + erdSize + this.hashSize, this.keyBlob, 0, resize - this.hashSize);
            int vSize = ZipShort.getValue(data, offset + ivSize + 26 + erdSize + resize);
            this.vData = new byte[vSize - 4];
            this.vCRC32 = new byte[4];
            System.arraycopy(data, offset + ivSize + 22 + erdSize + resize, this.vData, 0, vSize - 4);
            System.arraycopy(data, offset + ivSize + 22 + erdSize + resize + vSize - 4, this.vCRC32, 0, 4);
        }
    }

    @Override
    public void parseFromLocalFileData(byte[] data, int offset, int length) {
        byte[] tmp = new byte[length];
        System.arraycopy(data, offset, tmp, 0, length);
        this.parseFileFormat(data, offset, length);
    }

    @Override
    public void parseFromCentralDirectoryData(byte[] data, int offset, int length) {
        byte[] tmp = new byte[length];
        System.arraycopy(data, offset, tmp, 0, length);
        this.setCentralDirectoryData(tmp);
        this.parseCentralDirectoryFormat(data, offset, length);
    }
}

