/*
 * Decompiled with CFR 0.152.
 */
package io.takari.graph.dot;

import io.takari.graph.dot.Shape;

public class ArrowEnd {
    static final int NORTH = 0;
    static final int NORTH_EAST = 1;
    static final int EAST = 2;
    static final int SOUTH_EAST = 3;
    static final int SOUTH = 4;
    static final int SOUTH_WEST = 5;
    static final int WEST = 6;
    static final int NORTH_WEST = 7;
    static final int CENTER = 8;
    Shape innerShape;
    Shape outerShape;
    String URL;
    String label = "";
    String target;
    String tooltip = "";
    boolean clip = true;
    int port = 8;
    private final String[] attributeNames = new String[]{"n", "ne", "e", "se", "s", "sw", "w", "nw", ""};

    public ArrowEnd(Shape out, Shape in) {
        this.outerShape = out;
        this.innerShape = in;
    }

    public String toString() {
        String s = "";
        if (this.port != 8) {
            s = ":" + this.attributeNames[this.port];
        }
        return s;
    }

    public String printArrowEndOptions(String attribute) {
        String o = "";
        if (!this.clip) {
            o = o + this.printOption(attribute + "clip", this.clip);
        }
        if (!this.label.equals("")) {
            o = o + this.printOption(attribute + "label", this.label);
        }
        if (this.port != 8) {
            o = o + this.printNamedOption(attribute + "port", this.port);
        }
        o = o + this.printOption("arrow" + attribute, this.outerShape, this.innerShape);
        if (this.URL != null) {
            o = o + this.printOption(attribute + "URL", this.URL);
        }
        return o;
    }

    private String printOption(String attribute, Shape out, Shape in) {
        String value;
        if (out.shape == 0 && in.shape == 0) {
            if (attribute.equals("arrowtail")) {
                return "";
            }
            value = Shape.attributeNames[0];
        } else {
            value = (out.shape == 0 ? "" : out.toString()) + (in.shape == 0 ? "" : in.toString());
        }
        if (value.equals("normal") && attribute.equals("arrowhead")) {
            return "";
        }
        return attribute + "=\"" + value + "\" ";
    }

    private String printOption(String attribute, String value) {
        return attribute + "=\"" + value + "\" ";
    }

    private String printOption(String attribute, boolean value) {
        return attribute + "=\"" + value + "\" ";
    }

    private String printNamedOption(String attribute, int i) {
        return attribute + "=\"" + this.attributeNames[i] + "\" ";
    }
}

