/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.aggregator.internal;

import io.takari.incrementalbuild.BuildContext;
import io.takari.incrementalbuild.aggregator.AggregatorBuildContext;
import io.takari.incrementalbuild.spi.DefaultBuildContext;
import io.takari.incrementalbuild.spi.DefaultOutput;
import io.takari.incrementalbuild.spi.DefaultOutputMetadata;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class DefaultAggregatorBuildContext
implements AggregatorBuildContext {
    private final DefaultBuildContext<?> context;

    @Inject
    public DefaultAggregatorBuildContext(DefaultBuildContext<?> context) {
        this.context = context;
    }

    @Override
    public DefaultAggregateOutput registerOutput(File outputFile) {
        DefaultOutputMetadata output = this.context.registerOutput(outputFile);
        if (output instanceof BuildContext.Output) {
            throw new IllegalStateException();
        }
        return new DefaultAggregateOutput(output);
    }

    public class DefaultAggregateInput
    implements AggregatorBuildContext.AggregateInput {
        private final File basedir;
        private final BuildContext.InputMetadata<File> input;

        public DefaultAggregateInput(File basedir, BuildContext.InputMetadata<File> input) {
            this.basedir = basedir;
            this.input = input;
        }

        @Override
        public File getResource() {
            return (File)this.input.getResource();
        }

        @Override
        public File getBasedir() {
            return this.basedir;
        }

        @Override
        public BuildContext.ResourceStatus getStatus() {
            return this.input.getStatus();
        }

        @Override
        public Iterable<? extends BuildContext.OutputMetadata<File>> getAssociatedOutputs() {
            return this.input.getAssociatedOutputs();
        }

        @Override
        public BuildContext.Input<File> process() {
            return this.input.process();
        }

        @Override
        public <V extends Serializable> V getAttribute(String key, Class<V> clazz) {
            return this.input.getAttribute(key, clazz);
        }
    }

    public class DefaultAggregateOutput
    implements AggregatorBuildContext.AggregateOutput {
        private final BuildContext.OutputMetadata<File> outputMetadata;
        private Collection<AggregatorBuildContext.AggregateInput> inputs = new ArrayList<AggregatorBuildContext.AggregateInput>();
        private boolean processingRequired;

        public DefaultAggregateOutput(BuildContext.OutputMetadata<File> output) {
            this.outputMetadata = output;
            this.processingRequired = output.getStatus() != BuildContext.ResourceStatus.UNMODIFIED;
        }

        @Override
        public File getResource() {
            return (File)this.outputMetadata.getResource();
        }

        @Override
        public void addInputs(File basedir, Collection<String> includes, Collection<String> excludes, AggregatorBuildContext.InputProcessor ... processors) throws IOException {
            basedir = basedir.getCanonicalFile();
            for (BuildContext.InputMetadata inputMetadata : DefaultAggregatorBuildContext.this.context.registerInputs(basedir, includes, excludes)) {
                if (DefaultAggregatorBuildContext.this.context.getInputStatus(inputMetadata.getResource(), false) != BuildContext.ResourceStatus.UNMODIFIED) {
                    this.processingRequired = true;
                    BuildContext.Input<File> input = inputMetadata.process();
                    if (processors != null) {
                        AggregatorBuildContext.InputProcessor[] inputProcessorArray = processors;
                        int n = processors.length;
                        int n2 = 0;
                        while (n2 < n) {
                            AggregatorBuildContext.InputProcessor processor = inputProcessorArray[n2];
                            processor.process(input);
                            ++n2;
                        }
                    }
                    this.inputs.add(new DefaultAggregateInput(basedir, input));
                    continue;
                }
                this.inputs.add(new DefaultAggregateInput(basedir, inputMetadata));
            }
        }

        @Override
        public boolean createIfNecessary(AggregatorBuildContext.AggregateCreator creator) throws IOException {
            if (!this.processingRequired) {
                for (BuildContext.InputMetadata<File> input : this.outputMetadata.getAssociatedInputs(File.class)) {
                    if (input.getStatus() == BuildContext.ResourceStatus.UNMODIFIED) continue;
                    this.processingRequired = true;
                    break;
                }
            }
            File outputFile = (File)this.outputMetadata.getResource();
            if (this.processingRequired) {
                DefaultOutput output = DefaultAggregatorBuildContext.this.context.processOutput(outputFile);
                for (AggregatorBuildContext.AggregateInput aggregateInput : this.inputs) {
                    output.associateInput(((DefaultAggregateInput)aggregateInput).input);
                }
                creator.create(output, this.inputs);
            } else {
                DefaultAggregatorBuildContext.this.context.markOutputAsUptodate(outputFile);
            }
            return this.processingRequired;
        }
    }
}

