/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.maven.internal;

import io.takari.incrementalbuild.maven.internal.FilesystemWorkspace;
import io.takari.incrementalbuild.workspace.Workspace;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.apache.maven.project.MavenProject;

@Typed(value={ProjectWorkspace.class})
@MojoExecutionScoped
public class ProjectWorkspace
implements Workspace {
    private final Workspace workspace;
    private final FilesystemWorkspace filesystem;
    private final MavenProject project;
    private final Path basedir;

    @Inject
    public ProjectWorkspace(MavenProject project, Workspace workspace, FilesystemWorkspace filesystem) {
        this.project = project;
        this.basedir = project.getBasedir().toPath().normalize();
        this.workspace = workspace;
        this.filesystem = filesystem;
    }

    private Workspace getWorkspace(File file) {
        if (file.toPath().normalize().startsWith(this.basedir)) {
            return this.workspace;
        }
        return this.filesystem;
    }

    public Workspace.Mode getMode() {
        return this.workspace.getMode();
    }

    public Workspace escalate() {
        return new ProjectWorkspace(this.project, this.workspace.escalate(), this.filesystem);
    }

    public boolean isPresent(File file) {
        return this.getWorkspace(file).isPresent(file);
    }

    public void deleteFile(File file) throws IOException {
        this.getWorkspace(file).deleteFile(file);
    }

    public void processOutput(File file) {
        this.getWorkspace(file).processOutput(file);
    }

    public OutputStream newOutputStream(File file) throws IOException {
        return this.getWorkspace(file).newOutputStream(file);
    }

    public Workspace.ResourceStatus getResourceStatus(File file, long lastModified, long length) {
        return this.getWorkspace(file).getResourceStatus(file, lastModified, length);
    }

    public void walk(File basedir, Workspace.FileVisitor visitor) throws IOException {
        this.getWorkspace(basedir).walk(basedir, visitor);
    }
}

