/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.maven.testing;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import io.takari.incrementalbuild.maven.internal.MavenBuildContext;
import io.takari.incrementalbuild.maven.testing.IncrementalBuildLog;
import io.takari.incrementalbuild.maven.testing.TestBuildContext;
import io.takari.incrementalbuild.spi.DefaultBuildContext;
import io.takari.maven.testing.TestMavenRuntime;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.junit.Assert;

public class IncrementalBuildRule
extends TestMavenRuntime {
    public IncrementalBuildRule() {
        super(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(TestBuildContext.class).in(MojoExecutionScoped.class);
                this.bind(DefaultBuildContext.class).to(TestBuildContext.class).in(MojoExecutionScoped.class);
                this.bind(MavenBuildContext.class).to(TestBuildContext.class).in(MojoExecutionScoped.class);
                this.bind(IncrementalBuildLog.class).in(Singleton.class);
            }
        }});
    }

    public void executeMojo(MavenSession session, MavenProject project, MojoExecution execution) throws Exception {
        this.getBuildContextLog().clear();
        super.executeMojo(session, project, execution);
    }

    public IncrementalBuildLog getBuildContextLog() throws Exception {
        return (IncrementalBuildLog)this.lookup(IncrementalBuildLog.class);
    }

    public void assertBuildOutputs(File basedir, String ... paths) throws Exception {
        Set<File> expected = this.toFileSet(basedir, paths);
        TreeSet<File> actual = new TreeSet<File>(this.getBuildContextLog().getRegisteredOutputs());
        Assert.assertEquals((String)"(re)created outputs", (Object)IncrementalBuildRule.toString(expected), (Object)IncrementalBuildRule.toString(actual, true));
    }

    public void assertDeletedOutputs(File basedir, String ... paths) throws Exception {
        Set<File> expected = this.toFileSet(basedir, paths);
        TreeSet<File> actual = new TreeSet<File>(this.getBuildContextLog().getDeletedOutputs());
        actual.removeAll(this.getBuildContextLog().getRegisteredOutputs());
        Assert.assertEquals((String)"deleted outputs", (Object)IncrementalBuildRule.toString(expected), (Object)IncrementalBuildRule.toString(actual, false));
    }

    public void assertCarriedOverOutputs(File basedir, String ... paths) throws Exception {
        Set<File> expected = this.toFileSet(basedir, paths);
        TreeSet<File> actual = new TreeSet<File>(this.getBuildContextLog().getCarriedOverOutputs());
        Assert.assertEquals((String)"carried over outputs", (Object)IncrementalBuildRule.toString(expected), (Object)IncrementalBuildRule.toString(actual, true));
    }

    public void assertMessages(File basedir, String path, String ... messages) throws Exception {
        ArrayList<String> actual = new ArrayList<String>(this.getBuildContextLog().getMessages(new File(basedir, path)));
        List<String> expected = Arrays.asList(messages);
        Assert.assertEquals((Object)IncrementalBuildRule.toString(expected), (Object)IncrementalBuildRule.toString(actual));
    }

    private static String toString(Collection<?> objects) {
        StringBuilder sb = new StringBuilder();
        for (Object file : objects) {
            sb.append(file.toString()).append('\n');
        }
        return sb.toString();
    }

    private static String toString(Collection<File> files, boolean canRead) {
        StringBuilder sb = new StringBuilder();
        for (File file : files) {
            if (canRead != file.canRead()) {
                sb.append(file.canRead() ? "EXISTS " : "DOES NOT EXIST ");
            }
            sb.append(file.toString()).append('\n');
        }
        return sb.toString();
    }

    private Set<File> toFileSet(File basedir, String ... paths) {
        TreeSet<File> expected = new TreeSet<File>();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            expected.add(new File(basedir, path));
            ++n2;
        }
        return expected;
    }
}

