/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.spi;

import io.takari.incrementalbuild.BuildContext;
import io.takari.incrementalbuild.spi.DefaultBuildContext;
import io.takari.incrementalbuild.spi.DefaultBuildContextState;
import io.takari.incrementalbuild.spi.QualifiedName;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;

public class DefaultOutputMetadata
implements BuildContext.OutputMetadata<File> {
    final DefaultBuildContext<?> context;
    final DefaultBuildContextState state;
    final File file;

    DefaultOutputMetadata(DefaultBuildContext<?> context, DefaultBuildContextState state, File file) {
        this.context = context;
        this.state = state;
        this.file = file;
    }

    @Override
    public File getResource() {
        return this.file;
    }

    @Override
    public BuildContext.ResourceStatus getStatus() {
        return this.context.getOutputStatus(this.file);
    }

    @Override
    public <I> Iterable<? extends BuildContext.InputMetadata<I>> getAssociatedInputs(Class<I> clazz) {
        return this.context.getAssociatedInputs(this.state, this.file, clazz);
    }

    public Collection<String> getCapabilities(String qualifier) {
        Collection<QualifiedName> capabilities = this.state.outputCapabilities.get(this.file);
        if (capabilities == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (QualifiedName capability : capabilities) {
            if (!qualifier.equals(capability.getQualifier())) continue;
            result.add(capability.getLocalName());
        }
        return result;
    }

    @Override
    public <V extends Serializable> V getAttribute(String key, Class<V> clazz) {
        return this.context.getResourceAttribute(this.file, key, true, clazz);
    }
}

