/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.spi;

import io.takari.incrementalbuild.spi.IncrementalFileOutputStream;
import io.takari.incrementalbuild.workspace.Workspace;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class FilesystemWorkspace
implements Workspace {
    public Workspace.Mode getMode() {
        return Workspace.Mode.NORMAL;
    }

    public Workspace escalate() {
        return this;
    }

    public void deleteFile(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException("Could not delete file " + file);
        }
    }

    public void processOutput(File outputFile) {
    }

    public OutputStream newOutputStream(File file) throws IOException {
        return new IncrementalFileOutputStream(file);
    }

    public Workspace.ResourceStatus getResourceStatus(File file, long lastModified, long length) {
        if (!this.isPresent(file)) {
            return Workspace.ResourceStatus.REMOVED;
        }
        if (length == file.length() && lastModified == file.lastModified()) {
            return Workspace.ResourceStatus.UNMODIFIED;
        }
        return Workspace.ResourceStatus.MODIFIED;
    }

    public boolean isPresent(File file) {
        return file != null && file.isFile() && file.canRead();
    }

    public void walk(File basedir, final Workspace.FileVisitor visitor) throws IOException {
        if (!basedir.isDirectory()) {
            return;
        }
        Path basepath = basedir.toPath();
        Files.walkFileTree(basepath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                File file = path.toFile();
                long lastModified = file.lastModified();
                long length = file.length();
                visitor.visit(file, lastModified, length, Workspace.ResourceStatus.NEW);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

