/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.maven.internal;

import io.takari.incrementalbuild.maven.internal.ClasspathDigester;
import io.takari.incrementalbuild.maven.internal.Digesters;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Named
@MojoExecutionScoped
public class MojoConfigurationDigester {
    private final ClasspathDigester classpathDigester;
    private final MavenSession session;
    private final MavenProject project;
    private final MojoExecution execution;

    @Inject
    public MojoConfigurationDigester(MavenSession session, MavenProject project, MojoExecution execution) {
        this.session = session;
        this.project = project;
        this.execution = execution;
        this.classpathDigester = new ClasspathDigester(session);
    }

    public Map<String, Serializable> digest() throws IOException {
        LinkedHashMap<String, Serializable> result = new LinkedHashMap<String, Serializable>();
        List classpath = this.execution.getMojoDescriptor().getPluginDescriptor().getArtifacts();
        result.put("mojo.classpath", this.classpathDigester.digest(classpath));
        Xpp3Dom dom = this.execution.getConfiguration();
        if (dom != null) {
            ArrayList<String> errors = new ArrayList<String>();
            XmlPlexusConfiguration configuration = new XmlPlexusConfiguration(dom);
            PluginParameterExpressionEvaluator evaluator = new PluginParameterExpressionEvaluator(this.session, this.execution);
            for (PlexusConfiguration child : configuration.getChildren()) {
                String name = this.fromXML(child.getName());
                try {
                    Serializable digest;
                    Object value;
                    Field field = this.getField(this.execution.getMojoDescriptor().getImplementationClass(), name);
                    if (field == null) continue;
                    String expression = child.getValue();
                    if (expression == null) {
                        expression = this.getChildrenXml(child);
                    }
                    if (expression == null) {
                        expression = child.getAttribute("default-value");
                    }
                    if (expression == null || (value = evaluator.evaluate(expression)) == null || (digest = Digesters.digest(field, value)) == null) continue;
                    result.put("mojo.parameter." + name, digest);
                }
                catch (Digesters.UnsupportedParameterTypeException e) {
                    errors.add("parameter " + name + " has unsupported type " + e.type.getName());
                }
                catch (ExpressionEvaluationException e) {
                    errors.add("parameter " + name + " " + e.getMessage());
                }
            }
            if (!errors.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.project.toString());
                sb.append(" could not digest configuration of ").append(this.execution.toString());
                for (String error : errors) {
                    sb.append("\n   ").append(error);
                }
                throw new IllegalArgumentException(sb.toString());
            }
        }
        return result;
    }

    private String getChildrenXml(PlexusConfiguration node) {
        PlexusConfiguration[] children = node.getChildren();
        if (children == null || children.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (PlexusConfiguration child : children) {
            this.append(sb, child);
        }
        return sb.toString();
    }

    private void append(StringBuilder sb, PlexusConfiguration node) {
        sb.append('<').append(node.getName());
        for (String a : node.getAttributeNames()) {
            sb.append(' ').append(a).append("=\"").append(node.getAttribute(a)).append('\"');
        }
        if (node.getChildCount() > 0) {
            sb.append('>');
            int size = node.getChildCount();
            for (int i = 0; i < size; ++i) {
                this.append(sb, node.getChild(i));
            }
            sb.append("</").append(node.getName()).append('>');
        } else if (null != node.getValue()) {
            sb.append('>').append(node.getValue()).append("</").append(node.getName()).append('>');
        } else {
            sb.append("/>");
        }
    }

    private Field getField(Class<?> clazz, String name) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!name.equals(field.getName())) continue;
            return field;
        }
        if (clazz.getSuperclass() != null) {
            return this.getField(clazz.getSuperclass(), name);
        }
        return null;
    }

    protected String fromXML(String elementName) {
        return StringUtils.lowercaseFirstLetter((String)StringUtils.removeAndHump((String)elementName, (String)"-"));
    }
}

