/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.maven.testing;

import io.takari.incrementalbuild.workspace.MessageSink;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IncrementalBuildLog
implements MessageSink {
    private final List<File> registeredOutputs = new ArrayList<File>();
    private final List<File> deletedOutputs = new ArrayList<File>();
    private final List<File> carriedOverOutputs = new ArrayList<File>();
    private final Map<File, List<String>> inputMessages = new HashMap<File, List<String>>();
    private int errorCount;

    public void addRegisterOutput(File outputFile) {
        this.registeredOutputs.add(outputFile);
    }

    public Collection<File> getRegisteredOutputs() {
        return this.registeredOutputs;
    }

    public void addDeletedOutput(File outputFile) {
        this.deletedOutputs.add(outputFile);
    }

    public Collection<File> getDeletedOutputs() {
        return this.deletedOutputs;
    }

    public void addCarryoverOutput(File outputFile) {
        this.carriedOverOutputs.add(outputFile);
    }

    public Collection<File> getCarriedOverOutputs() {
        return this.carriedOverOutputs;
    }

    public Collection<String> getMessages(File inputFile) {
        List<String> messages = this.inputMessages.get(inputFile);
        return messages != null ? messages : Collections.emptyList();
    }

    public void clear() {
        this.registeredOutputs.clear();
        this.deletedOutputs.clear();
        this.carriedOverOutputs.clear();
        this.inputMessages.clear();
        this.errorCount = 0;
    }

    public void message(Object resource, int line, int column, String message, MessageSink.Severity severity, Throwable cause) {
        if (!(resource instanceof File)) {
            throw new IllegalArgumentException();
        }
        File file = (File)resource;
        String msg = String.format("%s %s [%d:%d] %s", severity.name(), file.getName(), line, column, message);
        List<String> messages = this.inputMessages.get(file);
        if (messages == null) {
            messages = new ArrayList<String>();
            this.inputMessages.put(file, messages);
        }
        messages.add(msg);
        if (severity == MessageSink.Severity.ERROR) {
            ++this.errorCount;
        }
    }

    public MessageSink replayMessageSink() {
        return this;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void clearMessages(Object resource) {
    }
}

