/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.spi;

import io.takari.incrementalbuild.spi.Message;
import io.takari.incrementalbuild.spi.QualifiedName;
import io.takari.incrementalbuild.spi.ResourceHolder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBuildContextState
implements Serializable {
    private static final transient Logger log = LoggerFactory.getLogger(DefaultBuildContextState.class);
    private static final long serialVersionUID = 6195150574931820441L;
    final Map<String, Serializable> configuration;
    final Map<File, ResourceHolder<File>> outputs;
    final Map<Object, ResourceHolder<?>> inputs;
    final Map<Object, ResourceHolder<?>> includedInputs;
    final Map<Object, Collection<File>> inputOutputs;
    final Map<File, Collection<Object>> outputInputs;
    final Map<Object, Collection<Object>> inputIncludedInputs;
    final Map<QualifiedName, Collection<Object>> requirementInputs;
    final Map<Object, Collection<QualifiedName>> inputRequirements;
    final Map<File, Collection<QualifiedName>> outputCapabilities;
    final Map<Object, Map<String, Serializable>> resourceAttributes;
    final Map<Object, Collection<Message>> resourceMessages;

    private DefaultBuildContextState(Map<String, Serializable> configuration, Map<Object, ResourceHolder<?>> inputs, Map<File, ResourceHolder<File>> outputs, Map<Object, ResourceHolder<?>> includedInputs, Map<Object, Collection<File>> inputOutputs, Map<File, Collection<Object>> outputInputs, Map<Object, Collection<Object>> inputIncludedInputs, Map<QualifiedName, Collection<Object>> requirementInputs, Map<Object, Collection<QualifiedName>> inputRequirements, Map<File, Collection<QualifiedName>> outputCapabilities, Map<Object, Map<String, Serializable>> resourceAttributes, Map<Object, Collection<Message>> messages) {
        this.configuration = configuration;
        this.inputs = inputs;
        this.outputs = outputs;
        this.includedInputs = includedInputs;
        this.inputOutputs = inputOutputs;
        this.outputInputs = outputInputs;
        this.inputIncludedInputs = inputIncludedInputs;
        this.requirementInputs = requirementInputs;
        this.inputRequirements = inputRequirements;
        this.outputCapabilities = outputCapabilities;
        this.resourceAttributes = resourceAttributes;
        this.resourceMessages = messages;
    }

    public static DefaultBuildContextState withConfiguration(Map<String, Serializable> configuration) {
        HashMap<String, Serializable> copy = new HashMap<String, Serializable>(configuration);
        copy.put("incremental", Boolean.TRUE);
        return new DefaultBuildContextState(Collections.unmodifiableMap(copy), new HashMap(), new HashMap<File, ResourceHolder<File>>(), new HashMap(), new HashMap<Object, Collection<File>>(), new HashMap<File, Collection<Object>>(), new HashMap<Object, Collection<Object>>(), new HashMap<QualifiedName, Collection<Object>>(), new HashMap<Object, Collection<QualifiedName>>(), new HashMap<File, Collection<QualifiedName>>(), new HashMap<Object, Map<String, Serializable>>(), new HashMap<Object, Collection<Message>>());
    }

    public static DefaultBuildContextState emptyState() {
        return new DefaultBuildContextState(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    }

    public String getStats() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.configuration.size()).append(' ');
        sb.append(this.inputs.size()).append(' ');
        sb.append(this.includedInputs.size()).append(' ');
        sb.append(this.outputs.size()).append(' ');
        sb.append(this.inputOutputs.size()).append(' ');
        sb.append(this.outputInputs.size()).append(' ');
        sb.append(this.inputIncludedInputs.size()).append(' ');
        sb.append(this.requirementInputs.size()).append(' ');
        sb.append(this.inputRequirements.size()).append(' ');
        sb.append(this.outputCapabilities.size()).append(' ');
        sb.append(this.resourceAttributes.size()).append(' ');
        sb.append(this.resourceMessages.size()).append(' ');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeTo(File stateFile) throws IOException {
        long start = System.currentTimeMillis();
        File parent = stateFile.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            throw new IOException("Could not create directory " + parent);
        }
        ObjectOutputStream os = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(stateFile)));
        try {
            DefaultBuildContextState.writeMap(os, this.configuration);
            DefaultBuildContextState.writeMap(os, this.outputs);
            DefaultBuildContextState.writeMap(os, this.inputs);
            DefaultBuildContextState.writeMap(os, this.includedInputs);
            DefaultBuildContextState.writeMultimap(os, this.inputOutputs);
            DefaultBuildContextState.writeMultimap(os, this.inputIncludedInputs);
            DefaultBuildContextState.writeDoublemap(os, this.resourceAttributes);
            DefaultBuildContextState.writeMultimap(os, this.resourceMessages);
            this.writeCapabilityConsumers(os, this.requirementInputs);
            this.writeCapabilityProviders(os, this.outputCapabilities);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {}
        }
        log.debug("Stored incremental build state {} ({} ms)", (Object)stateFile, (Object)(System.currentTimeMillis() - start));
    }

    private void writeCapabilityProviders(ObjectOutputStream oos, Map<File, Collection<QualifiedName>> providers) throws IOException {
        oos.writeInt(providers.size());
        for (Map.Entry<File, Collection<QualifiedName>> entry : providers.entrySet()) {
            oos.writeObject(entry.getKey());
            Collection<QualifiedName> qnames = entry.getValue();
            oos.writeInt(qnames.size());
            for (QualifiedName qname : qnames) {
                this.writeQualifiedName(oos, qname);
            }
        }
    }

    private void writeCapabilityConsumers(ObjectOutputStream oos, Map<QualifiedName, Collection<Object>> consumers) throws IOException {
        oos.writeInt(consumers.size());
        for (Map.Entry<QualifiedName, Collection<Object>> entry : consumers.entrySet()) {
            this.writeQualifiedName(oos, entry.getKey());
            DefaultBuildContextState.writeCollection(oos, entry.getValue());
        }
    }

    private void writeQualifiedName(ObjectOutputStream oos, QualifiedName qname) throws IOException {
        oos.writeObject(qname.getQualifier());
        oos.writeObject(qname.getLocalName());
    }

    private static void writeMap(ObjectOutputStream oos, Map<?, ?> map) throws IOException {
        oos.writeInt(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            oos.writeObject(entry.getKey());
            oos.writeObject(entry.getValue());
        }
    }

    private static void writeMultimap(ObjectOutputStream oos, Map<?, ? extends Collection<?>> mmap) throws IOException {
        oos.writeInt(mmap.size());
        for (Map.Entry<?, Collection<?>> entry : mmap.entrySet()) {
            oos.writeObject(entry.getKey());
            DefaultBuildContextState.writeCollection(oos, entry.getValue());
        }
    }

    private static void writeCollection(ObjectOutputStream oos, Collection<?> collection) throws IOException {
        if (collection == null || collection.isEmpty()) {
            oos.writeInt(0);
        } else {
            oos.writeInt(collection.size());
            for (Object element : collection) {
                oos.writeObject(element);
            }
        }
    }

    private static void writeDoublemap(ObjectOutputStream oos, Map<?, ? extends Map<?, ?>> dmap) throws IOException {
        oos.writeInt(dmap.size());
        for (Map.Entry<?, Map<?, ?>> entry : dmap.entrySet()) {
            oos.writeObject(entry.getKey());
            DefaultBuildContextState.writeMap(oos, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DefaultBuildContextState loadFrom(File stateFile) {
        if (stateFile == null) {
            return DefaultBuildContextState.emptyState();
        }
        try {
            ObjectInputStream is = new ObjectInputStream(new BufferedInputStream(new FileInputStream(stateFile))){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    try {
                        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                        Class<?> clazz = tccl.loadClass(desc.getName());
                        return clazz;
                    }
                    catch (ClassNotFoundException e) {
                        return super.resolveClass(desc);
                    }
                }
            };
            try {
                long start = System.currentTimeMillis();
                Map<String, Serializable> configuration = DefaultBuildContextState.readMap(is);
                Map<File, ResourceHolder<File>> outputs = DefaultBuildContextState.readMap(is);
                Map<Object, ResourceHolder<?>> inputs = DefaultBuildContextState.readMap(is);
                Map<Object, ResourceHolder<?>> includedInputs = DefaultBuildContextState.readMap(is);
                Map<Object, Collection<File>> inputOutputs = DefaultBuildContextState.readMultimap(is);
                Map<File, Collection<Object>> outputInputs = DefaultBuildContextState.invertMultimap(inputOutputs);
                Map<Object, Collection<Object>> inputIncludedInputs = DefaultBuildContextState.readMultimap(is);
                Map<Object, Map<String, Serializable>> resourceAttributes = DefaultBuildContextState.readDoublemap(is);
                Map<Object, Collection<Message>> messages = DefaultBuildContextState.readMultimap(is);
                Map<QualifiedName, Collection<Object>> requirementInputs = DefaultBuildContextState.readCapabilityConsumers(is);
                Map<Object, Collection<QualifiedName>> inputRequirements = DefaultBuildContextState.invertMultimap(requirementInputs);
                Map<File, Collection<QualifiedName>> outputCapabilities = DefaultBuildContextState.readCapabilityProviders(is);
                DefaultBuildContextState state = new DefaultBuildContextState(configuration, inputs, outputs, includedInputs, inputOutputs, outputInputs, inputIncludedInputs, requirementInputs, inputRequirements, outputCapabilities, resourceAttributes, messages);
                log.debug("Loaded incremental build state {} ({} ms)", (Object)stateFile, (Object)(System.currentTimeMillis() - start));
                DefaultBuildContextState defaultBuildContextState = state;
                return defaultBuildContextState;
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        catch (FileNotFoundException e) {
            return DefaultBuildContextState.emptyState();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.debug("Could not load incremental build state {}", (Object)stateFile, (Object)e);
        }
        return DefaultBuildContextState.emptyState();
    }

    private static Map<File, Collection<QualifiedName>> readCapabilityProviders(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        HashMap<File, Collection<QualifiedName>> providers = new HashMap<File, Collection<QualifiedName>>();
        int size = ois.readInt();
        for (int i = 0; i < size; ++i) {
            File key = (File)ois.readObject();
            int vsize = ois.readInt();
            ArrayList<QualifiedName> value = new ArrayList<QualifiedName>();
            for (int j = 0; j < vsize; ++j) {
                value.add(DefaultBuildContextState.readQualifiedName(ois));
            }
            providers.put(key, value);
        }
        return providers;
    }

    private static Map<QualifiedName, Collection<Object>> readCapabilityConsumers(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        HashMap<QualifiedName, Collection<Object>> result = new HashMap<QualifiedName, Collection<Object>>();
        int size = ois.readInt();
        for (int i = 0; i < size; ++i) {
            QualifiedName qname = DefaultBuildContextState.readQualifiedName(ois);
            Collection consumers = DefaultBuildContextState.readCollection(ois);
            result.put(qname, consumers);
        }
        return result;
    }

    private static QualifiedName readQualifiedName(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        String qualified = (String)ois.readObject();
        String name = (String)ois.readObject();
        return new QualifiedName(qualified, name);
    }

    private static <K, V> Map<K, V> readMap(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        int size = ois.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = ois.readObject();
            Object value = ois.readObject();
            map.put(key, value);
        }
        return map;
    }

    private static <K, V> Map<K, Collection<V>> readMultimap(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        HashMap<Object, Collection<V>> mmap = new HashMap<Object, Collection<V>>();
        int size = ois.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = ois.readObject();
            Collection<V> value = DefaultBuildContextState.readCollection(ois);
            mmap.put(key, value);
        }
        return mmap;
    }

    private static <V> Collection<V> readCollection(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int size = ois.readInt();
        if (size == 0) {
            return null;
        }
        ArrayList<Object> collection = new ArrayList<Object>();
        for (int i = 0; i < size; ++i) {
            collection.add(ois.readObject());
        }
        return collection;
    }

    private static <K, VK, VV> Map<K, Map<VK, VV>> readDoublemap(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int size = ois.readInt();
        HashMap dmap = new HashMap();
        for (int i = 0; i < size; ++i) {
            Object key = ois.readObject();
            Map value = DefaultBuildContextState.readMap(ois);
            dmap.put(key, value);
        }
        return dmap;
    }

    private static <K, V> Map<V, Collection<K>> invertMultimap(Map<K, Collection<V>> mmap) {
        HashMap<V, ArrayList<K>> inverted = new HashMap<V, ArrayList<K>>();
        for (Map.Entry<K, Collection<V>> entry : mmap.entrySet()) {
            for (V value : entry.getValue()) {
                ArrayList<K> keys = (ArrayList<K>)inverted.get(value);
                if (keys == null) {
                    keys = new ArrayList<K>();
                    inverted.put(value, keys);
                }
                keys.add(entry.getKey());
            }
        }
        return inverted;
    }
}

