/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.spi;

import io.takari.incrementalbuild.workspace.MessageSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMessageSink
implements MessageSink {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private int errorCount;

    public void message(Object resource, int line, int column, String message, MessageSink.Severity severity, Throwable cause) {
        if (severity == MessageSink.Severity.ERROR) {
            ++this.errorCount;
            this.log.error("{}:[{}:{}] {}", new Object[]{resource.toString(), line, column, message, cause});
        } else {
            this.log.warn("{}:[{}:{}] {}", new Object[]{resource.toString(), line, column, message, cause});
        }
    }

    public MessageSink replayMessageSink() {
        this.log.info("Replaying recorded messages...");
        return this;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void clearMessages(Object resource) {
    }
}

