/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.util;

import io.takari.incrementalbuild.BuildContext;
import io.takari.incrementalbuild.spi.ResourceHolder;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class URLResourceHolder
implements ResourceHolder<URL> {
    private final URL url;
    private final byte[] hash;

    public URLResourceHolder(URL url) throws IOException {
        this.url = url;
        this.hash = URLResourceHolder.hash(url);
    }

    @Override
    public URL getResource() {
        return this.url;
    }

    @Override
    public BuildContext.ResourceStatus getStatus() {
        byte[] newHash;
        try {
            newHash = URLResourceHolder.hash(this.url);
        }
        catch (IOException x) {
            return BuildContext.ResourceStatus.REMOVED;
        }
        return Arrays.equals(this.hash, newHash) ? BuildContext.ResourceStatus.UNMODIFIED : BuildContext.ResourceStatus.MODIFIED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] hash(URL url) throws IOException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        try (BufferedInputStream is = new BufferedInputStream(url.openStream());){
            int ch;
            while ((ch = ((InputStream)is).read()) >= 0) {
                digest.update((byte)ch);
            }
        }
        return digest.digest();
    }

    public int hashCode() {
        int hash = 31;
        hash = hash * 17 + this.url.hashCode();
        hash = hash * 17 + Arrays.hashCode(this.hash);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof URLResourceHolder)) {
            return false;
        }
        URLResourceHolder other = (URLResourceHolder)obj;
        return this.url.equals(other.url) && Arrays.equals(this.hash, other.hash);
    }
}

