/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.maven.internal;

import io.takari.incrementalbuild.maven.internal.BytesHash;
import io.takari.incrementalbuild.maven.internal.SHA1Digester;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.eclipse.aether.SessionData;

class ClasspathDigester {
    private static final String SESSION_DATA_KEY = ClasspathDigester.class.getName();
    private final ConcurrentMap<String, byte[]> cache;

    @Inject
    public ClasspathDigester(MavenSession session) {
        this.cache = ClasspathDigester.getCache(session);
    }

    private static ConcurrentMap<String, byte[]> getCache(MavenSession session) {
        SessionData sessionData = session.getRepositorySession().getData();
        if (sessionData.get((Object)SESSION_DATA_KEY) == null) {
            sessionData.set((Object)SESSION_DATA_KEY, null, new ConcurrentHashMap());
        }
        return (ConcurrentMap)sessionData.get((Object)SESSION_DATA_KEY);
    }

    public Serializable digest(List<Artifact> artifacts) throws IOException {
        MessageDigest digester = SHA1Digester.newInstance();
        for (Artifact artifact : artifacts) {
            File file = artifact.getFile();
            String cacheKey = this.getArtifactKey(artifact);
            byte[] hash = (byte[])this.cache.get(cacheKey);
            if (hash != null) continue;
            if (file.isFile()) {
                hash = new JarDigester(file).call();
            } else if (file.isDirectory()) {
                hash = new ClassDirectoryDigester(file).call();
            }
            byte[] existing = this.cache.putIfAbsent(cacheKey, hash);
            if (existing == null) {
                existing = hash;
            }
            digester.update(existing);
        }
        return new BytesHash(digester.digest());
    }

    private String getArtifactKey(Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getGroupId());
        sb.append(':');
        sb.append(artifact.getArtifactId());
        sb.append(':');
        sb.append(artifact.getVersion());
        if (artifact.getClassifier() != null) {
            sb.append(':');
            sb.append(artifact.getClassifier());
        }
        return sb.toString();
    }

    static void digest(MessageDigest digester, InputStream is) throws IOException {
        int r;
        byte[] buf = new byte[4096];
        while ((r = is.read(buf)) > 0) {
            digester.update(buf, 0, r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void digestFile(MessageDigest digester, File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            ClasspathDigester.digest(digester, is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void digestZip(MessageDigest digester, File file) throws IOException {
        try (ZipFile zip = new ZipFile(file);){
            TreeSet<ZipEntry> sorted = new TreeSet<ZipEntry>(new Comparator<ZipEntry>(){

                @Override
                public int compare(ZipEntry o1, ZipEntry o2) {
                    return o2.getName().compareTo(o1.getName());
                }
            });
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                sorted.add(entries.nextElement());
            }
            for (ZipEntry entry : sorted) {
                try (InputStream is = zip.getInputStream(entry);){
                    ClasspathDigester.digest(digester, is);
                }
            }
        }
    }

    private static class ClassDirectoryDigester
    implements Callable<byte[]> {
        private final File directory;

        public ClassDirectoryDigester(File directory) {
            this.directory = directory;
        }

        @Override
        public byte[] call() throws IOException {
            MessageDigest digester = SHA1Digester.newInstance();
            TreeSet<File> sorted = new TreeSet<File>();
            this.lsLR(this.directory, sorted);
            for (File file : sorted) {
                ClasspathDigester.digestFile(digester, file);
            }
            return digester.digest();
        }

        private void lsLR(File directory, TreeSet<File> sorted) {
            File[] files = directory.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        this.lsLR(file, sorted);
                        continue;
                    }
                    sorted.add(file);
                }
            }
        }
    }

    private static class JarDigester
    implements Callable<byte[]> {
        private final File file;

        public JarDigester(File file) {
            this.file = file;
        }

        @Override
        public byte[] call() throws IOException {
            MessageDigest digester = SHA1Digester.newInstance();
            try {
                ClasspathDigester.digestZip(digester, this.file);
            }
            catch (ZipException e) {
                ClasspathDigester.digestFile(digester, this.file);
            }
            return digester.digest();
        }
    }
}

