/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.maven.testing;

import io.takari.incrementalbuild.maven.internal.FilesystemWorkspace;
import io.takari.incrementalbuild.maven.internal.ProjectWorkspace;
import io.takari.incrementalbuild.maven.testing.IncrementalBuildLog;
import io.takari.incrementalbuild.workspace.Workspace;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.inject.Inject;
import org.apache.maven.project.MavenProject;

class TestProjectWorkspace
extends ProjectWorkspace
implements Workspace {
    private final IncrementalBuildLog log;

    @Inject
    public TestProjectWorkspace(MavenProject project, Workspace workspace, FilesystemWorkspace filesystem, IncrementalBuildLog log) {
        super(project, workspace, filesystem);
        this.log = log;
    }

    @Override
    public void processOutput(File file) {
        this.log.addRegisterOutput(file);
        super.processOutput(file);
    }

    @Override
    public void deleteFile(File file) throws IOException {
        this.log.addDeletedOutput(file);
        super.deleteFile(file);
    }

    @Override
    public Workspace escalate() {
        return new ForwardingWorkspace(super.escalate());
    }

    @Override
    protected Workspace getWorkspace(File file) {
        return new ForwardingWorkspace(super.getWorkspace(file));
    }

    private class ForwardingWorkspace
    implements Workspace {
        private final Workspace workspace;

        public ForwardingWorkspace(Workspace workspace) {
            this.workspace = workspace;
        }

        public Workspace.Mode getMode() {
            return this.workspace.getMode();
        }

        public Workspace escalate() {
            throw new UnsupportedOperationException();
        }

        public boolean isPresent(File file) {
            return this.workspace.isPresent(file);
        }

        public boolean isRegularFile(File file) {
            return this.workspace.isRegularFile(file);
        }

        public boolean isDirectory(File file) {
            return this.workspace.isDirectory(file);
        }

        public void deleteFile(File file) throws IOException {
            TestProjectWorkspace.this.log.addDeletedOutput(file);
            this.workspace.deleteFile(file);
        }

        public void processOutput(File file) {
            TestProjectWorkspace.this.log.addRegisterOutput(file);
            this.workspace.processOutput(file);
        }

        public OutputStream newOutputStream(File file) throws IOException {
            return this.workspace.newOutputStream(file);
        }

        public Workspace.ResourceStatus getResourceStatus(File file, long lastModified, long length) {
            return this.workspace.getResourceStatus(file, lastModified, length);
        }

        public void walk(File basedir, Workspace.FileVisitor visitor) throws IOException {
            this.workspace.walk(basedir, visitor);
        }
    }
}

