/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.aggregator.internal;

import io.takari.incrementalbuild.ResourceStatus;
import io.takari.incrementalbuild.aggregator.AggregatorBuildContext;
import io.takari.incrementalbuild.aggregator.InputAggregator;
import io.takari.incrementalbuild.aggregator.MetadataAggregator;
import io.takari.incrementalbuild.aggregator.internal.DefaultInputSet;
import io.takari.incrementalbuild.spi.AbstractBuildContext;
import io.takari.incrementalbuild.spi.BuildContextEnvironment;
import io.takari.incrementalbuild.spi.BuildContextFinalizer;
import io.takari.incrementalbuild.spi.DefaultBuildContextState;
import io.takari.incrementalbuild.spi.DefaultOutput;
import io.takari.incrementalbuild.spi.DefaultResource;
import io.takari.incrementalbuild.spi.DefaultResourceMetadata;
import io.takari.incrementalbuild.workspace.Workspace;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DefaultAggregatorBuildContext
extends AbstractBuildContext
implements AggregatorBuildContext {
    public DefaultAggregatorBuildContext(BuildContextEnvironment configuration) {
        super(configuration);
    }

    public DefaultAggregatorBuildContext(Workspace workspace, File stateFile, Map<String, Serializable> configuration, BuildContextFinalizer finalizer) {
        super(workspace, stateFile, configuration, finalizer);
    }

    @Override
    public DefaultInputSet newInputSet() {
        return new DefaultInputSet(this);
    }

    private File registerOutput(File outputFile) {
        if (this.isRegisteredResource(outputFile = DefaultAggregatorBuildContext.normalize(outputFile))) {
            throw new IllegalStateException("Output already registrered " + outputFile);
        }
        this.registerNormalizedOutput(outputFile);
        return outputFile;
    }

    @Override
    public DefaultResourceMetadata<File> registerInput(File inputFile) {
        return super.registerInput(inputFile);
    }

    private Map<String, Serializable> glean(Collection<File> inputs, MetadataAggregator<? extends Serializable> gleaner) throws IOException {
        String attributeKey = this.attributeKey(gleaner);
        HashMap<String, Serializable> metadata = new HashMap<String, Serializable>();
        for (File inputFile : inputs) {
            if (this.getResourceStatus(inputFile) != ResourceStatus.UNMODIFIED) {
                this.markProcessedResource(inputFile);
                Map<String, ? extends Serializable> gleaned = gleaner.glean(inputFile);
                if (gleaned == null) continue;
                metadata.putAll(gleaned);
                this.state.putResourceAttribute(inputFile, attributeKey, new HashMap<String, Serializable>(gleaned));
                continue;
            }
            Serializable persisted = this.oldState.getResourceAttribute(inputFile, attributeKey);
            this.state.putResourceAttribute(inputFile, attributeKey, persisted);
            this.putAll(metadata, persisted);
        }
        return metadata;
    }

    private String attributeKey(MetadataAggregator<?> gleaner) {
        return gleaner.getClass().getName();
    }

    private void associate(Iterable<File> inputs, File outputFile) {
        for (File inputFile : inputs) {
            this.state.putResourceOutput(inputFile, outputFile);
        }
    }

    public boolean aggregateIfNecessary(Collection<File> inputs, File outputFile, InputAggregator creator) throws IOException {
        outputFile = this.registerOutput(outputFile);
        this.associate(inputs, outputFile);
        boolean processingRequired = this.isEscalated();
        if (!processingRequired) {
            processingRequired = this.isProcessingRequired(inputs, outputFile);
        }
        if (processingRequired) {
            this.markProcessedResource(outputFile);
            this.workspace.processOutput(outputFile);
            DefaultOutput output = this.newOutput(outputFile);
            for (File inputFile : inputs) {
                if (this.isProcessedResource(inputFile)) continue;
                this.markProcessedResource(inputFile);
            }
            creator.aggregate(output, inputs);
        } else {
            this.markUptodateOutput(outputFile);
        }
        return processingRequired;
    }

    private boolean isProcessingRequired(Collection<File> inputs, File outputFile) {
        for (File input : inputs) {
            if (this.getResourceStatus(input) == ResourceStatus.UNMODIFIED) continue;
            return true;
        }
        for (Object oldInput : this.getOutputInputs(this.oldState, outputFile)) {
            if (inputs.contains(oldInput)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void assertAssociation(DefaultResource<?> resource, DefaultOutput output) {
    }

    public boolean aggregateIfNecessary(Collection<File> inputs, File outputFile, MetadataAggregator<?> aggregator) throws IOException {
        outputFile = this.registerOutput(outputFile);
        this.associate(inputs, outputFile);
        Map<String, Serializable> metadata = this.glean(inputs, aggregator);
        boolean processingRequired = this.isEscalated();
        if (!processingRequired) {
            HashMap oldMetadata = new HashMap();
            for (Object input : this.getOutputInputs(this.oldState, outputFile)) {
                this.putAll(oldMetadata, this.oldState.getResourceAttribute(input, this.attributeKey(aggregator)));
            }
            boolean bl = processingRequired = !Objects.equals(metadata, oldMetadata);
        }
        if (processingRequired) {
            this.markProcessedResource(outputFile);
            this.workspace.processOutput(outputFile);
            DefaultOutput output = this.newOutput(outputFile);
            this.aggregate(aggregator, output, metadata);
        } else {
            this.markUptodateOutput(outputFile);
        }
        return processingRequired;
    }

    private void aggregate(MetadataAggregator<?> aggregator, DefaultOutput output, Map<String, Serializable> metadata) throws IOException {
        aggregator.aggregate(output, metadata);
    }

    private <K, V> void putAll(Map<K, V> target, Serializable source) {
        if (source != null) {
            target.putAll((Map)((Object)source));
        }
    }

    @Override
    protected void finalizeContext() throws IOException {
        for (File oldOutput : this.oldState.getOutputs()) {
            if (this.isProcessedResource(oldOutput)) continue;
            if (this.state.getResource(oldOutput) == null) {
                this.deleteOutput(oldOutput);
                continue;
            }
            this.state.setResourceMessages(oldOutput, this.oldState.getResourceMessages(oldOutput));
            this.state.setResourceAttributes(oldOutput, this.oldState.getResourceAttributes(oldOutput));
        }
    }

    private Collection<Object> getOutputInputs(DefaultBuildContextState state, File outputFile) {
        Collection<Object> inputs = state.getOutputInputs(outputFile);
        return inputs != null && !inputs.isEmpty() ? inputs : Collections.emptyList();
    }

    @Override
    public Collection<DefaultResourceMetadata<File>> registerInputs(File basedir, Collection<String> includes, Collection<String> excludes) throws IOException {
        return super.registerInputs(basedir, includes, excludes);
    }
}

