package io.takari.jpgp;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PgpSigningRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePgpSigningRequest.builder()}.
 */
@Generated(from = "PgpSigningRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePgpSigningRequest extends PgpSigningRequest {
  private final String signingKeyId;
  private final @Nullable Path gpgHomedir;
  private final boolean privateKeyFromEnvar;
  private final @Nullable Path privateKeyFromPath;
  private final @Nullable String privateKeyPassphrase;

  private ImmutablePgpSigningRequest(ImmutablePgpSigningRequest.Builder builder) {
    this.gpgHomedir = builder.gpgHomedir;
    this.privateKeyFromPath = builder.privateKeyFromPath;
    this.privateKeyPassphrase = builder.privateKeyPassphrase;
    if (builder.signingKeyId != null) {
      initShim.signingKeyId(builder.signingKeyId);
    }
    if (builder.privateKeyFromEnvarIsSet()) {
      initShim.privateKeyFromEnvar(builder.privateKeyFromEnvar);
    }
    this.signingKeyId = initShim.signingKeyId();
    this.privateKeyFromEnvar = initShim.privateKeyFromEnvar();
    this.initShim = null;
  }

  private ImmutablePgpSigningRequest(
      String signingKeyId,
      @Nullable Path gpgHomedir,
      boolean privateKeyFromEnvar,
      @Nullable Path privateKeyFromPath,
      @Nullable String privateKeyPassphrase) {
    this.signingKeyId = signingKeyId;
    this.gpgHomedir = gpgHomedir;
    this.privateKeyFromEnvar = privateKeyFromEnvar;
    this.privateKeyFromPath = privateKeyFromPath;
    this.privateKeyPassphrase = privateKeyPassphrase;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "PgpSigningRequest", generator = "Immutables")
  private final class InitShim {
    private byte signingKeyIdBuildStage = STAGE_UNINITIALIZED;
    private String signingKeyId;

    String signingKeyId() {
      if (signingKeyIdBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (signingKeyIdBuildStage == STAGE_UNINITIALIZED) {
        signingKeyIdBuildStage = STAGE_INITIALIZING;
        this.signingKeyId = Objects.requireNonNull(ImmutablePgpSigningRequest.super.signingKeyId(), "signingKeyId");
        signingKeyIdBuildStage = STAGE_INITIALIZED;
      }
      return this.signingKeyId;
    }

    void signingKeyId(String signingKeyId) {
      this.signingKeyId = signingKeyId;
      signingKeyIdBuildStage = STAGE_INITIALIZED;
    }

    private byte privateKeyFromEnvarBuildStage = STAGE_UNINITIALIZED;
    private boolean privateKeyFromEnvar;

    boolean privateKeyFromEnvar() {
      if (privateKeyFromEnvarBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (privateKeyFromEnvarBuildStage == STAGE_UNINITIALIZED) {
        privateKeyFromEnvarBuildStage = STAGE_INITIALIZING;
        this.privateKeyFromEnvar = ImmutablePgpSigningRequest.super.privateKeyFromEnvar();
        privateKeyFromEnvarBuildStage = STAGE_INITIALIZED;
      }
      return this.privateKeyFromEnvar;
    }

    void privateKeyFromEnvar(boolean privateKeyFromEnvar) {
      this.privateKeyFromEnvar = privateKeyFromEnvar;
      privateKeyFromEnvarBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (signingKeyIdBuildStage == STAGE_INITIALIZING) attributes.add("signingKeyId");
      if (privateKeyFromEnvarBuildStage == STAGE_INITIALIZING) attributes.add("privateKeyFromEnvar");
      return "Cannot build PgpSigningRequest, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code signingKeyId} attribute
   */
  @Override
  public String signingKeyId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.signingKeyId()
        : this.signingKeyId;
  }

  /**
   * @return The value of the {@code gpgHomedir} attribute
   */
  @Override
  public @Nullable Path gpgHomedir() {
    return gpgHomedir;
  }

  /**
   * @return The value of the {@code privateKeyFromEnvar} attribute
   */
  @Override
  public boolean privateKeyFromEnvar() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.privateKeyFromEnvar()
        : this.privateKeyFromEnvar;
  }

  /**
   * @return The value of the {@code privateKeyFromPath} attribute
   */
  @Override
  public @Nullable Path privateKeyFromPath() {
    return privateKeyFromPath;
  }

  /**
   * @return The value of the {@code privateKeyPassphrase} attribute
   */
  @Override
  public @Nullable String privateKeyPassphrase() {
    return privateKeyPassphrase;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PgpSigningRequest#signingKeyId() signingKeyId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for signingKeyId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePgpSigningRequest withSigningKeyId(String value) {
    String newValue = Objects.requireNonNull(value, "signingKeyId");
    if (this.signingKeyId.equals(newValue)) return this;
    return new ImmutablePgpSigningRequest(
        newValue,
        this.gpgHomedir,
        this.privateKeyFromEnvar,
        this.privateKeyFromPath,
        this.privateKeyPassphrase);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PgpSigningRequest#gpgHomedir() gpgHomedir} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for gpgHomedir (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePgpSigningRequest withGpgHomedir(@Nullable Path value) {
    if (this.gpgHomedir == value) return this;
    return new ImmutablePgpSigningRequest(
        this.signingKeyId,
        value,
        this.privateKeyFromEnvar,
        this.privateKeyFromPath,
        this.privateKeyPassphrase);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PgpSigningRequest#privateKeyFromEnvar() privateKeyFromEnvar} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for privateKeyFromEnvar
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePgpSigningRequest withPrivateKeyFromEnvar(boolean value) {
    if (this.privateKeyFromEnvar == value) return this;
    return new ImmutablePgpSigningRequest(this.signingKeyId, this.gpgHomedir, value, this.privateKeyFromPath, this.privateKeyPassphrase);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PgpSigningRequest#privateKeyFromPath() privateKeyFromPath} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for privateKeyFromPath (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePgpSigningRequest withPrivateKeyFromPath(@Nullable Path value) {
    if (this.privateKeyFromPath == value) return this;
    return new ImmutablePgpSigningRequest(this.signingKeyId, this.gpgHomedir, this.privateKeyFromEnvar, value, this.privateKeyPassphrase);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PgpSigningRequest#privateKeyPassphrase() privateKeyPassphrase} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for privateKeyPassphrase (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePgpSigningRequest withPrivateKeyPassphrase(@Nullable String value) {
    if (Objects.equals(this.privateKeyPassphrase, value)) return this;
    return new ImmutablePgpSigningRequest(this.signingKeyId, this.gpgHomedir, this.privateKeyFromEnvar, this.privateKeyFromPath, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePgpSigningRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePgpSigningRequest
        && equalTo((ImmutablePgpSigningRequest) another);
  }

  private boolean equalTo(ImmutablePgpSigningRequest another) {
    return signingKeyId.equals(another.signingKeyId)
        && Objects.equals(gpgHomedir, another.gpgHomedir)
        && privateKeyFromEnvar == another.privateKeyFromEnvar
        && Objects.equals(privateKeyFromPath, another.privateKeyFromPath)
        && Objects.equals(privateKeyPassphrase, another.privateKeyPassphrase);
  }

  /**
   * Computes a hash code from attributes: {@code signingKeyId}, {@code gpgHomedir}, {@code privateKeyFromEnvar}, {@code privateKeyFromPath}, {@code privateKeyPassphrase}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + signingKeyId.hashCode();
    h += (h << 5) + Objects.hashCode(gpgHomedir);
    h += (h << 5) + Boolean.hashCode(privateKeyFromEnvar);
    h += (h << 5) + Objects.hashCode(privateKeyFromPath);
    h += (h << 5) + Objects.hashCode(privateKeyPassphrase);
    return h;
  }

  /**
   * Prints the immutable value {@code PgpSigningRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PgpSigningRequest{"
        + "signingKeyId=" + signingKeyId
        + ", gpgHomedir=" + gpgHomedir
        + ", privateKeyFromEnvar=" + privateKeyFromEnvar
        + ", privateKeyFromPath=" + privateKeyFromPath
        + ", privateKeyPassphrase=" + privateKeyPassphrase
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link PgpSigningRequest} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PgpSigningRequest instance
   */
  public static ImmutablePgpSigningRequest copyOf(PgpSigningRequest instance) {
    if (instance instanceof ImmutablePgpSigningRequest) {
      return (ImmutablePgpSigningRequest) instance;
    }
    return ImmutablePgpSigningRequest.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePgpSigningRequest ImmutablePgpSigningRequest}.
   * <pre>
   * ImmutablePgpSigningRequest.builder()
   *    .signingKeyId(String) // optional {@link PgpSigningRequest#signingKeyId() signingKeyId}
   *    .gpgHomedir(java.nio.file.Path | null) // nullable {@link PgpSigningRequest#gpgHomedir() gpgHomedir}
   *    .privateKeyFromEnvar(boolean) // optional {@link PgpSigningRequest#privateKeyFromEnvar() privateKeyFromEnvar}
   *    .privateKeyFromPath(java.nio.file.Path | null) // nullable {@link PgpSigningRequest#privateKeyFromPath() privateKeyFromPath}
   *    .privateKeyPassphrase(String | null) // nullable {@link PgpSigningRequest#privateKeyPassphrase() privateKeyPassphrase}
   *    .build();
   * </pre>
   * @return A new ImmutablePgpSigningRequest builder
   */
  public static ImmutablePgpSigningRequest.Builder builder() {
    return new ImmutablePgpSigningRequest.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePgpSigningRequest ImmutablePgpSigningRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PgpSigningRequest", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_PRIVATE_KEY_FROM_ENVAR = 0x1L;
    private long optBits;

    private @Nullable String signingKeyId;
    private @Nullable Path gpgHomedir;
    private boolean privateKeyFromEnvar;
    private @Nullable Path privateKeyFromPath;
    private @Nullable String privateKeyPassphrase;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PgpSigningRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PgpSigningRequest instance) {
      Objects.requireNonNull(instance, "instance");
      signingKeyId(instance.signingKeyId());
      @Nullable Path gpgHomedirValue = instance.gpgHomedir();
      if (gpgHomedirValue != null) {
        gpgHomedir(gpgHomedirValue);
      }
      privateKeyFromEnvar(instance.privateKeyFromEnvar());
      @Nullable Path privateKeyFromPathValue = instance.privateKeyFromPath();
      if (privateKeyFromPathValue != null) {
        privateKeyFromPath(privateKeyFromPathValue);
      }
      @Nullable String privateKeyPassphraseValue = instance.privateKeyPassphrase();
      if (privateKeyPassphraseValue != null) {
        privateKeyPassphrase(privateKeyPassphraseValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link PgpSigningRequest#signingKeyId() signingKeyId} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link PgpSigningRequest#signingKeyId() signingKeyId}.</em>
     * @param signingKeyId The value for signingKeyId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder signingKeyId(String signingKeyId) {
      this.signingKeyId = Objects.requireNonNull(signingKeyId, "signingKeyId");
      return this;
    }

    /**
     * Initializes the value for the {@link PgpSigningRequest#gpgHomedir() gpgHomedir} attribute.
     * @param gpgHomedir The value for gpgHomedir (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder gpgHomedir(@Nullable Path gpgHomedir) {
      this.gpgHomedir = gpgHomedir;
      return this;
    }

    /**
     * Initializes the value for the {@link PgpSigningRequest#privateKeyFromEnvar() privateKeyFromEnvar} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link PgpSigningRequest#privateKeyFromEnvar() privateKeyFromEnvar}.</em>
     * @param privateKeyFromEnvar The value for privateKeyFromEnvar 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder privateKeyFromEnvar(boolean privateKeyFromEnvar) {
      this.privateKeyFromEnvar = privateKeyFromEnvar;
      optBits |= OPT_BIT_PRIVATE_KEY_FROM_ENVAR;
      return this;
    }

    /**
     * Initializes the value for the {@link PgpSigningRequest#privateKeyFromPath() privateKeyFromPath} attribute.
     * @param privateKeyFromPath The value for privateKeyFromPath (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder privateKeyFromPath(@Nullable Path privateKeyFromPath) {
      this.privateKeyFromPath = privateKeyFromPath;
      return this;
    }

    /**
     * Initializes the value for the {@link PgpSigningRequest#privateKeyPassphrase() privateKeyPassphrase} attribute.
     * @param privateKeyPassphrase The value for privateKeyPassphrase (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder privateKeyPassphrase(@Nullable String privateKeyPassphrase) {
      this.privateKeyPassphrase = privateKeyPassphrase;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePgpSigningRequest ImmutablePgpSigningRequest}.
     * @return An immutable instance of PgpSigningRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePgpSigningRequest build() {
      return new ImmutablePgpSigningRequest(this);
    }

    private boolean privateKeyFromEnvarIsSet() {
      return (optBits & OPT_BIT_PRIVATE_KEY_FROM_ENVAR) != 0;
    }
  }
}
