/*
 * Decompiled with CFR 0.152.
 */
package io.takari.jpgp;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.takari.jpgp.PgpSigningRequest;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PgpSigningRequest", generator="Immutables")
@Immutable
public final class ImmutablePgpSigningRequest
extends PgpSigningRequest {
    private final String signingKeyId;
    @Nullable
    private final Path gpgHomedir;
    private final boolean privateKeyFromEnvar;
    @Nullable
    private final Path privateKeyFromPath;
    @Nullable
    private final String privateKeyPassphrase;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePgpSigningRequest(Builder builder) {
        this.gpgHomedir = builder.gpgHomedir;
        this.privateKeyFromPath = builder.privateKeyFromPath;
        this.privateKeyPassphrase = builder.privateKeyPassphrase;
        if (builder.signingKeyId != null) {
            this.initShim.signingKeyId(builder.signingKeyId);
        }
        if (builder.privateKeyFromEnvarIsSet()) {
            this.initShim.privateKeyFromEnvar(builder.privateKeyFromEnvar);
        }
        this.signingKeyId = this.initShim.signingKeyId();
        this.privateKeyFromEnvar = this.initShim.privateKeyFromEnvar();
        this.initShim = null;
    }

    private ImmutablePgpSigningRequest(String signingKeyId, @Nullable Path gpgHomedir, boolean privateKeyFromEnvar, @Nullable Path privateKeyFromPath, @Nullable String privateKeyPassphrase) {
        this.signingKeyId = signingKeyId;
        this.gpgHomedir = gpgHomedir;
        this.privateKeyFromEnvar = privateKeyFromEnvar;
        this.privateKeyFromPath = privateKeyFromPath;
        this.privateKeyPassphrase = privateKeyPassphrase;
        this.initShim = null;
    }

    @Override
    public String signingKeyId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.signingKeyId() : this.signingKeyId;
    }

    @Override
    @Nullable
    public Path gpgHomedir() {
        return this.gpgHomedir;
    }

    @Override
    public boolean privateKeyFromEnvar() {
        InitShim shim = this.initShim;
        return shim != null ? shim.privateKeyFromEnvar() : this.privateKeyFromEnvar;
    }

    @Override
    @Nullable
    public Path privateKeyFromPath() {
        return this.privateKeyFromPath;
    }

    @Override
    @Nullable
    public String privateKeyPassphrase() {
        return this.privateKeyPassphrase;
    }

    public final ImmutablePgpSigningRequest withSigningKeyId(String value) {
        String newValue = Objects.requireNonNull(value, "signingKeyId");
        if (this.signingKeyId.equals(newValue)) {
            return this;
        }
        return new ImmutablePgpSigningRequest(newValue, this.gpgHomedir, this.privateKeyFromEnvar, this.privateKeyFromPath, this.privateKeyPassphrase);
    }

    public final ImmutablePgpSigningRequest withGpgHomedir(@Nullable Path value) {
        if (this.gpgHomedir == value) {
            return this;
        }
        return new ImmutablePgpSigningRequest(this.signingKeyId, value, this.privateKeyFromEnvar, this.privateKeyFromPath, this.privateKeyPassphrase);
    }

    public final ImmutablePgpSigningRequest withPrivateKeyFromEnvar(boolean value) {
        if (this.privateKeyFromEnvar == value) {
            return this;
        }
        return new ImmutablePgpSigningRequest(this.signingKeyId, this.gpgHomedir, value, this.privateKeyFromPath, this.privateKeyPassphrase);
    }

    public final ImmutablePgpSigningRequest withPrivateKeyFromPath(@Nullable Path value) {
        if (this.privateKeyFromPath == value) {
            return this;
        }
        return new ImmutablePgpSigningRequest(this.signingKeyId, this.gpgHomedir, this.privateKeyFromEnvar, value, this.privateKeyPassphrase);
    }

    public final ImmutablePgpSigningRequest withPrivateKeyPassphrase(@Nullable String value) {
        if (Objects.equals(this.privateKeyPassphrase, value)) {
            return this;
        }
        return new ImmutablePgpSigningRequest(this.signingKeyId, this.gpgHomedir, this.privateKeyFromEnvar, this.privateKeyFromPath, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePgpSigningRequest && this.equalTo(0, (ImmutablePgpSigningRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutablePgpSigningRequest another) {
        return this.signingKeyId.equals(another.signingKeyId) && Objects.equals(this.gpgHomedir, another.gpgHomedir) && this.privateKeyFromEnvar == another.privateKeyFromEnvar && Objects.equals(this.privateKeyFromPath, another.privateKeyFromPath) && Objects.equals(this.privateKeyPassphrase, another.privateKeyPassphrase);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.signingKeyId.hashCode();
        h += (h << 5) + Objects.hashCode(this.gpgHomedir);
        h += (h << 5) + Boolean.hashCode(this.privateKeyFromEnvar);
        h += (h << 5) + Objects.hashCode(this.privateKeyFromPath);
        h += (h << 5) + Objects.hashCode(this.privateKeyPassphrase);
        return h;
    }

    public String toString() {
        return "PgpSigningRequest{signingKeyId=" + this.signingKeyId + ", gpgHomedir=" + this.gpgHomedir + ", privateKeyFromEnvar=" + this.privateKeyFromEnvar + ", privateKeyFromPath=" + this.privateKeyFromPath + ", privateKeyPassphrase=" + this.privateKeyPassphrase + "}";
    }

    public static ImmutablePgpSigningRequest copyOf(PgpSigningRequest instance) {
        if (instance instanceof ImmutablePgpSigningRequest) {
            return (ImmutablePgpSigningRequest)instance;
        }
        return ImmutablePgpSigningRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PgpSigningRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_PRIVATE_KEY_FROM_ENVAR = 1L;
        private long optBits;
        @Nullable
        private String signingKeyId;
        @Nullable
        private Path gpgHomedir;
        private boolean privateKeyFromEnvar;
        @Nullable
        private Path privateKeyFromPath;
        @Nullable
        private String privateKeyPassphrase;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PgpSigningRequest instance) {
            String privateKeyPassphraseValue;
            Objects.requireNonNull(instance, "instance");
            this.signingKeyId(instance.signingKeyId());
            Path gpgHomedirValue = instance.gpgHomedir();
            if (gpgHomedirValue != null) {
                this.gpgHomedir(gpgHomedirValue);
            }
            this.privateKeyFromEnvar(instance.privateKeyFromEnvar());
            Path privateKeyFromPathValue = instance.privateKeyFromPath();
            if (privateKeyFromPathValue != null) {
                this.privateKeyFromPath(privateKeyFromPathValue);
            }
            if ((privateKeyPassphraseValue = instance.privateKeyPassphrase()) != null) {
                this.privateKeyPassphrase(privateKeyPassphraseValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signingKeyId(String signingKeyId) {
            this.signingKeyId = Objects.requireNonNull(signingKeyId, "signingKeyId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder gpgHomedir(@Nullable Path gpgHomedir) {
            this.gpgHomedir = gpgHomedir;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder privateKeyFromEnvar(boolean privateKeyFromEnvar) {
            this.privateKeyFromEnvar = privateKeyFromEnvar;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder privateKeyFromPath(@Nullable Path privateKeyFromPath) {
            this.privateKeyFromPath = privateKeyFromPath;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder privateKeyPassphrase(@Nullable String privateKeyPassphrase) {
            this.privateKeyPassphrase = privateKeyPassphrase;
            return this;
        }

        public ImmutablePgpSigningRequest build() {
            return new ImmutablePgpSigningRequest(this);
        }

        private boolean privateKeyFromEnvarIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Generated(from="PgpSigningRequest", generator="Immutables")
    private final class InitShim {
        private byte signingKeyIdBuildStage = 0;
        private String signingKeyId;
        private byte privateKeyFromEnvarBuildStage = 0;
        private boolean privateKeyFromEnvar;

        private InitShim() {
        }

        String signingKeyId() {
            if (this.signingKeyIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.signingKeyIdBuildStage == 0) {
                this.signingKeyIdBuildStage = (byte)-1;
                this.signingKeyId = Objects.requireNonNull(ImmutablePgpSigningRequest.super.signingKeyId(), "signingKeyId");
                this.signingKeyIdBuildStage = 1;
            }
            return this.signingKeyId;
        }

        void signingKeyId(String signingKeyId) {
            this.signingKeyId = signingKeyId;
            this.signingKeyIdBuildStage = 1;
        }

        boolean privateKeyFromEnvar() {
            if (this.privateKeyFromEnvarBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.privateKeyFromEnvarBuildStage == 0) {
                this.privateKeyFromEnvarBuildStage = (byte)-1;
                this.privateKeyFromEnvar = ImmutablePgpSigningRequest.super.privateKeyFromEnvar();
                this.privateKeyFromEnvarBuildStage = 1;
            }
            return this.privateKeyFromEnvar;
        }

        void privateKeyFromEnvar(boolean privateKeyFromEnvar) {
            this.privateKeyFromEnvar = privateKeyFromEnvar;
            this.privateKeyFromEnvarBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.signingKeyIdBuildStage == -1) {
                attributes.add("signingKeyId");
            }
            if (this.privateKeyFromEnvarBuildStage == -1) {
                attributes.add("privateKeyFromEnvar");
            }
            return "Cannot build PgpSigningRequest, attribute initializers form cycle " + attributes;
        }
    }
}

