/*
 * Copyright (c) 2014-2024 Takari, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-v10.html
 */
package io.takari.jpgp;

import java.nio.file.Path;
import org.bouncycastle.openpgp.PGPSecretKey;

public class PgpKey {

    private PGPSecretKey secretKey;

    private Path origin;

    public PgpKey(PGPSecretKey secretKey, Path origin) {
        this.secretKey = secretKey;
        this.origin = origin;
    }

    public PGPSecretKey getSecretKey() {
        return secretKey;
    }

    public Path getOrigin() {
        return origin;
    }
}
