/*
 * Copyright (c) 2014-2024 Takari, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-v10.html
 */
package io.takari.jpgp;

import java.nio.file.Path;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@Value.Immutable
public abstract class PgpSigningRequest {

    public static final String FIRST = "@first";

    @Value.Default
    public String signingKeyId() {
        return FIRST;
    }

    @Nullable
    public abstract Path gpgHomedir();

    @Value.Default
    public boolean privateKeyFromEnvar() {
        return false;
    }

    @Nullable
    public abstract Path privateKeyFromPath();

    @Nullable
    public abstract String privateKeyPassphrase();
}
