/*
 * Decompiled with CFR 0.152.
 */
package io.takari.jpgp;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class CliCommand {
    private final Path workDir;
    private final List<String> args;
    private final Map<String, String> envars;
    private final boolean saveOutput;
    private final boolean quiet;

    public CliCommand(String args, boolean saveOutput) {
        this(Arrays.asList(args.split(" ")), Paths.get(System.getProperty("user.dir"), new String[0]), new HashMap<String, String>(), saveOutput);
    }

    public CliCommand(String args, Path workDir, Map<String, String> envars, boolean saveOutput) {
        this(Arrays.asList(args.split(" ")), workDir, envars, saveOutput);
    }

    public CliCommand(List<String> args, Path workDir, Map<String, String> envars, boolean saveOutput) {
        this.workDir = workDir;
        this.args = args;
        this.envars = envars;
        this.saveOutput = saveOutput;
        this.quiet = true;
    }

    protected static void log(String line) {
        System.out.println(line);
    }

    public Result execute() throws Exception {
        return this.execute(Executors.newCachedThreadPool());
    }

    public Result execute(ExecutorService executor) throws Exception {
        ProcessBuilder pb = new ProcessBuilder(this.args).directory(this.workDir.toFile());
        HashMap<String, String> combinedEnv = new HashMap<String, String>(this.envars);
        pb.environment().putAll(combinedEnv);
        Process p = pb.start();
        Future<String> stderr = executor.submit(new StreamReader(this.saveOutput, this.quiet, p.getErrorStream()));
        Future<String> stdout = executor.submit(new StreamReader(this.saveOutput, this.quiet, p.getInputStream()));
        int code = p.waitFor();
        executor.shutdown();
        return new Result(code, stdout.get(), stderr.get());
    }

    public static class Result {
        private final int code;
        private final String stdout;
        private final String stderr;

        public Result(int code, String stdout, String stderr) {
            this.code = code;
            this.stdout = stdout;
            this.stderr = stderr;
        }

        public int getCode() {
            return this.code;
        }

        public String getStdout() {
            return this.stdout;
        }

        public String getStderr() {
            return this.stderr;
        }
    }

    private static class StreamReader
    implements Callable<String> {
        private final boolean saveOutput;
        private final boolean quiet;
        private final InputStream in;

        private StreamReader(boolean saveOutput, boolean quiet, InputStream in) {
            this.saveOutput = saveOutput;
            this.quiet = quiet;
            this.in = in;
        }

        @Override
        public String call() throws Exception {
            StringBuilder sb = new StringBuilder();
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.in, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (this.saveOutput) {
                        sb.append(line).append(System.lineSeparator());
                    }
                    if (this.quiet) continue;
                    CliCommand.log(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return sb.toString();
        }
    }
}

