/*
 * Decompiled with CFR 0.152.
 */
package io.takari.jpgp;

import io.takari.jpgp.CliCommand;
import io.takari.jpgp.ImmutablePgpSigningRequest;
import io.takari.jpgp.PgpKey;
import io.takari.jpgp.PgpSigningRequest;
import io.takari.jpgp.passphrase.PgpPassphraseFinder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.gpg.keybox.BlobType;
import org.bouncycastle.gpg.keybox.KeyBlob;
import org.bouncycastle.gpg.keybox.KeyBox;
import org.bouncycastle.gpg.keybox.KeyInformation;
import org.bouncycastle.gpg.keybox.PublicKeyRingBlob;
import org.bouncycastle.gpg.keybox.UserID;
import org.bouncycastle.gpg.keybox.jcajce.JcaKeyBox;
import org.bouncycastle.gpg.keybox.jcajce.JcaKeyBoxBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.util.encoders.Hex;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.gpg.bc.internal.BCText;
import org.eclipse.jgit.gpg.bc.internal.keys.KeyGrip;
import org.eclipse.jgit.gpg.bc.internal.keys.SecretKeys;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpKeyLocator {
    private static final Class<JGitText> HACK = JGitText.class;
    private static final Logger log = LoggerFactory.getLogger(PgpKeyLocator.class);
    private final Path gpgHomedir;
    private final Path userKeyboxPath;
    private final Path userSecretKeyDir;
    private final Path userPgpPubringFile;
    private final Path userPgpLegacySecringFile;
    private final String signingKey;
    private boolean loadLegacyFirst = true;
    private final PgpSigningRequest request;

    private Path findGpgDirectory() {
        SystemReader system = SystemReader.getInstance();
        Function<String, Path> resolveTilde = s -> {
            if (s.startsWith("~/") || s.startsWith("~" + File.separatorChar)) {
                return new File(FS.DETECTED.userHome(), s.substring(2)).getAbsoluteFile().toPath();
            }
            return Paths.get(s, new String[0]);
        };
        Path path = PgpKeyLocator.checkDirectory(system.getProperty("gpg.home"), resolveTilde, s -> log.warn(BCText.get().logWarnGpgHomeProperty, s));
        if (path != null) {
            return path;
        }
        path = PgpKeyLocator.checkDirectory(system.getenv("GNUPGHOME"), resolveTilde, s -> log.warn(BCText.get().logWarnGnuPGHome, s));
        if (path != null) {
            return path;
        }
        if (system.isWindows() && (path = PgpKeyLocator.checkDirectory(system.getenv("APPDATA"), s -> Paths.get(s, new String[0]).resolve("gnupg"), null)) != null) {
            return path;
        }
        return resolveTilde.apply("~/.gnupg");
    }

    private static Path checkDirectory(String dir, Function<String, Path> toPath, Consumer<String> warn) {
        if (!StringUtils.isEmptyOrNull((String)dir)) {
            try {
                Path directory = toPath.apply(dir);
                if (Files.isDirectory(directory, new LinkOption[0])) {
                    return directory;
                }
            }
            catch (SecurityException | InvalidPathException runtimeException) {}
            if (warn != null) {
                warn.accept(dir);
            }
        }
        return null;
    }

    public PgpKeyLocator(PgpSigningRequest request) {
        this.request = request;
        this.gpgHomedir = request.gpgHomedir() == null ? this.findGpgDirectory() : request.gpgHomedir();
        this.signingKey = request.signingKeyId();
        this.userKeyboxPath = this.gpgHomedir.resolve("pubring.kbx");
        this.userSecretKeyDir = this.gpgHomedir.resolve("private-keys-v1.d");
        this.userPgpPubringFile = this.gpgHomedir.resolve("pubring.gpg");
        this.userPgpLegacySecringFile = this.gpgHomedir.resolve("secring.gpg");
        log.info("Using {} as GPG homedir: (like using gpg --homedir <homedir>", (Object)this.gpgHomedir);
    }

    private PGPSecretKey attemptParseSecretKey(Path keyFile, PGPDigestCalculatorProvider calculatorProvider, SecretKeys.PassphraseSupplier passphraseSupplier, PGPPublicKey publicKey) throws IOException, PGPException, CanceledException, UnsupportedCredentialItem, URISyntaxException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream in = Files.newInputStream(keyFile, new OpenOption[0]);){
            return SecretKeys.readSecretKey((InputStream)in, (PGPDigestCalculatorProvider)calculatorProvider, (SecretKeys.PassphraseSupplier)passphraseSupplier, (PGPPublicKey)publicKey);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Path gpgHomedir() {
        return this.gpgHomedir;
    }

    static boolean containsSigningKey(String userId, String signingKeySpec) {
        if (StringUtils.isEmptyOrNull((String)userId) || StringUtils.isEmptyOrNull((String)signingKeySpec)) {
            return false;
        }
        String toMatch = signingKeySpec;
        if (toMatch.startsWith("0x") && toMatch.trim().length() > 2) {
            return false;
        }
        char command = toMatch.charAt(0);
        switch (command) {
            case '*': 
            case '<': 
            case '=': 
            case '@': {
                toMatch = toMatch.substring(1);
                if (!toMatch.isEmpty()) break;
                return false;
            }
        }
        switch (command) {
            case '=': {
                return userId.equals(toMatch);
            }
            case '<': {
                int begin = userId.indexOf(60);
                int end = userId.indexOf(62, begin + 1);
                int stop = toMatch.indexOf(62);
                return begin >= 0 && end > begin + 1 && stop > 0 && userId.substring(begin + 1, end).equalsIgnoreCase(toMatch.substring(0, stop));
            }
            case '@': {
                int begin = userId.indexOf(60);
                int end = userId.indexOf(62, begin + 1);
                return begin >= 0 && end > begin + 1 && PgpKeyLocator.containsIgnoreCase(userId.substring(begin + 1, end), toMatch);
            }
        }
        if (toMatch.trim().isEmpty()) {
            return false;
        }
        return PgpKeyLocator.containsIgnoreCase(userId, toMatch);
    }

    private static boolean containsIgnoreCase(String a, String b) {
        int alength = a.length();
        int blength = b.length();
        int i = 0;
        while (i + blength <= alength) {
            if (a.regionMatches(true, i, b, 0, blength)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String toFingerprint(String keyId) {
        if (keyId.startsWith("0x")) {
            return keyId.substring(2);
        }
        return keyId;
    }

    PGPPublicKey findPublicKey(String fingerprint, String keySpec) throws IOException, PGPException {
        PGPPublicKey result = PgpKeyLocator.findPublicKeyInPubring(this.userPgpPubringFile, fingerprint, keySpec);
        if (result == null && Files.exists(this.userKeyboxPath, new LinkOption[0])) {
            try {
                result = PgpKeyLocator.findPublicKeyInKeyBox(this.userKeyboxPath, fingerprint, keySpec);
            }
            catch (NoOpenPgpKeyException | IOException | NoSuchAlgorithmException | NoSuchProviderException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private static PGPPublicKey findPublicKeyByKeyId(KeyBlob keyBlob, String keyId) throws IOException {
        if (keyId.isEmpty()) {
            return null;
        }
        for (KeyInformation keyInfo : keyBlob.getKeyInformation()) {
            String fingerprint = Hex.toHexString((byte[])keyInfo.getFingerprint()).toLowerCase(Locale.ROOT);
            if (!fingerprint.endsWith(keyId)) continue;
            return PgpKeyLocator.getPublicKey(keyBlob, keyInfo.getFingerprint());
        }
        return null;
    }

    private static PGPPublicKey findPublicKeyByUserId(KeyBlob keyBlob, String keySpec) throws IOException {
        for (UserID userID : keyBlob.getUserIds()) {
            if (!PgpKeyLocator.containsSigningKey(userID.getUserIDAsString(), keySpec) && !keySpec.equals("@first")) continue;
            return PgpKeyLocator.getSigningPublicKey(keyBlob);
        }
        return null;
    }

    private static PGPPublicKey findPublicKeyInKeyBox(Path keyboxFile, String keyId, String keySpec) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, NoOpenPgpKeyException {
        KeyBox keyBox = PgpKeyLocator.readKeyBoxFile(keyboxFile);
        String id = keyId != null ? keyId : PgpKeyLocator.toFingerprint(keySpec).toLowerCase(Locale.ROOT);
        boolean hasOpenPgpKey = false;
        for (KeyBlob keyBlob : keyBox.getKeyBlobs()) {
            if (keyBlob.getType() != BlobType.OPEN_PGP_BLOB) continue;
            hasOpenPgpKey = true;
            PGPPublicKey key = PgpKeyLocator.findPublicKeyByKeyId(keyBlob, id);
            if (key != null) {
                return key;
            }
            key = PgpKeyLocator.findPublicKeyByUserId(keyBlob, keySpec);
            if (key == null) continue;
            return key;
        }
        if (!hasOpenPgpKey) {
            throw new NoOpenPgpKeyException();
        }
        return null;
    }

    public PGPSecretKey findPgpSecretKey() throws IOException, NoSuchAlgorithmException, NoSuchProviderException, PGPException, CanceledException, UnsupportedCredentialItem, URISyntaxException {
        return this.findSecretKey().getSecretKey();
    }

    @NonNull
    public PgpKey findSecretKey() throws IOException, NoSuchAlgorithmException, NoSuchProviderException, PGPException, CanceledException, UnsupportedCredentialItem, URISyntaxException {
        PgpKey key;
        PGPPublicKey publicKey = null;
        boolean hasSecring = false;
        if (this.loadLegacyFirst && Files.exists(this.userPgpLegacySecringFile, new LinkOption[0])) {
            hasSecring = true;
            key = this.loadKeyFromSecring(this.userPgpLegacySecringFile);
            if (key != null) {
                return key;
            }
        }
        if (this.hasKeyFiles(this.userSecretKeyDir)) {
            block14: {
                if (Files.exists(this.userKeyboxPath, new LinkOption[0])) {
                    try {
                        publicKey = PgpKeyLocator.findPublicKeyInKeyBox(this.userKeyboxPath, null, this.signingKey);
                        if (publicKey != null) {
                            key = this.findSecretKeyForKeyBoxPublicKey(publicKey, this.userKeyboxPath);
                            if (key != null) {
                                return key;
                            }
                            throw new PGPException(MessageFormat.format(BCText.get().gpgNoSecretKeyForPublicKey, Long.toHexString(publicKey.getKeyID())));
                        }
                        throw new PGPException(MessageFormat.format(BCText.get().gpgNoPublicKeyFound, this.signingKey));
                    }
                    catch (NoOpenPgpKeyException noOpenPgpKeyException) {
                        if (!log.isDebugEnabled()) break block14;
                        log.debug("{} does not contain any OpenPGP keys", (Object)this.userKeyboxPath);
                    }
                }
            }
            if (Files.exists(this.userPgpPubringFile, new LinkOption[0]) && (publicKey = PgpKeyLocator.findPublicKeyInPubring(this.userPgpPubringFile, null, this.signingKey)) != null && (key = this.findSecretKeyForKeyBoxPublicKey(publicKey, this.userPgpPubringFile)) != null) {
                return key;
            }
            if (publicKey == null) {
                throw new PGPException(MessageFormat.format(BCText.get().gpgNoPublicKeyFound, this.signingKey));
            }
        }
        if (Files.exists(this.userPgpLegacySecringFile, new LinkOption[0])) {
            hasSecring = true;
            key = this.loadKeyFromSecring(this.userPgpLegacySecringFile);
            if (key != null) {
                return key;
            }
        }
        if (publicKey != null) {
            throw new PGPException(MessageFormat.format(BCText.get().gpgNoSecretKeyForPublicKey, Long.toHexString(publicKey.getKeyID())));
        }
        if (hasSecring) {
            throw new PGPException(MessageFormat.format(BCText.get().gpgNoKeyInLegacySecring, this.signingKey));
        }
        throw new PGPException(BCText.get().gpgNoKeyring);
    }

    private boolean hasKeyFiles(Path dir) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (DirectoryStream<Path> contents = Files.newDirectoryStream(dir, "*.key");){
                return contents.iterator().hasNext();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private PgpKey loadKeyFromSecring(Path secring) throws IOException, PGPException {
        PGPSecretKey secretKey = this.findSecretKeyInLegacySecring(this.signingKey, secring);
        if (secretKey != null) {
            if (!secretKey.isSigningKey()) {
                throw new PGPException(MessageFormat.format(BCText.get().gpgNotASigningKey, this.signingKey));
            }
            return new PgpKey(secretKey, secring);
        }
        return null;
    }

    private PgpKey findSecretKeyForKeyBoxPublicKey(PGPPublicKey publicKey, Path userKeyboxPath) throws PGPException, CanceledException, UnsupportedCredentialItem, URISyntaxException {
        byte[] keyGrip;
        try {
            keyGrip = KeyGrip.getKeyGrip((PGPPublicKey)publicKey);
        }
        catch (PGPException e) {
            throw new PGPException(MessageFormat.format(BCText.get().gpgNoKeygrip, Hex.toHexString((byte[])publicKey.getFingerprint())), (Exception)((Object)e));
        }
        String filename = String.valueOf(Hex.toHexString((byte[])keyGrip).toUpperCase(Locale.ROOT)) + ".key";
        Path keyFile = this.userSecretKeyDir.resolve(filename);
        if (!Files.exists(keyFile, new LinkOption[0])) {
            return null;
        }
        try {
            PGPSecretKey secretKey;
            PGPDigestCalculatorProvider calculatorProvider = new JcaPGPDigestCalculatorProviderBuilder().build();
            try {
                PgpPassphraseFinder passphraseFinder = new PgpPassphraseFinder();
                secretKey = this.attemptParseSecretKey(keyFile, calculatorProvider, () -> passphraseFinder.getPassphrase(this.gpgHomedir, publicKey.getKeyID()), publicKey);
            }
            catch (PGPException e) {
                throw new PGPException(MessageFormat.format(BCText.get().gpgFailedToParseSecretKey, keyFile.toAbsolutePath()), (Exception)((Object)e));
            }
            if (secretKey != null) {
                if (!secretKey.isSigningKey()) {
                    throw new PGPException(MessageFormat.format(BCText.get().gpgNotASigningKey, this.signingKey));
                }
                return new PgpKey(secretKey, userKeyboxPath);
            }
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            return null;
        }
        catch (IOException e) {
            throw new PGPException(MessageFormat.format(BCText.get().gpgFailedToParseSecretKey, keyFile.toAbsolutePath()), (Exception)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private PGPSecretKey findSecretKeyInLegacySecring(String signingkey, Path secringFile) throws IOException, PGPException {
        var3_3 = null;
        var4_5 = null;
        try {
            in = Files.newInputStream(secringFile, new OpenOption[0]);
            try {
                pgpSec = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)new BufferedInputStream(in)), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                keyId = PgpKeyLocator.toFingerprint(signingkey).toLowerCase(Locale.ROOT);
                keyrings = pgpSec.getKeyRings();
                while (true) {
                    keyRing = (PGPSecretKeyRing)keyrings.next();
                    keys = keyRing.getSecretKeys();
                    while (keys.hasNext()) {
                        key = (PGPSecretKey)keys.next();
                        if (signingkey.equals("@first")) {
                            return key;
                        }
                        fingerprint = Hex.toHexString((byte[])key.getPublicKey().getFingerprint()).toLowerCase(Locale.ROOT);
                        if (fingerprint.endsWith(keyId)) {
                            return key;
                        }
                        userIDs = key.getUserIDs();
                        while (userIDs.hasNext()) {
                            userId = (String)userIDs.next();
                            if (!PgpKeyLocator.containsSigningKey(userId, this.signingKey)) continue;
                            return key;
                        }
                    }
                    break;
                }
            }
            finally {
                if (keyrings.hasNext()) ** continue;
            }
        }
        catch (Throwable var4_6) {
            if (var3_3 == null) {
                var3_3 = var4_6;
            } else if (var3_3 != var4_6) {
                var3_3.addSuppressed(var4_6);
            }
            throw var3_3;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static PGPPublicKey findPublicKeyInPubring(Path pubringFile, String keyId, String keySpec) throws IOException, PGPException {
        try {
            var3_3 = null;
            var4_5 = null;
            try {
                in = Files.newInputStream(pubringFile, new OpenOption[0]);
                try {
                    pgpPub = new PGPPublicKeyRingCollection((InputStream)new BufferedInputStream(in), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                    id = keyId != null ? keyId : PgpKeyLocator.toFingerprint(keySpec).toLowerCase(Locale.ROOT);
                    keyrings = pgpPub.getKeyRings();
                    while (true) {
                        keyRing = (PGPPublicKeyRing)keyrings.next();
                        keys = keyRing.getPublicKeys();
                        while (keys.hasNext()) {
                            key = (PGPPublicKey)keys.next();
                            fingerprint = Hex.toHexString((byte[])key.getFingerprint()).toLowerCase(Locale.ROOT);
                            if (fingerprint.endsWith(id)) {
                                return key;
                            }
                            userIDs = key.getUserIDs();
                            while (userIDs.hasNext()) {
                                userId = (String)userIDs.next();
                                if (!PgpKeyLocator.containsSigningKey(userId, keySpec)) continue;
                                return key;
                            }
                        }
                        break;
                    }
                }
                finally {
                    if (keyrings.hasNext()) ** continue;
                }
            }
            catch (Throwable var4_6) {
                if (var3_3 == null) {
                    var3_3 = var4_6;
                } else if (var3_3 != var4_6) {
                    var3_3.addSuppressed(var4_6);
                }
                throw var3_3;
            }
        }
        catch (FileNotFoundException | NoSuchFileException v0) {}
        return null;
    }

    private static PGPPublicKey getPublicKey(KeyBlob blob, byte[] fingerprint) throws IOException {
        return ((PublicKeyRingBlob)blob).getPGPPublicKeyRing().getPublicKey(fingerprint);
    }

    private static PGPPublicKey getSigningPublicKey(KeyBlob blob) throws IOException {
        PGPPublicKey masterKey = null;
        Iterator keys = ((PublicKeyRingBlob)blob).getPGPPublicKeyRing().getPublicKeys();
        while (keys.hasNext()) {
            PGPPublicKey key = (PGPPublicKey)keys.next();
            if (!PgpKeyLocator.isSigningKey(key)) continue;
            if (key.isMasterKey()) {
                masterKey = key;
                continue;
            }
            return key;
        }
        return masterKey;
    }

    private static boolean isSigningKey(PGPPublicKey key) {
        Iterator signatures = key.getSignatures();
        while (signatures.hasNext()) {
            PGPSignature sig = (PGPSignature)signatures.next();
            if ((sig.getHashedSubPackets().getKeyFlags() & 2) <= 0) continue;
            return true;
        }
        return false;
    }

    private static KeyBox readKeyBoxFile(Path keyboxFile) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, NoOpenPgpKeyException {
        JcaKeyBox keyBox;
        if (keyboxFile.toFile().length() == 0L) {
            throw new NoOpenPgpKeyException();
        }
        Throwable throwable = null;
        Object var3_3 = null;
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(keyboxFile, new OpenOption[0]));){
            keyBox = new JcaKeyBoxBuilder().build((InputStream)in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return keyBox;
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        String os = System.getProperty("os.name").replace("Mac OS X", "Darwin");
        String osVersion = System.getProperty("os.version");
        if (os.equals("Darwin")) {
            CliCommand macVersion = new CliCommand("sw_vers", true);
            CliCommand.Result macVersionResult = macVersion.execute();
            Pattern pattern = Pattern.compile("(?!\\.)(\\d+(\\.\\d+)+)(?![\\d\\.])$", 8);
            Matcher matcher = pattern.matcher(macVersionResult.getStdout());
            if (matcher.find()) {
                osVersion = matcher.group(1);
            }
        }
        String arch = System.getProperty("os.arch");
        String id = String.format("gpg-%s-%s-%s-%s", "2.2.34", os, osVersion, arch);
        System.out.println(id);
        CliCommand gpg = new CliCommand("gpg --version", true);
        CliCommand.Result result = gpg.execute();
        System.out.println(result.getStdout());
        PgpKeyLocator locator = new PgpKeyLocator(ImmutablePgpSigningRequest.builder().build());
        PGPSecretKey secretKey = locator.findSecretKey().getSecretKey();
        if (secretKey != null) {
            System.out.println("Found key: " + Long.toHexString(secretKey.getKeyID() & 0xFFFFFFFFL).toUpperCase());
        }
    }

    private static class NoOpenPgpKeyException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private NoOpenPgpKeyException() {
        }
    }
}

