/*
 * Decompiled with CFR 0.152.
 */
package io.takari.jpgp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtils {
    private static final int BUFFER_SIZE = 4096;

    public static void copy(InputStream inputStream, OutputStream outputStream, byte[] buffer, StreamHandler addtionalHandling) throws IOException {
        IOUtils.process(inputStream, (buffer1, offset, length) -> {
            outputStream.write(buffer1, offset, length);
            if (addtionalHandling != null) {
                addtionalHandling.handleStreamBuffer(buffer1, offset, length);
            }
        }, buffer);
    }

    public static void process(InputStream inputStream, StreamHandler handler) throws IOException {
        IOUtils.process(inputStream, handler, new byte[4096]);
    }

    public static void process(InputStream inputStream, StreamHandler handler, byte[] buffer) throws IOException {
        int read;
        while ((read = inputStream.read(buffer)) != -1) {
            handler.handleStreamBuffer(buffer, 0, read);
        }
    }

    public static interface StreamHandler {
        public void handleStreamBuffer(byte[] var1, int var2, int var3) throws IOException;
    }
}

