/*
 * Decompiled with CFR 0.152.
 */
package io.takari.jpgp;

import io.takari.jpgp.PgpKeyRingLoader;
import io.takari.jpgp.PgpMessageSigner;
import io.takari.jpgp.passphrase.FilePassphraseSource;
import io.takari.jpgp.passphrase.GpgAgentPassphraseSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpArtifactSigner {
    private static final File dotGnupgDirectory = new File(System.getProperty("user.home"), ".gnupg");
    private static final Logger logger = LoggerFactory.getLogger(PgpArtifactSigner.class);
    private final PgpKeyRingLoader keyRingLoader = new PgpKeyRingLoader();
    private final PGPSecretKey secretKey = this.keyRingLoader.load(new File(dotGnupgDirectory, "secring.gpg"));
    private final PgpMessageSigner signer = new PgpMessageSigner();

    public File sign(File file) throws IOException, PGPException {
        return this.sign(file, this.findPassphrase());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File sign(File file, String passphrase) throws IOException, PGPException {
        File signatureFile = new File(file.getParentFile(), String.valueOf(file.getName()) + ".asc");
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            FileInputStream inputStream = new FileInputStream(file);
            try {
                try (FileOutputStream outputStream = new FileOutputStream(signatureFile);){
                    this.signer.signMessage(this.secretKey, this.findPassphrase(), inputStream, outputStream);
                }
                if (inputStream == null) return signatureFile;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (inputStream == null) throw throwable;
                ((InputStream)inputStream).close();
                throw throwable;
            }
            ((InputStream)inputStream).close();
            return signatureFile;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private String findPassphrase() throws IOException {
        logger.info("No passphrase provided so searching with configured loaders:");
        logger.info("Looking for envar PGP_PASSPHRASE for passphrase.");
        String passphrase = System.getenv("PGP_PASSPHRASE");
        if (passphrase != null) {
            logger.info("Found passphrase in envar PGP_PASSPHRASE.");
            return passphrase;
        }
        logger.info("Looking in ~/.gnupg/.jpgp for passphrase.");
        passphrase = new FilePassphraseSource(new File(System.getProperty("user.home"), ".gnupg/.jpgp.passphrase")).load(this.secretKey);
        if (passphrase != null) {
            logger.info("Found passphrase ~/.gnupg/.jpgp.passphrase");
            return passphrase;
        }
        logger.info("Asking pgp agent for passphrase.");
        passphrase = new GpgAgentPassphraseSource().load(this.secretKey);
        if (passphrase != null) {
            logger.info("Found passphrase from gpg agent.");
            return passphrase;
        }
        return passphrase;
    }
}

