/*
 * Decompiled with CFR 0.152.
 */
package io.takari.jpgp;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Date;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyPair;

public class PgpKeyPairGenerator {
    int[] preferredEncryptionAlgos = new int[]{9, 8, 7};
    int[] preferredHashAlgos = new int[]{10, 9, 8};
    int[] preferredCompressionAlgos;

    public PgpKeyPairGenerator() {
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 3;
        nArray[2] = 2;
        this.preferredCompressionAlgos = nArray;
    }

    private PGPKeyRingGenerator createKeyRingGenerator(String userId, String password, int keySize) {
        PGPKeyRingGenerator generator;
        try {
            RSAKeyPairGenerator generator1 = new RSAKeyPairGenerator();
            generator1.init((KeyGenerationParameters)new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), new SecureRandom(), keySize, 12));
            BcPGPKeyPair signingKeyPair = new BcPGPKeyPair(3, generator1.generateKeyPair(), new Date());
            BcPGPKeyPair encryptionKeyPair = new BcPGPKeyPair(2, generator1.generateKeyPair(), new Date());
            PGPSignatureSubpacketGenerator signatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
            signatureSubpacketGenerator.setKeyFlags(false, 3);
            signatureSubpacketGenerator.setPreferredSymmetricAlgorithms(false, this.preferredEncryptionAlgos);
            signatureSubpacketGenerator.setPreferredHashAlgorithms(false, this.preferredHashAlgos);
            signatureSubpacketGenerator.setPreferredCompressionAlgorithms(false, this.preferredCompressionAlgos);
            PGPSignatureSubpacketGenerator encryptionSubpacketGenerator = new PGPSignatureSubpacketGenerator();
            encryptionSubpacketGenerator.setKeyFlags(false, 12);
            generator = new PGPKeyRingGenerator(3, (PGPKeyPair)signingKeyPair, userId, new BcPGPDigestCalculatorProvider().get(2), signatureSubpacketGenerator.generate(), null, (PGPContentSignerBuilder)new BcPGPContentSignerBuilder(3, 8), new BcPBESecretKeyEncryptorBuilder(9).build(password.toCharArray()));
            generator.addSubKey((PGPKeyPair)encryptionKeyPair, encryptionSubpacketGenerator.generate(), null);
        }
        catch (PGPException pGPException) {
            generator = null;
        }
        return generator;
    }

    public boolean generateKeyPair(String userId, String password, int keySize, OutputStream publicKey, OutputStream secrectKey) {
        ArmoredOutputStream targetStream;
        Object var11_13;
        Throwable throwable;
        boolean result = true;
        PGPKeyRingGenerator keyRingGenerator = this.createKeyRingGenerator(userId, password, keySize);
        PGPPublicKeyRing publicKeyRing = keyRingGenerator.generatePublicKeyRing();
        PGPSecretKeyRing secretKeyRing = keyRingGenerator.generateSecretKeyRing();
        try {
            throwable = null;
            var11_13 = null;
            try {
                targetStream = new ArmoredOutputStream(publicKey);
                try {
                    publicKeyRing.encode((OutputStream)targetStream);
                }
                finally {
                    if (targetStream != null) {
                        targetStream.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            result = false;
        }
        try {
            throwable = null;
            var11_13 = null;
            try {
                targetStream = new ArmoredOutputStream(secrectKey);
                try {
                    PGPSecretKeyRingCollection secretKeyRingCollection = new PGPSecretKeyRingCollection(Arrays.asList(secretKeyRing));
                    secretKeyRingCollection.encode((OutputStream)targetStream);
                }
                finally {
                    if (targetStream != null) {
                        targetStream.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException | PGPException throwable4) {
            result = false;
        }
        return result;
    }
}

